/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebBusiness.util.OlapUtils;

public class DynamicComputingServiceHelper {
    private static final String[] members = new String[]{"CC", "ADJ", "PC", "IRpt", "CS"};
    private static final String[] memberss = new String[]{"EntityInput", "EntityInputTraDif", "TraDif", "ADJE"};

    public static Long getUserId() {
        return UserUtils.getUserId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockUpgradeModel(long modelId) {
        boolean isTrue = true;
        DLock lock = DLock.create((String)"DynamicComputingServiceHelper");
        try {
            if (lock.tryLock(10000L)) {
                QFilter filter = new QFilter("model", "=", (Object)modelId);
                DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"eb_configsetting", (String)"number, model, config", (QFilter[])new QFilter[]{filter});
                if (config == null) {
                    DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)"eb_configsetting");
                    temp.set("number", (Object)"CM006");
                    temp.set("name", (Object)ResManager.loadKDString((String)"\u662f\u5426\u542f\u7528\u52a8\u6001\u8ba1\u7b97", (String)"DynamicComputingServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
                    temp.set("config", (Object)1);
                    temp.set("description", (Object)ResManager.loadKDString((String)"\u662f\u5426\u542f\u7528\u52a8\u6001\u8ba1\u7b97", (String)"DynamicComputingServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
                    temp.set("model", (Object)modelId);
                    temp.set("modifier", (Object)DynamicComputingServiceHelper.getUserId());
                    temp.set("modifytime", (Object)new Date());
                    temp.set("createtime", (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
                } else {
                    config.set("config", (Object)isTrue);
                }
                DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
                DynamicComputingServiceHelper.updateModel(modelId, model.getString("number"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public static void upgradeAllModel() {
        QFilter appfilter = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.getOIndex()).or("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_model", (String)"id,number", (QFilter[])new QFilter[]{appfilter});
        for (DynamicObject model : doc) {
            long modelId = model.getLong("id");
            String modelNum = model.getString("number");
            DynamicComputingServiceHelper.updateModel(modelId, modelNum);
        }
    }

    private static void updateModel(long modelId, String modelNum) {
        DynamicObjectCollection dimCollection = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, membermodel", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        for (DynamicObject dimObj : dimCollection) {
            String dimNum = dimObj.getString("number");
            String memberform = dimObj.getString("membermodel");
            DynamicObjectCollection memCollection = QueryServiceHelper.query((String)memberform, (String)"id, number, parent.id, aggoprt, isleaf, storagetype", (QFilter[])new QFilter("model", "=", (Object)modelId).and(new QFilter("dimension", "=", (Object)dimObj.getLong("id"))).and(new QFilter("status", "!=", (Object)"A")).toArray());
            DynamicComputingServiceHelper.repairModelByScope(modelNum, dimNum, false, memCollection);
        }
    }

    public static void repairModelByScope(String modelNum, String dimNum, boolean isAll, DynamicObjectCollection memCollection) {
        ArrayList<String> numbers = new ArrayList<String>();
        memCollection.forEach(memObject -> {
            String storageType = memObject.getString("storagetype");
            if (!StorageTypeEnum.SHARE.getOIndex().equals(storageType)) {
                numbers.add(memObject.getString("number"));
                if (isAll || !memObject.getBoolean("isleaf")) {
                    List childrenList = memCollection.stream().filter(e -> e.getLong("parent.id") == memObject.getLong("id")).collect(Collectors.toList());
                    ArrayList factorList = Lists.newArrayListWithExpectedSize((int)childrenList.size());
                    ArrayList<String> nums = new ArrayList<String>(childrenList.size());
                    for (DynamicObject child : childrenList) {
                        String number = child.getString("number");
                        if (nums.contains(number)) continue;
                        nums.add(number);
                        int aggoprt = child.getInt("aggoprt");
                        AggFactorMetadataItem aggFactorMetadataItem = OlapUtils.createAggFactorMetadataItem(number, aggoprt);
                        factorList.add(aggFactorMetadataItem);
                    }
                    String parentNum = memObject.getString("number");
                    OlapServiceHelper.repairAggFactor(modelNum, dimNum, parentNum, factorList);
                    if (storageType.equalsIgnoreCase("2") || storageType.equalsIgnoreCase("4")) {
                        OlapServiceHelper.alterMemberStorageType(modelNum, dimNum, parentNum, MemberStorageTypes.Stored);
                    } else if (storageType.equalsIgnoreCase("5")) {
                        OlapServiceHelper.alterMemberStorageType(modelNum, dimNum, parentNum, MemberStorageTypes.DynamicCalc);
                    }
                }
            }
        });
        if (!isAll && DimEntityNumEnum.ENTITY.getNumber().equals(dimNum)) {
            OlapServiceHelper.repairEntityWithParentFactor(modelNum, numbers, isAll);
        }
    }
}

