/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.constant.BCMConstant;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.ebBusiness.util.ModelDataClearUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportJsonServiceHelper {
    private static List<String> skipTable = Arrays.asList("T_BCM_REPORT", "T_BCM_reportlist", "t_bcm_brexecinfo", "t_bcm_chkreport", "t_bcm_mergeprogress", "t_bcm_datacollectlog", "t_bcm_schemecollectlog", "t_bcm_datasource", "t_bcm_rptadjust", "t_bcm_isscheme", "t_bcm_issinglemap", "t_bcm_isproduct", "t_bcm_schemeeassign", "t_bcm_isgroupmap", "t_bcm_schemeexecuterec", "t_bcm_isbaseentlist", "t_bcm_taskcatalog", "t_bcm_taskconf", "t_bcm_userdistribute", "t_bcm_taskdisptem", "t_bcm_taskexplain", "t_bcm_taskforpre", "t_bcm_taskparam", "t_bcm_taskstatus", "t_bcm_checkrecord", "t_bcm_bizruleversion", "t_bcm_dimmembermapping", "t_bcm_iseasmap", "t_bcm_memberperm", "t_bcm_dimmapping", "t_bcm_dimcombmapping", "t_bcm_modelperm", "t_bcm_convertscheme", "t_bcm_mergecontrolentity", "t_bcm_rptadjustdata", "t_bcm_entitynamerecord_l", "t_bcm_entitybizrecord", "t_bcm_entitynamerecord", "t_bcm_adjustdatamapping", "t_bcm_userselect", "t_bcm_modelolap_record", "t_bcm_datacollect", "t_bcm_analysolusavelog", "t_bcm_modelolap_record_l", "T_isv_xxx");

    public static JSONObject getModel(String entityName, String modelId) {
        JSONObject jsonData = new JSONObject(new LinkedHashMap());
        Set<String> getAllEntityTable = ModelDataClearUtils.getAllEntityTable();
        for (String entity : getAllEntityTable) {
            boolean isExit;
            String tableNumber;
            if ("bcm_analysischart".equalsIgnoreCase(entity.toLowerCase()) || "bcm_editdescription".equalsIgnoreCase(entity.toLowerCase()) || StringUtils.isEmpty((CharSequence)(tableNumber = EntityMetadataCache.getDataEntityType((String)entity).getAlias())) || skipTable.stream().anyMatch(p -> p.equalsIgnoreCase(tableNumber)) || !(isExit = DB.exitsTable((DBRoute)new DBRoute("bcm"), (String)tableNumber))) continue;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (entity.equals("epm_model")) {
                JSONObject strJson = ExportJsonServiceHelper.getJsonModel(entity, modelId, "fid");
                jsonData.put(entity, (Object)strJson);
                continue;
            }
            if (mainEntityType.getAllFields().get("model") == null) continue;
            String columnName = ((IDataEntityProperty)mainEntityType.getProperties().get((Object)"model")).getAlias();
            JSONObject strJson = ExportJsonServiceHelper.getJsonModel(entity, modelId, columnName);
            jsonData.put(entity, (Object)strJson);
        }
        return jsonData;
    }

    public static String downloadJsonFile(String jsonData, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(jsonData.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".json", (InputStream)inStream, 10000);
    }

    public static JSONObject getJsonModel(String entityName, String id, String field) {
        JSONObject jsonObject = new JSONObject(new LinkedHashMap());
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        String tableName = dynamicObject.getDataEntityType().getAlias();
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return null;
        }
        JSONArray jsonArr = ExportJsonServiceHelper.getJsonByTable(tableName, field, id);
        if (jsonArr == null || jsonArr.isEmpty()) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        List colNumbers = (List)jsonArr.get(0);
        int index = colNumbers.indexOf("FID");
        if (index != -1) {
            for (int i = 1; i < jsonArr.size(); ++i) {
                ids.add((String)((List)jsonArr.get(i)).get(index));
            }
        }
        String strIds = ExportJsonServiceHelper.getPlaceholder(ids);
        jsonObject.put(tableName.toLowerCase(), (Object)jsonArr);
        DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : dataEntityPropertyCollection) {
            JSONArray jsonArrmulti;
            String multialias;
            if (iDataEntityProperty instanceof DynamicLocaleProperty && StringUtils.isNotEmpty((CharSequence)(multialias = ((DynamicLocaleProperty)iDataEntityProperty).getItemType().getAlias()))) {
                jsonArrmulti = ExportJsonServiceHelper.getJsonByTable(multialias, "FID", strIds);
                jsonObject.put(multialias.toLowerCase(), (Object)jsonArrmulti);
            }
            if (iDataEntityProperty instanceof MulBasedataProp && StringUtils.isNotEmpty((CharSequence)(multialias = ((MulBasedataProp)iDataEntityProperty).getItemType().getAlias()))) {
                jsonArrmulti = ExportJsonServiceHelper.getJsonByTable(multialias, "FID", strIds);
                jsonObject.put(multialias.toLowerCase(), (Object)jsonArrmulti);
            }
            if (!(iDataEntityProperty instanceof EntryProp)) continue;
            String alias = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType().getAlias();
            String primaryKey = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType().getPrimaryKey().getAlias().toUpperCase();
            ArrayList<String> fentryids = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)alias)) {
                JSONArray jsonArrentry = ExportJsonServiceHelper.getJsonByTable(alias, "fid", strIds);
                if (jsonArrentry == null || jsonArrentry.isEmpty()) continue;
                int primaryKeyIndex = ((List)jsonArrentry.get(0)).indexOf(primaryKey);
                if (primaryKeyIndex != -1) {
                    for (int i = 1; i < jsonArrentry.size(); ++i) {
                        fentryids.add((String)((List)jsonArrentry.get(i)).get(primaryKeyIndex));
                    }
                }
                jsonObject.put(alias.toLowerCase(), (Object)jsonArrentry);
            }
            DataEntityPropertyCollection entryCollection = ((EntryProp)iDataEntityProperty).getItemType().getProperties();
            for (IDataEntityProperty entry : entryCollection) {
                String strEntryIds;
                JSONArray jsonArrentrySub;
                String entitymultialias;
                if (entry instanceof DynamicLocaleProperty && StringUtils.isNotEmpty((CharSequence)(entitymultialias = ((DynamicLocaleProperty)entry).getItemType().getAlias()))) {
                    String strEntryIds2 = ExportJsonServiceHelper.getPlaceholder(fentryids);
                    JSONArray jsonArrentrymulti = ExportJsonServiceHelper.getJsonByTable(entitymultialias, primaryKey, strEntryIds2);
                    jsonObject.put(entitymultialias.toLowerCase(), (Object)jsonArrentrymulti);
                }
                if (!(entry instanceof SubEntryProp)) continue;
                ArrayList<String> fdetailids = new ArrayList<String>();
                String subentryAlias = ((SubEntryProp)entry).getItemType().getAlias();
                String sub_pk = ((SubEntryProp)entry).getItemType().getPrimaryKey().getAlias().toUpperCase();
                if (StringUtils.isEmpty((CharSequence)subentryAlias) || (jsonArrentrySub = ExportJsonServiceHelper.getJsonByTable(subentryAlias, primaryKey, strEntryIds = ExportJsonServiceHelper.getPlaceholder(fentryids))) == null || jsonArrentrySub.isEmpty()) continue;
                int sub_pkIndex = ((List)jsonArrentrySub.get(0)).indexOf(primaryKey);
                if (sub_pkIndex != -1) {
                    for (int i = 1; i < jsonArrentrySub.size(); ++i) {
                        fdetailids.add((String)((List)jsonArrentrySub.get(i)).get(sub_pkIndex));
                    }
                }
                jsonObject.put(subentryAlias, (Object)jsonArrentrySub);
                DataEntityPropertyCollection subCols = ((SubEntryProp)entry).getItemType().getProperties();
                for (IDataEntityProperty col : subCols) {
                    String submultialias;
                    if (!(col instanceof DynamicLocaleProperty) || !StringUtils.isNotEmpty((CharSequence)(submultialias = ((DynamicLocaleProperty)col).getItemType().getAlias()))) continue;
                    String strDetailIds = ExportJsonServiceHelper.getPlaceholder(fdetailids);
                    JSONArray jsonArrentrySubmulti = ExportJsonServiceHelper.getJsonByTable(submultialias, sub_pk, strDetailIds);
                    jsonObject.put(submultialias.toLowerCase(), (Object)jsonArrentrySubmulti);
                }
            }
        }
        return jsonObject;
    }

    private static String getPlaceholder(List<String> ids) {
        StringBuilder strId = new StringBuilder();
        for (String str : ids) {
            strId.append('\'');
            strId.append(str);
            strId.append("',");
        }
        return strId.substring(0, strId.length() - 1);
    }

    public static JSONArray resultSetToJsonArry(DataSet result) {
        JSONArray array = new JSONArray();
        ArrayList<String> colNumbers = new ArrayList<String>();
        boolean putCol = false;
        while (result.hasNext()) {
            RowMeta row = result.getRowMeta();
            int columnCount = row.getFieldCount();
            if (!putCol) {
                for (int i = 0; i < columnCount; ++i) {
                    String field = row.getFieldName(i);
                    colNumbers.add(field.toUpperCase());
                }
                array.add(colNumbers);
                putCol = true;
            }
            Row rowData = result.next();
            int rowDataCount = rowData.size();
            ArrayList<String> values = new ArrayList<String>();
            if (columnCount != rowDataCount) continue;
            for (int i = 0; i < columnCount; ++i) {
                String value = rowData.getString(i);
                values.add(value);
            }
            array.add(values);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONArray getJsonByTable(String table, String field, String param) {
        DataSet result;
        String sql = "";
        JSONArray jsonArr = new JSONArray();
        List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)table);
        if (columnNames.size() <= 0) {
            return null;
        }
        String selectFields = String.join((CharSequence)",", columnNames).toUpperCase();
        if (selectFields.contains(field.toUpperCase())) {
            sql = "select " + selectFields + " from " + table + " where " + field + " in (" + param + ")";
        }
        if (table.equalsIgnoreCase("t_bcm_structofent")) {
            sql = sql + " and (fisexchangerate != 1 or FLONGNUMBER = 'Entity!RatePreset')";
        }
        if ((result = DB.queryDataSet((String)ExportJsonServiceHelper.class.getName(), (DBRoute)BCMConstant.DBROUTE, (String)sql)).hasNext()) {
            try {
                jsonArr = ExportJsonServiceHelper.resultSetToJsonArry(result);
            }
            finally {
                result.close();
            }
        }
        return jsonArr;
    }
}

