/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MemberTreeNode {
    private Long id;
    private String number;
    private String name;
    private Long copyFromId;
    private MemberTreeNode parent;
    private List<MemberTreeNode> children;
    private Map<String, Object> data;

    public MemberTreeNode(Long id, String number, String name, Long copyFromId) {
        this.id = id;
        this.number = number;
        this.name = name;
        this.copyFromId = copyFromId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void addChild(MemberTreeNode id) {
        if (this.children == null) {
            this.children = new ArrayList<MemberTreeNode>();
        }
        this.children.add(id);
    }

    public MemberTreeNode getParent() {
        return this.parent;
    }

    public void setParent(MemberTreeNode parent) {
        this.parent = parent;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Long getCopyFromId() {
        return this.copyFromId;
    }

    public List<MemberTreeNode> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public List<MemberTreeNode> getAllChildren(int childType) {
        ArrayList<MemberTreeNode> nodes = new ArrayList<MemberTreeNode>();
        if (this.children == null) {
            return nodes;
        }
        for (MemberTreeNode node : this.children) {
            switch (childType) {
                case 0: {
                    nodes.add(node);
                    break;
                }
                case 1: {
                    if (node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 2: {
                    if (!node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
            }
            if (node.isLeaf()) continue;
            nodes.addAll(node.getAllChildren(childType));
        }
        return nodes;
    }

    public List<MemberTreeNode> getDescendants() {
        return this.getAllChildren(0);
    }

    public List<MemberTreeNode> getSiblings() {
        ArrayList<MemberTreeNode> ids = new ArrayList<MemberTreeNode>();
        if (this.getParent() == null) {
            return ids;
        }
        for (MemberTreeNode node : this.getParent().getChildren()) {
            if (node.getId().equals(this.id)) continue;
            ids.add(node);
        }
        return ids;
    }
}

