/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.dataSources.AggShieldRuleBlackListMetadataItem;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebComputing.ComputingEngine;
import kd.epm.eb.common.ebComputing.bizrule.BizRuleExecParam;
import kd.epm.eb.common.ebComputing.datasource.IOutline;
import kd.epm.eb.common.ebComputing.datasource.Outline;
import kd.epm.eb.common.ebComputing.util.RuleExecuteServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.ebBusiness.mq.MQMessagePublisherServiceHelper;
import kd.epm.eb.ebBusiness.olap.shield.ShieldRuleBulider;
import kd.epm.eb.ebBusiness.scale.CurrencyScaleHandler;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.ConfigServiceHelper;
import kd.epm.eb.ebBusiness.sql.CellSetResultSet;
import kd.epm.eb.ebBusiness.sql.MDResultSet;
import kd.epm.eb.ebBusiness.sql.SQLBuilder;
import kd.epm.eb.ebBusiness.sql.exception.MDQueryException;
import kd.epm.eb.ebBusiness.util.OlapUtils;

public final class OlapServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, OlapServiceHelper.class);

    public static void clearDimMemberCache(String cubecatalog, String dimNumber) {
        MQMessagePublisherServiceHelper.publishClearDimMemberCache(cubecatalog, dimNumber);
        if (PresetConstant.ENTITY_DIM.equals(dimNumber)) {
            MQMessagePublisherServiceHelper.publishInvalidateTemplateDispense(cubecatalog);
        }
    }

    public static void clearDimensionCache(String cubcatalog) {
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey("dim-number-short-" + cubcatalog);
    }

    private static void checkCubeCatalogIsNotNull(String cubecatalog) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)cubecatalog), (Object)ResManager.loadKDString((String)"\u521b\u5efaCube\u65b9\u6848\u65f6,\u63d0\u4f9b\u7684\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    public static void saveData(SaveCommandInfo info, CellSet cellSets, String cubecatalog) {
        OlapServiceHelper.saveData(info, cellSets, cubecatalog, false);
    }

    public static void saveData(SaveCommandInfo info, CellSet cellSets, String cubecatalog, boolean isNeedMonitorDataStatus) {
        OlapServiceHelper.saveData(info, cellSets, cubecatalog, isNeedMonitorDataStatus, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveData(SaveCommandInfo info, CellSet cellSets, String cubecatalog, boolean isNeedMonitorDataStatus, boolean isNeedHandleCurrency) {
        if (isNeedHandleCurrency) {
            CurrencyScaleHandler.handle(info, cellSets, cubecatalog);
        } else {
            CurrencyScaleHandler.handleToOlapScale(info, cellSets);
        }
        try {
            OlapServiceHelper.saveCore(info, cellSets, cubecatalog);
            if (!isNeedMonitorDataStatus) return;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u4fdd\u5b58\u5931\u8d25 %1", (String)"OlapServiceHelper_01", (String)"epm-eb-spread", (Object[])new Object[]{e.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCore(SaveCommandInfo info, CellSet cellSets, String cubecatalog) {
        OlapDataWriter writer = null;
        OlapConnection conn = OlapServiceHelper.getOlapConnection(cubecatalog);
        try {
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)info);
            writer = cmd.CreateWriter();
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"save");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"save");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"save", info});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", info.toString());
                }
                ts.addTag("route", cubecatalog);
                ts.addTag("count", String.valueOf(cellSets.getCount()));
                cellSets.Save(writer);
            }
            catch (Exception ex) {
                log.error("eb-data-save", (Throwable)ex);
                throw ex;
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close((Object[])new Object[]{conn});
            throw throwable;
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object> queryData(SelectCommandInfo queryInfo, String cubecatalog) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> queryDataCoreByApp(SelectCommandInfo queryInfo, String cubecatalog) {
        Map<String, Object> rst = new HashMap<String, Object>();
        if (cubecatalog == null) {
            return rst;
        }
        rst = OlapServiceHelper.queryDataCore(queryInfo, cubecatalog);
        return rst;
    }

    private static Map<String, Object> queryDataCore(SelectCommandInfo queryInfo, String cubecatalog) {
        HashMap<String, Object> hashMap;
        OlapConnection conn = null;
        OlapDataReader cs = null;
        int entityindex = -1;
        for (int i = 0; i < queryInfo.getDimensions().size(); ++i) {
            if (!DimTypesEnum.ENTITY.getNumber().equals(queryInfo.getDimensions().get(i))) continue;
            entityindex = i;
        }
        try {
            conn = OlapServiceHelper.getOlapConnection(cubecatalog);
            conn.Open();
            queryInfo.setExcludeNull(true);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            cs = cmd.ExecuteReader();
            HashMap<String, Object> cellSets = new HashMap<String, Object>(cs.getFieldCount());
            List list = queryInfo.getMeasures();
            Object[] values = new Object[queryInfo.getDimensions().size() + list.size()];
            StringBuilder sb = new StringBuilder();
            int n = entityindex = entityindex != -1 ? entityindex + list.size() : entityindex;
            while (cs.next()) {
                cs.getValues(values);
                int size = values.length;
                for (int i = list.size(); i < size; ++i) {
                    if (i == entityindex) {
                        String keyv = values[i].toString();
                        sb.append(keyv.contains("_") ? keyv.split("_")[1] : keyv);
                        continue;
                    }
                    sb.append(values[i]);
                }
                cellSets.put(sb.toString(), values[0]);
                sb.setLength(0);
            }
            hashMap = cellSets;
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw new MDQueryException(ResManager.loadResFormat((String)"olap\u67e5\u8be2\u5931\u8d25 %1", (String)"OlapServiceHelper_02", (String)"epm-eb-spread", (Object[])new Object[]{e.getMessage()}), e);
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{cs, conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close((Object[])new Object[]{cs, conn});
        return hashMap;
    }

    public static MDResultSet queryData(SQLBuilder sql) {
        MDResultSet mDResultSet;
        if (sql.isCancel()) {
            return null;
        }
        sql.checkSelf();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(sql.getSelectField());
        queryInfo.addMeasures(sql.getMeasures());
        sql.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        if (sql.getTop() > 0) {
            queryInfo.setTop(sql.getTop());
        }
        OlapConnection conn = null;
        OlapDataReader cs = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(sql.getCubecatalog());
            conn.Open();
            queryInfo.setExcludeNull(true);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            cs = cmd.ExecuteReader();
            MDResultSet rs = new MDResultSet();
            CellSetResultSet set = new CellSetResultSet(cs, queryInfo);
            set.setIncludeNull(sql.getTop() > 0 || sql.isIncludeNull());
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"query");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"query");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"query", queryInfo});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", queryInfo.toString());
                }
                ts.addTag("route", sql.getCubecatalog());
                rs.populate(set);
                ts.addTag("count", String.valueOf(rs.getCount()));
            }
            mDResultSet = rs;
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"olap\u67e5\u8be2\u5931\u8d25 %1", (String)"OlapServiceHelper_02", (String)"epm-eb-spread", (Object[])new Object[]{e.getMessage()}));
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{cs, conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close((Object[])new Object[]{cs, conn});
        return mDResultSet;
    }

    public static void dropDimensionMember(String cubecatalog, String dimNum, String memNum) {
        OlapServiceHelper.batchDropDimensionMembersForce(cubecatalog, dimNum, Lists.newArrayList((Object[])new String[]{memNum}));
    }

    public static void batchDropDimensionMembers(String cubecatalog, String dimNum, Collection<String> members) {
        OlapServiceHelper.batchDropDimensionMembersForce(cubecatalog, dimNum, members);
    }

    public static void batchDropDimensionMembersForce(String cubecatalog, String dimNum, Collection<String> members) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubecatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubecatalog + "." + dimNum);
        cmd.getProperties().set("allowDropMemberWhenRowReferenced", "true");
        Object[] member = OlapServiceHelper.batCheckMemberIsExistOlap(dimNum, members.toArray(new String[0]), cubecatalog);
        HashSet<String> notExistMemberSet = new HashSet<String>(10);
        for (Object m : member) {
            notExistMemberSet.add(m.toString());
        }
        if (!members.isEmpty()) {
            for (String name : members) {
                if (notExistMemberSet.contains(name)) continue;
                MemberMetadataItem memeber = new MemberMetadataItem();
                memeber.setName(name);
                cmd.getItems().add(memeber);
            }
            if (!cmd.getItems().isEmpty()) {
                OlapServiceHelper.executeCommand(cmd, cubecatalog);
            }
        }
    }

    private static void executeCommand(MetadataCommandInfo cmd, String cubecatalog) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cubecatalog);
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)cmd, null);
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)cmd);
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"executeNonQuery");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"executeNonQuery");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"executeNonQuery", cmd});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", cmd.toString());
                }
                ts.addTag("route", cubecatalog);
                olapCommand.executeNonQuery();
                String ownerUniqueName = cmd.getOwnerUniqueName();
                if (StringUtils.isNotEmpty((String)ownerUniqueName) && ownerUniqueName.startsWith(cubecatalog) && cmd.getMetadataType() == MetadataTypes.Member) {
                    String dimNum = ownerUniqueName.substring(cubecatalog.length() + 1);
                    OlapServiceHelper.clearDimMemberCache(cubecatalog, dimNum);
                    if (CommandTypes.create == cmd.getAction()) {
                        OlapServiceHelper.appendFactor2EntityWithParent(cubecatalog, dimNum, cmd.getName());
                    }
                }
                if (cmd.getMetadataType() == MetadataTypes.Dimension) {
                    OlapServiceHelper.clearDimensionCache(cubecatalog);
                }
            }
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"olap\u64cd\u4f5c\u5931\u8d25 %1", (String)"OlapServiceHelper_04", (String)"epm-eb-spread", (Object[])new Object[]{e.getMessage()}));
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
    }

    private static void appendFactor2EntityWithParent(String cubeName, String dimNumber, String member) {
        if (PresetConstant.ENTITY_DIM.equals(dimNumber) && member != null && member.contains("_")) {
            OlapServiceHelper.alterMemberStorageType(cubeName, dimNumber, member, MemberStorageTypes.DynamicCalc);
            OlapServiceHelper.createAggFactor(cubeName, dimNumber, member.split("_")[1], 1, member);
        }
    }

    public static void repairEntityWithParentFactor(String cubeName, List<String> numbers, boolean isAll) {
        ArrayList factorList = Lists.newArrayListWithExpectedSize((int)1);
        MemberReader.getAllNodeByDimNum((String)PresetConstant.ENTITY_DIM, (String)cubeName).forEach(e -> {
            if (!e.isLeaf() && !e.isShare()) {
                if (PresetConstant.ENTITY_DIM.equals(e.getNumber())) {
                    return;
                }
                e.getChildren().forEach(c -> {
                    if (numbers.contains(c.getNumber())) {
                        factorList.clear();
                        AggFactorMetadataItem aggFactorMetadataItem = OlapUtils.createAggFactorMetadataItem(c.getNumber(), 1);
                        factorList.add(aggFactorMetadataItem);
                        String withParentEntity = e.getNumber() + "_" + c.getNumber();
                        try {
                            OlapServiceHelper.repairAggFactor(cubeName, PresetConstant.ENTITY_DIM, withParentEntity, factorList);
                        }
                        catch (Exception e1) {
                            OlapServiceHelper.createMember(cubeName, PresetConstant.ENTITY_DIM, withParentEntity);
                            OlapServiceHelper.repairAggFactor(cubeName, PresetConstant.ENTITY_DIM, withParentEntity, factorList);
                        }
                        OlapServiceHelper.alterMemberStorageType(cubeName, PresetConstant.ENTITY_DIM, withParentEntity, MemberStorageTypes.DynamicCalc);
                    }
                });
            }
        });
        if (isAll) {
            OlapServiceHelper.setProcessShieldRule(cubeName);
        }
    }

    private static void setProcessShieldRule(String cubeName) {
        IDNumberTreeNode cadj;
        ArrayList<IDNumberTreeNode> processes = new ArrayList<IDNumberTreeNode>(8);
        long modelId = MemberReader.findModelIdByNum((String)cubeName);
        IDNumberTreeNode adj = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"ADJ");
        processes.add(adj);
        IDNumberTreeNode eje = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"EJE");
        if (eje.isLeaf()) {
            processes.add(eje);
        } else {
            eje.getChildren().forEach(e -> processes.add((IDNumberTreeNode)e));
        }
        IDNumberTreeNode ccadj = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"CCADJ");
        if (IDNumberTreeNode.NotFoundTreeNode != ccadj) {
            processes.add(ccadj);
        }
        if (IDNumberTreeNode.NotFoundTreeNode != (cadj = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"CADJ"))) {
            processes.add(cadj);
        }
        processes.forEach(p -> {
            ShieldRuleBulider srb = new ShieldRuleBulider(modelId);
            long srid = srb.getShieldRule(p.getDimId(), DimTypesEnum.ENTITY.getShortNumber());
            srb.save(p.getDimId(), p.getId(), srid);
        });
    }

    public static boolean createMember(String cubeName, String dimNumber, String member) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeName);
        if (OlapServiceHelper.batCheckMemberIsExistOlap(dimNumber, new String[]{member}, cubeName).length == 0) {
            return false;
        }
        if (PresetConstant.ENTITY_DIM.equals(dimNumber)) {
            AppCacheServiceHelper.removeTemplateDispenseCache(cubeName);
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeName + "." + dimNumber);
        cmd.setName(member);
        OlapServiceHelper.executeCommand(cmd, cubeName);
        return true;
    }

    public static void createMember(String cubeName, String dimNumber, String member, int aggOprt, String parentNumber) {
        if (OlapServiceHelper.createMember(cubeName, dimNumber, member)) {
            try {
                OlapServiceHelper.createAggFactor(cubeName, dimNumber, member, aggOprt, parentNumber);
            }
            catch (KDBizException e) {
                OlapServiceHelper.handleAggFactor(cubeName, dimNumber, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(member, aggOprt)}), CommandTypes.alter);
            }
        } else {
            try {
                OlapServiceHelper.handleAggFactor(cubeName, dimNumber, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(member, aggOprt)}), CommandTypes.alter);
            }
            catch (KDBizException e) {
                OlapServiceHelper.createAggFactor(cubeName, dimNumber, member, aggOprt, parentNumber);
            }
        }
    }

    public static void batchCreateDimensionMembers(String cubeName, String dimension, Object[] members) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        members = OlapServiceHelper.batCheckMemberIsExistOlap(dimension, members, cubeName);
        if (members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                MemberMetadataItem memeber = new MemberMetadataItem();
                memeber.setName(members[i].toString());
                cmd.getItems().add(memeber);
            }
            OlapServiceHelper.executeCommand(cmd, cubeName);
        }
    }

    public static void batchCreateDimensionMembers(String cubeName, String dimension, List<Tuple<String, Integer, String>> tupleList) {
        int i;
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        Object[] members = new String[tupleList.size()];
        for (i = 0; i < tupleList.size(); ++i) {
            members[i] = tupleList.get((int)i).p1;
        }
        if ((members = OlapServiceHelper.batCheckMemberIsExistOlap(dimension, members, cubeName)).length > 0) {
            for (i = 0; i < members.length; ++i) {
                MemberMetadataItem memeber = new MemberMetadataItem();
                memeber.setName(members[i].toString());
                cmd.getItems().add(memeber);
            }
            OlapServiceHelper.executeCommand(cmd, cubeName);
        }
        HashMap map = new HashMap();
        tupleList.forEach(t -> {
            List l = map.getOrDefault(t.p3, new ArrayList());
            l.add(OlapUtils.createAggFactorMetadataItem((String)t.p1, (Integer)t.p2));
            map.put(t.p3, l);
        });
        for (Map.Entry entry : map.entrySet()) {
            OlapServiceHelper.createAggFactor(cubeName, dimension, (String)entry.getKey(), (List)entry.getValue());
        }
    }

    private static void handleAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList, CommandTypes commandType) {
        if (OlapServiceHelper.isEntityRoot(dimNum, memNum)) {
            return;
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(commandType);
        cmd.setMetadataType(MetadataTypes.AggFactor);
        cmd.setOwnerUniqueName(cubeNum + "." + dimNum + "@" + memNum);
        cmd.getItems().addAll(factorList);
        if (CommandTypes.drop == commandType) {
            try {
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        } else {
            OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
        }
        if (CommandTypes.alter == commandType) {
            OlapServiceHelper.clearDimMemberCache(cubeNum, dimNum);
        }
    }

    private static boolean isEntityRoot(String dimNum, String memNum) {
        return "Entity".equals(memNum) && PresetConstant.ENTITY_DIM.equals(dimNum);
    }

    public static void createAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, memNum, factorList, CommandTypes.create);
    }

    public static void createAggFactor(String cubeNum, String dimNum, String memNum, int aggOprt, String parentNumber) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(memNum, aggOprt)}), CommandTypes.create);
    }

    public static void batchDropAggFactor(String cubeNum, String dimNum, Multimap<String, Pair<String, Integer>> multimap) {
        for (String key : multimap.keySet()) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)multimap.get((Object)key).size());
            for (Pair pair : multimap.get((Object)key)) {
                list.add(OlapUtils.createAggFactorMetadataItem((String)pair.p1, (Integer)pair.p2));
            }
            OlapServiceHelper.handleAggFactor(cubeNum, dimNum, key, list, CommandTypes.drop);
        }
    }

    public static void repairAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, memNum, factorList, CommandTypes.repair);
    }

    private static void executeUpdateMetadata(MetadataCommandInfo cmd, String cubeNum) {
        if (!ConfigServiceHelper.getBoolParam(cubeNum, "CM006")) {
            return;
        }
        OlapConnection conn = null;
        try {
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)cmd, null);
            conn = OlapServiceHelper.getOlapConnection(cubeNum);
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)cmd);
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"executeUpdateMetadata");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"executeUpdateMetadata");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"executeUpdateMetadata", cmd});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", cmd.toString());
                }
                ts.addTag("route", cubeNum);
                olapCommand.updateMetadata();
            }
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"olap\u66f4\u65b0\u5143\u6570\u636e\u5931\u8d25%1", (String)"OlapServiceHelper_05", (String)"epm-eb-spread", (Object[])new Object[]{e.getMessage()}));
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
    }

    public static void alterMemberStorageType(String cubeNum, String dimNum, String memNum, MemberStorageTypes type) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
        cmd.setName(memNum);
        if (type == MemberStorageTypes.Stored) {
            cmd.getProperties().set(MemberMetadataItem.Companion.getStorageTypeKey(), "");
        } else {
            cmd.getProperties().set(MemberMetadataItem.Companion.getStorageTypeKey(), type.getCode());
        }
        OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
    }

    public static void excuteScript(String cube, String script, Map<String, Object> params) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cube);
            conn.Open();
            Outline ot = new Outline(conn);
            ComputingEngine computingEngine = new ComputingEngine(conn, (IOutline)ot);
            params.put("outline", ot);
            computingEngine.execute(script, params);
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"olap\u64cd\u4f5c\u5931\u8d25 %1", (String)"OlapServiceHelper_04", (String)"epm-eb-spread", (Object[])new Object[]{e.getMessage()}));
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
    }

    public static Map<Long, String> excuteScript4ReportParams(String cube, List<BizRuleExecParam> paramList, ApplicationTypeEnum app) {
        return RuleExecuteServiceHelper.excuteScript4ReportParams((String)cube, paramList, (ApplicationTypeEnum)app);
    }

    public static boolean checkIsOnlineByCube(Long modelId) {
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"reporttype,datasource.dataconnect,datasource.username,datasource.password", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        boolean result = false;
        if (modelObj != null) {
            String reportType = modelObj.getString("reporttype");
            if (kd.epm.eb.common.enums.ApplicationTypeEnum.isEB((String)reportType)) {
                String olapConnetct = modelObj.getString("datasource.dataconnect");
                String userName = modelObj.getString("datasource.username");
                String password = modelObj.getString("datasource.password");
                result = OlapServiceHelper.checkIsOnline(olapConnetct, userName, password);
            } else {
                result = true;
            }
        }
        return result;
    }

    public static boolean checkIsOnline(Long dataSourceId) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingleFromCache((String)"epbs_datasource", (String)"dataconnect,username,password", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataSourceId)});
        if (dataSource != null) {
            String olapConnetct = dataSource.getString("dataconnect");
            String userName = dataSource.getString("username");
            String password = dataSource.getString("password");
            return OlapServiceHelper.checkIsOnline(olapConnetct, userName, password);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIsOnline(String olapconnect, String username, String password) {
        boolean flag = true;
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName("olapTestCube");
        OlapConnection conn = null;
        try {
            conn = ConnectionManager.getInstance().getConnection(olapconnect, username, password, "olapTestCube");
            conn.Open();
            new OlapCommand(conn, (CommandInfo)cmd).executeNonQuery();
        }
        catch (Exception e) {
            try {
                log.warn(CommonServiceHelper.getStackTraceStr((Throwable)e));
                flag = false;
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                throw throwable;
            }
            ShrekOlapUtils.close((Object[])new Object[]{conn});
        }
        ShrekOlapUtils.close((Object[])new Object[]{conn});
        return flag;
    }

    public static OlapConnection getOlapConnection(String cube) {
        return ConnectionManager.getInstance().getConnection(cube, cube);
    }

    public static BigDecimal getLegalDecimalForOlap(BigDecimal value) {
        return value.setScale(6, RoundingMode.HALF_UP);
    }

    public static List<String> getMembersOfDimFromOlap(String dimensionNum, String cube) {
        OlapConnection connect = OlapServiceHelper.getOlapConnection(cube);
        PropertyBag propertyBag = OlapServiceHelper.isExistMetadataNames(connect, dimensionNum, true);
        String[] childs = null;
        ArrayList<String> olapMembers = new ArrayList<String>();
        if (propertyBag.get("exist").equals("true")) {
            childs = propertyBag.get("children").split("\n");
            olapMembers = new ArrayList<String>(Arrays.asList(childs));
        }
        return olapMembers;
    }

    public static Object[] batCheckMemberIsExistOlap(String dimensionNum, Object[] memberNums, String cube) {
        List<String> olapMembers = OlapServiceHelper.getMembersOfDimFromOlap(dimensionNum, cube);
        ArrayList olapMembersLowCase = new ArrayList();
        ArrayList<Object> notExistMember = new ArrayList<Object>();
        olapMembers.forEach(member -> olapMembersLowCase.add(member.toLowerCase()));
        olapMembers = null;
        for (int i = 0; i < memberNums.length; ++i) {
            if (olapMembersLowCase.contains(String.valueOf(memberNums[i]).toLowerCase())) continue;
            notExistMember.add(memberNums[i]);
        }
        return notExistMember.toArray();
    }

    public static PropertyBag isExistMetadataNames(OlapConnection con, String path, boolean children) {
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("path", path);
        propertyBag.set("children", String.valueOf(children));
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getMetadataNames", propertyBag);
        OlapCommand cmd = new OlapCommand(con, (CommandInfo)functionCommandInfo);
        return cmd.executeFunction();
    }

    public static void setMemberAggShieldRule(String cubeNum, String dimNum, String memNum, String ruleNumber) {
        MetadataCommandInfo memberCreateCmd = new MetadataCommandInfo();
        memberCreateCmd.setMetadataType(MetadataTypes.Member);
        memberCreateCmd.setAction(CommandTypes.alter);
        memberCreateCmd.setOwnerUniqueName(cubeNum + '.' + dimNum);
        memberCreateCmd.setName(memNum);
        memberCreateCmd.setMemberAggShieldRule(ruleNumber);
        OlapServiceHelper.executeUpdateMetadata(memberCreateCmd, cubeNum);
    }

    public static void createAggShieldRule(String cubeNum, String number, List<String> dims) {
        MetadataCommandInfo createAggShieldRuleCmd = new MetadataCommandInfo();
        createAggShieldRuleCmd.setMetadataType(MetadataTypes.AggShieldRule);
        createAggShieldRuleCmd.setAction(CommandTypes.create);
        createAggShieldRuleCmd.setOwnerUniqueName(cubeNum);
        List items = createAggShieldRuleCmd.getItems();
        AggShieldRuleBlackListMetadataItem item1 = new AggShieldRuleBlackListMetadataItem(number);
        item1.setDimensionList(dims);
        items.add(item1);
        OlapServiceHelper.executeUpdateMetadata(createAggShieldRuleCmd, cubeNum);
    }

    public static boolean checkCubeIsEnableDynamic(String cube) {
        OlapConnection conn = OlapServiceHelper.getOlapConnection(cube);
        return OlapServiceHelper.checkIsEnableDynamic(conn);
    }

    private static boolean checkIsEnableDynamic(OlapConnection conn) {
        try {
            FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("isEnableDynamic");
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            String result = cmd.executeFunction().get("isEnable");
            return "true".equals(result);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }
}

