/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;

public class OrgCurrencyServiceHelper {
    private static QFilter expdateNullQf = new QFilter("currencychangerds.currencyexpdate", "is null", null);
    private static QFilter pExpdateNullQf = new QFilter("parent.currencychangerds.currencyexpdate", "is null", null);

    public static DynamicObject getCurrencyDynByIdThrow(Long orgId, String yearNum, Long periodId) {
        DynamicObject org = OrgCurrencyServiceHelper.getOrgModelAndCurrency(orgId, yearNum, periodId);
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\u3002", (String)"OrgCurrencyServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        return OrgCurrencyServiceHelper.getCurrencyDyn(org);
    }

    public static DynamicObject getCurrencyDynById(Long orgId, String yearNum, Long periodId) {
        DynamicObject org = OrgCurrencyServiceHelper.getOrgModelAndCurrency(orgId, yearNum, periodId);
        return OrgCurrencyServiceHelper.getCurrencyDyn(org);
    }

    public static DynamicObject getCurrencyDynByIdThrow(Long orgId, Long yearId, Long periodId) {
        DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"epm_yearmembertree");
        return OrgCurrencyServiceHelper.getCurrencyDynByIdThrow(orgId, yearDyn.getString("number"), periodId);
    }

    public static DynamicObject getCurrencyDynById(Long orgId, Long yearId, Long periodId) {
        DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"epm_yearmembertree");
        return OrgCurrencyServiceHelper.getCurrencyDynById(orgId, yearDyn.getString("number"), periodId);
    }

    public static DynamicObject getParentCurrencyDynByIdThrow(Long orgId, Long yearId, Long periodId) {
        DynamicObject org = OrgCurrencyServiceHelper.getParentOrgModelAndCurrency(orgId, yearId, periodId);
        if (org.getInt("level") >= 3) {
            DynamicObject currency = OrgCurrencyServiceHelper.getCurrencyDyn(org);
            if (currency == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u65e0\u6cd5\u67e5\u8be2\u5f97\u5230\u4efb\u4f55\u5e01\u79cd\u6570\u636e: %1\u3002", (String)"OrgCurrencyServiceHelper_1", (String)"epm-eb-spread", (Object[])new Object[]{orgId}));
            }
            return currency;
        }
        throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u6ca1\u6709\u9ed8\u8ba4\u5e01: %1\u3002", (String)"OrgCurrencyServiceHelper_2", (String)"epm-eb-spread", (Object[])new Object[]{orgId}));
    }

    public static DynamicObject getTheDateCurrency(Long orgId, Date date) {
        QFilter idQf = new QFilter("id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{idQf};
        String selectFields = "id,number,model,currency currency.id,currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,number,model,currency currency.id,currency.number", (QFilter[])filters);
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,number,model,currency currency.id,currency.number", (QFilter[])new QFilter[]{idQf});
        }
        return org;
    }

    public static DynamicObjectCollection getTheDateCurrency(Set<Long> orgIds, Date date) {
        QFilter idQf = new QFilter("id", "in", orgIds);
        QFilter[] filters = new QFilter[]{idQf};
        String selectFields = "id,model,currency.number";
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,model,currency.number", (QFilter[])filters);
        if (orgs == null || orgs.size() == 0) {
            orgs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,model,currency.number", (QFilter[])new QFilter[]{idQf});
        }
        return orgs;
    }

    public static DynamicObjectCollection getOrgsCurrency(QFilter[] qfs, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter qf : qfs) {
            qfBuilder.add(qf);
        }
        qfBuilder.add(effdateQf);
        qfBuilder.add(expdateQf);
        String selectFields = "id,number,longnumber,currency.number";
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,number,longnumber,currency.number,currencychangerds.currencyrds.number", (QFilter[])qfBuilder.toArray());
        if (orgs == null || orgs.size() == 0) {
            orgs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,number,longnumber,currency.number", (QFilter[])qfs);
        } else {
            for (DynamicObject org : orgs) {
                org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
            }
        }
        return orgs;
    }

    public static DynamicObject getOrgAndParentCurrency(QFilter[] qfs, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter qf : qfs) {
            qfBuilder.add(qf);
        }
        qfBuilder.add(effdateQf);
        qfBuilder.add(expdateQf);
        String selectFields = "id,level,number,parent.id,parent.number,currency.number,parent.currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,level,number,parent.id,parent.number,currency.number,parent.currency.number,currencychangerds.currencyrds.number,parent.currencychangerds.currencyrds.number", (QFilter[])qfBuilder.toArray());
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,level,number,parent.id,parent.number,currency.number,parent.currency.number", (QFilter[])qfs);
        } else {
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
            org.set("parent.currency.number", org.get("parent.currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObject getOrgModelAndCurrency(Long orgId, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        return OrgCurrencyServiceHelper.getTheDateCurrency(orgId, periodLastDate);
    }

    public static DynamicObject getOrgModelAndCurrency(Long orgId, String yearNum, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((String)yearNum, (Long)periodId);
        return OrgCurrencyServiceHelper.getTheDateCurrency(orgId, periodLastDate);
    }

    public static DynamicObjectCollection getOrgModelAndCurrency(Set<Long> orgIds, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        return OrgCurrencyServiceHelper.getTheDateCurrency(orgIds, periodLastDate);
    }

    public static DynamicObject getParentOrgModelAndCurrency(Long orgId, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter idQf = new QFilter("id", "=", (Object)orgId);
        String selectFields = "id,parent,number,model,level,parent.currency.id currency.id,parent.currency.number currency.number";
        DynamicObject org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,parent,number,model,level,parent.currency.id currency.id,parent.currency.number currency.number", (QFilter[])new QFilter[]{idQf});
        return org;
    }

    public static DynamicObject getCurrencyDyn(DynamicObject org) {
        QFilter numberFilter = new QFilter("number", "=", (Object)org.getString("currency.number"));
        QFilter modelFilter = new QFilter("model", "=", (Object)org.getLong("model"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"epm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter, modelFilter});
    }

    public static DynamicObject getOrgById(Long orgId, Long yearId, Long periodId) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)yearId, (Long)periodId);
        QFilter idQf = new QFilter("id", "=", (Object)orgId);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFilter[] filters = new QFilter[]{idQf, effdateQf, expdateQf};
        String selectFields = "id,name,simplename,number,longnumber,model,parent.number,isleaf,level,cslscheme,currency.id,currency.number,isinnerorg";
        DynamicObject org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,name,simplename,number,longnumber,model,parent.number,isleaf,level,cslscheme,currency.id,currency.number,isinnerorg,currencychangerds.currencyrds.id,currencychangerds.currencyrds.number", (QFilter[])filters);
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id,name,simplename,number,longnumber,model,parent.number,isleaf,level,cslscheme,currency.id,currency.number,isinnerorg", (QFilter[])new QFBuilder("id", "=", (Object)orgId).toArray());
        } else {
            org.set("currency.id", org.get("currencychangerds.currencyrds.id"));
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
        }
        return org;
    }

    public static DynamicObject getOrgById(Long modelId, String orgNum, String yearNum, String periodNum) {
        Date periodLastDate = PeriodUtils.getPeriodLastDate((Long)modelId, (String)yearNum, (String)periodNum);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter numberQf = new QFilter("number", "=", (Object)orgNum);
        QFilter effdateQf = new QFilter("currencychangerds.currencyeffdate", "<=", (Object)periodLastDate);
        QFilter expdateQf = new QFilter("currencychangerds.currencyexpdate", ">=", (Object)periodLastDate);
        expdateQf.or(expdateNullQf);
        QFilter[] filters = new QFilter[]{modelQf, numberQf, effdateQf, expdateQf};
        String selectFields = "id, currency.number, currency.name, model.beginyearofmonth";
        DynamicObject org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id, currency.number, currency.name, model.beginyearofmonth,currencychangerds.currencyrds.name, currencychangerds.currencyrds.number", (QFilter[])filters);
        if (org == null) {
            org = QueryServiceHelper.queryOne((String)"epm_entitymembertree", (String)"id, currency.number, currency.name, model.beginyearofmonth", (QFilter[])new QFilter[]{modelQf, numberQf});
        } else {
            org.set("currency.name", org.get("currencychangerds.currencyrds.name"));
            org.set("currency.number", org.get("currencychangerds.currencyrds.number"));
        }
        return org;
    }
}

