/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import org.apache.commons.lang.StringUtils;

public class QueryDimensionServiceHelper {
    public static boolean checkNumber(String number, String modelid) {
        return QueryDimensionServiceHelper.checkInfoInModel("number", "number", number, "epm_dimension", modelid);
    }

    public static boolean checkInfoInModel(String selectField, String filter, String filvalue, String form, String modelid) {
        QFilter fmodelid = new QFilter(filter, "=", (Object)filvalue);
        QFilter fmodelid2 = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelid));
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.exists((String)form, (QFilter[])filters);
    }

    public static String search(String selectField, String filter, String filvalue, String form) {
        QFilter fmodelid = new QFilter(filter, "=", (Object)filvalue);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)form, (String)selectField, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static int getMaxDseq(Long modId) {
        String selectFields = "dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq desc");
        int result = 0;
        if (dcs != null && dcs.size() > 0) {
            result = ((DynamicObject)dcs.get(0)).getInt("dseq");
        }
        return result;
    }

    public static String getDimIdByNumber(String number, String modId) {
        String selectFields = "id";
        QFilter fmodelid = new QFilter("model", "=", (Object)Convert.toLong((Object)modId));
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static String getDimNumberById(String id) {
        String selectFields = "number";
        QFilter fmodelid = new QFilter("id", "=", (Object)IDUtils.toLong((Object)id));
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, null);
        String result = "";
        if (dcs != null && dcs.size() > 0) {
            result = String.valueOf(((DynamicObject)dcs.get(0)).get(0));
        }
        return result;
    }

    public static DynamicObject getDimById(Long dimensionId, String modelId) {
        String selectFields = "id,number,name,membermodel,shortnumber";
        QFilter fmodelid = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelId));
        QFilter fmodelid2 = new QFilter("id", "=", (Object)dimensionId);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getDimByDseq(int seq, Long modelId) {
        String selectFields = "id,number,name,membermodel,shortnumber";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("dseq", "=", (Object)seq);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static Long getDefautDimMemId(long dimid, String membermodel) {
        String selectFields = "id";
        QFilter fmodelid = new QFilter("dimension", "=", (Object)dimid);
        QFilter fmodelid3 = new QFilter("membersource", "=", (Object)"1");
        QFilter fmodelid4 = new QFilter("level", "=", (Object)2);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid3, fmodelid4};
        return QueryServiceHelper.queryOne((String)membermodel, (String)selectFields, (QFilter[])filters).getLong("id");
    }

    public static List<DynamicObject> getOthersDim(List<String> number, Long modelId) {
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "not in", number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, null);
    }

    public static DynamicObject getMsgByNumber(long modelId, String number) {
        String selectFields = "dseq,membermodel,id,name,number,fieldmapped";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static boolean checkIcEnt(long modelId) {
        String selectFields = "count(*) as num";
        QFilter fmodelid = new QFilter("membersource", "!=", (Object)"1");
        QFilter fmodelid2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObjectCollection dcs2 = QueryServiceHelper.query((String)"DimMetaUtil", (String)SysDimensionEnum.InternalCompany.getMemberTreemodel(), (String)selectFields, (QFilter[])filters, null);
        int num = 0;
        if (dcs2 != null && dcs2.size() > 0) {
            num = Integer.parseInt(((DynamicObject)dcs2.get(0)).get("num").toString());
        }
        return num > 0;
    }

    public static boolean isExitDimension(long modelId, String number) {
        String selectFields = "dseq,membermodel,id,name,number";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
        return dcs != null;
    }

    public static DynamicObject getMemberMsgByNumber(long modelId, String number, String entityName) {
        String selectFields = "id,number,name,isleaf,longnumber,storagetype,parent";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)number);
        qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        QFilter[] filters = new QFilter[]{qFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getMsgByDimId(Object dimId) {
        String selectFields = "model,membermodel";
        QFilter fmodelid = new QFilter("id", "=", (Object)IDUtils.toLong((Object)dimId));
        QFilter[] filters = new QFilter[]{fmodelid};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)selectFields, (QFilter[])filters);
    }

    public static String getModelNumber(long modelId) {
        return MemberReader.findModelNumberById((Object)modelId);
    }

    public static List<DynamicObject> getUserDefineDim(Long modelId) {
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fliter2 = new QFilter("ISSYSDIMENSION", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{fmodelid, fliter2};
        return QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, null);
    }

    public static String[] getparent(String fid, String entityName) {
        QFilter qf = new QFilter("id", "=", (Object)IDUtils.toLong((Object)fid));
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "longnumber,level";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)entityName, (String)selectFields, (QFilter[])qfs, null);
        String Flongnumber = ((DynamicObject)dcs.get(0)).getString("longnumber");
        String Flevel = String.valueOf(((DynamicObject)dcs.get(0)).getInt("level"));
        return new String[]{Flongnumber, Flevel};
    }

    public static List<Long> getdimensionIds(Long model) {
        QFilter qf = new QFilter("model.id", "=", (Object)model);
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "id";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)"epm_dimension", (String)selectFields, (QFilter[])qfs, null);
        ArrayList<Long> list = new ArrayList<Long>();
        dcs.forEach(p -> list.add(p.getLong("id")));
        return list;
    }

    public static int getMaxDSeq(Long parentselectid, String entityname) {
        QFilter fdimenId = new QFilter("parent", "=", (Object)parentselectid);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)entityname, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq");
        }
        return 0;
    }

    public static DynamicObject getMemMsgById(String memId, String membermodel) {
        String selectFields = "id, name, number, isleaf, dimension.number, issysmember,longnumber,level";
        if ("epm_entitymembertree".equalsIgnoreCase(membermodel)) {
            selectFields = "id, name, number, isleaf, dimension.number, issysmember,longnumber,level,cslscheme";
        }
        QFilter qf1 = new QFilter("id", "=", (Object)IDUtils.toLong((Object)memId));
        QFilter[] filters = new QFilter[]{qf1};
        return QueryServiceHelper.queryOne((String)membermodel, (String)selectFields, (QFilter[])filters);
    }

    public static long getParentId(long modelId, String entityName, String parentNum, String algoNmae) {
        long parentid = 0L;
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)parentNum);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoNmae, (String)entityName, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            parentid = ((DynamicObject)dcs.get(0)).getLong("id");
        }
        return parentid;
    }

    public static Map<String, String> getOrgNameByNum(long modelid, String[] numbers) {
        QFilter qf1 = new QFilter("number", "in", (Object)numbers);
        QFilter qf2 = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{qf1, qf2};
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"name,number", (QFilter[])filters);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject obj : docs) {
            map.put(obj.getString("number"), obj.getString("name"));
        }
        return map;
    }

    public static String getDimNumberEgnoreCase(String number, long modelid) {
        Collection dimNums = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelid)).values();
        for (String realnumber : dimNums) {
            if (!realnumber.toLowerCase(Locale.getDefault()).equals(number.toLowerCase(Locale.getDefault()))) continue;
            return realnumber;
        }
        return null;
    }

    public static Map<String, Map<String, Map<String, Object>>> getDimMemberInfoMap(long modelid, Map<String, List<String>> dimNumbers, boolean onlyLeaf) {
        boolean isTrue = true;
        HashMap<String, Map<String, Map<String, Object>>> result = new HashMap<String, Map<String, Map<String, Object>>>(dimNumbers.size());
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        QFilter qFilter1 = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        if (onlyLeaf) {
            qFilter.and("isleaf", "=", (Object)isTrue);
        }
        for (Map.Entry<String, List<String>> entry : dimNumbers.entrySet()) {
            String dim = entry.getKey();
            List<String> value = entry.getValue();
            String entity = DimensionServiceHelper.getDimMembEntityNumByDimNum(dim);
            HashMap dimInfo = new HashMap(16);
            DataSet dset = QueryServiceHelper.queryDataSet((String)"bcm", (String)entity, (String)StringUtils.strip((String)value.toString(), (String)"[]"), (QFilter[])new QFilter[]{qFilter, qFilter1}, null);
            while (dset.hasNext()) {
                Row row = dset.next();
                HashMap<String, Object> temp = new HashMap<String, Object>(value.size());
                for (String field : value) {
                    temp.put(field, row.get(field));
                }
                dimInfo.put(row.getString("number"), temp);
            }
            result.put(dim, dimInfo);
        }
        return result;
    }
}

