/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.constant.BCMConstant;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.mq.MQMessagePublisherServiceHelper;
import kd.epm.eb.ebBusiness.reportlist.cache.ReportRedisCache;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.template.model.Template2AcctModel;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.util.TemplateRangeService;

public class TemplateServiceHelper {
    private static final String templateimport_class_path = "kd.epm.eb.budget.formplugin.template.TemplateImport";
    private static final String templateimport_method_name = "importTemplate";

    public static boolean isNotFinTemplate(Object pk) {
        DynamicObject template = QueryServiceHelper.queryOne((String)"eb_templateentity_bg", (String)"isfintemplate", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (template != null) {
            return !template.getBoolean("isfintemplate");
        }
        return false;
    }

    public static TemplateModel getTemplateModelById(Object templateId) {
        String templateSerial = AppCacheServiceHelper.get(templateId.toString(), String.class);
        TemplateModel model = new TemplateModel();
        if (StringUtils.isEmpty((String)templateSerial)) {
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity_bg");
            model.loadDynaObj2Model(template);
        } else {
            model = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
        }
        return model;
    }

    public static Pair<List<TemplateModel>, Collection<Object>> getTemplateModelsFromCache(Collection<?> ids) {
        ArrayList templates = new ArrayList();
        HashSet idSet = new HashSet(ids);
        idSet.forEach(id -> {
            String templateSerial = AppCacheServiceHelper.get(id.toString(), String.class);
            if (!StringUtils.isEmpty((String)templateSerial)) {
                TemplateModel model = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
                templates.add(model);
            }
        });
        templates.forEach(t -> idSet.remove(t.getId()));
        return Pair.onePair(templates, idSet);
    }

    public static void removeTemplateModelCacheByIds(Object modelId, Object[] ids) {
        Template2AcctModel mapModel = TemplateServiceHelper.getTemplate2AcctModelFromRedis(modelId);
        for (Object id : ids) {
            String idStr = id.toString();
            AppCacheServiceHelper.remove(idStr);
            ReportRedisCache.removeTemplateModelFromCache(id);
            GlobalCacheServiceHelper.invalidateTemplateModel((String)idStr);
        }
        if (mapModel != null) {
            mapModel.remove(ids);
            AppCacheServiceHelper.put("Template2AcctModel" + modelId, ObjectSerialUtil.toByteSerialized((Object)mapModel));
        }
        GlobalCacheServiceHelper.invalidateAllCurrentCache((String)("Template2AcctModel" + modelId));
        MQMessagePublisherServiceHelper.publishInvalidateTemplateModel(Arrays.stream(ids).map(Object::toString).collect(Collectors.toList()));
    }

    public static void cacheTemplateWholeModel(TemplateModel ... models) {
        ArrayList<String> ids = new ArrayList<String>(models.length);
        for (TemplateModel model : models) {
            AppCacheServiceHelper.put("" + model.getId(), ObjectSerialUtil.toByteSerialized((Object)model));
            ReportRedisCache.removeTemplateModelFromCache(model.getId());
            GlobalCacheServiceHelper.invalidateTemplateModel((String)("" + model.getId()));
            ids.add("" + model.getId());
        }
        MQMessagePublisherServiceHelper.publishInvalidateTemplateModel(ids);
        Template2AcctModel mapModel = TemplateServiceHelper.getTemplate2AcctModelFromRedis(models[0].getModelId());
        if (mapModel != null) {
            for (TemplateModel model : models) {
                if (model.getTemplateType() == 2) continue;
                mapModel.putPair(model.getId(), TemplateServiceHelper.findAcctNumbsInTemplateModel(model));
            }
            AppCacheServiceHelper.put("Template2AcctModel" + models[0].getModelId(), ObjectSerialUtil.toByteSerialized((Object)mapModel));
        }
        if (models[0].getTemplateType() != 2) {
            GlobalCacheServiceHelper.invalidateAllCurrentCache((String)("Template2AcctModel" + models[0].getModelId()));
        }
    }

    public static List<Long> queryAllValidataTemplateIds(Object modelId) {
        StringBuilder sql = new StringBuilder("select fid from t_eb_ebtemplate where FModelid =? and FVersionstatus = ?  and FTemplatetype != ?");
        Object[] params = new SqlParameter[]{new SqlParameter(":FModelid", -5, modelId), new SqlParameter(":FVersionstatus", 12, (Object)"1"), new SqlParameter(":FTemplatetype", 12, (Object)"2")};
        ArrayList<Long> list = new ArrayList<Long>();
        DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql.toString(), (Object[])params, rs -> {
            while (rs.next()) {
                list.add(rs.getLong("fid"));
            }
            return null;
        });
        return list;
    }

    public static Pair<List<Long>, Set<String>> getTemplateIdsByIncludeAccts(Set<String> acctNums, Object modelId) {
        Template2AcctModel model = (Template2AcctModel)GlobalCacheServiceHelper.getOrLoadNode((String)("Template2AcctModel" + modelId), () -> {
            Template2AcctModel cache = TemplateServiceHelper.getTemplate2AcctModelFromRedis(modelId);
            if (cache == null) {
                List<Long> ids = TemplateServiceHelper.queryAllValidataTemplateIds(modelId);
                List<TemplateModel> templates = TemplateRangeService.getWholeTemplateModels(ids);
                Template2AcctModel newmodel = new Template2AcctModel();
                for (TemplateModel template : templates) {
                    newmodel.putPair(template.getId(), TemplateServiceHelper.findAcctNumbsInTemplateModel(template));
                }
                AppCacheServiceHelper.put("Template2AcctModel" + modelId, ObjectSerialUtil.toByteSerialized((Object)newmodel));
                return newmodel;
            }
            return cache;
        });
        ArrayList ids = new ArrayList();
        HashSet acctNumSet = new HashSet();
        model.iterator().forEachRemaining(t -> {
            for (String numb : acctNums) {
                if (!((Set)t.getValue()).contains(numb)) continue;
                ids.add(Long.valueOf((String)t.getKey()));
                acctNumSet.addAll((Collection)t.getValue());
                break;
            }
        });
        return Pair.onePair(ids, acctNumSet);
    }

    public static Template2AcctModel getTemplate2AcctModelFromRedis(Object modelId) {
        String cache = AppCacheServiceHelper.get("Template2AcctModel" + modelId, String.class);
        if (StringUtils.isNotEmpty((String)cache)) {
            return (Template2AcctModel)ObjectSerialUtil.deSerializedBytes((String)cache);
        }
        return null;
    }

    private static Set<String> findAcctNumbsInTemplateModel(TemplateModel template) {
        return TemplateRangeService.findMembsBySpecificDim("epm_accountmembertree", template);
    }
}

