/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.SystemSeparatorChar;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.DetailTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.model.SimpleItem;
import kd.epm.eb.ebBusiness.serviceHelper.MemberServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberTreeNode;

public class TreeStructureServiceHelper {
    public static final char LONGNUMBER_DELIMITER = SystemSeparatorChar.LONGNUMBER_SEPARAROT.charValue();
    public static final String TREE_MODEL = "treemodel|";

    public static Set<Long> getDimTypesEnumIdList() {
        HashSet<Long> dimTypesEnumCacheList = (HashSet<Long>)ThreadCache.get((Object)DimTypesEnum.class.getName());
        if (dimTypesEnumCacheList == null) {
            dimTypesEnumCacheList = new HashSet<Long>(16);
            QFilter filter = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
            for (DynamicObject dyn : BusinessDataServiceHelper.loadFromCache((String)"epm_entitymembertree", (String)"id", (QFilter[])filter.toArray()).values()) {
                dimTypesEnumCacheList.add((Long)dyn.getPkValue());
            }
            ThreadCache.put((Object)DimTypesEnum.class.getName(), dimTypesEnumCacheList);
        }
        return dimTypesEnumCacheList;
    }

    public static boolean isRootEntityNodeId(Object entityId, DetailTypeEnum type) {
        return DetailTypeEnum.TEMPLATEDIS == type ? TreeStructureServiceHelper.getDimTypesEnumIdList().contains(entityId) : false;
    }

    public static boolean isDirectChild(String entityNum, Object pId, Object id, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        return TreeStructureServiceHelper.getIds(nodes.get(pId).getChildren()).contains(id);
    }

    public static boolean isDirectChildByCustom(String mEntityNum, Object mId, Object cusPropId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("eb_definedpropertyvalue", 0);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        List props = node.getChildren();
        if (props.isEmpty()) {
            return false;
        }
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)TreeStructureServiceHelper.getIds(props).toArray()), new QFilter("id", "in", mId)});
    }

    public static boolean isChildByAssign(String entityNum, Object mId, Object pId, Object modelId, boolean isOnlyLeaf) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode mNode = nodes.get(mId);
        if (mNode != null) {
            IDNumberTreeNode node = mNode.closest(pId);
            return node != null && mNode.isLeaf() == isOnlyLeaf;
        }
        return false;
    }

    public static boolean isAssignChildByCustom(String mEntityNum, Object mId, Object cusPropId, boolean isOnlyLeaf) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("eb_definedpropertyvalue", 0);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        Set<Long> propIds = TreeStructureServiceHelper.getIds(node.getAllChildren());
        propIds.add(node.getId());
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("id", "=", mId), new QFilter("isleaf", "=", (Object)isOnlyLeaf)});
    }

    public static boolean isBrotherByCustom(String mEntityNum, Object mId, Object cusPropId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("eb_definedpropertyvalue", 0);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        Set<Long> propIds = TreeStructureServiceHelper.getIds(node.getBrother());
        if (propIds.isEmpty()) {
            return false;
        }
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"parentid,propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("id", "in", mId)});
    }

    public static List<SimpleItem> getDirectChild(String entityNum, Object pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        if (nodes.get(pId) == null) {
            return s;
        }
        nodes.get(pId).getChildren().forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        return s;
    }

    public static DynamicObjectCollection getDirectChild(String entityNum, Object pId, String select) {
        QFBuilder qf = new QFBuilder();
        qf.add("parent", "=", pId);
        if ("epm_entitymembertree".equals(entityNum)) {
            qf.add("isexchangerate", "=", (Object)0);
        }
        DynamicObjectCollection result = QueryServiceHelper.query((String)entityNum, (String)select, (QFilter[])qf.toArray());
        return result;
    }

    public static DynamicObject getSelfById(String entityNum, Long id, String select) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityNum, (String)select);
    }

    public static List<SimpleItem> getDirectChildByCustom(String mEntityNum, Object cusPropId, boolean isIncludeSelf) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        DynamicObjectCollection children = QueryServiceHelper.query((String)"eb_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", cusPropId)});
        ArrayList<Object> propIds = new ArrayList<Object>();
        children.forEach(e -> propIds.add(e.get("id")));
        if (isIncludeSelf) {
            propIds.add(cusPropId);
        }
        if (!propIds.isEmpty() && cusPropDyna != null) {
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray())});
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static boolean isChild(String entityNum, Object pid, Object id, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(id);
        return node != null && TreeStructureServiceHelper.isChild(nodes, pid, node);
    }

    private static boolean isChild(Map<Long, IDNumberTreeNode> nodes, Object pid, IDNumberTreeNode checkNode) {
        IDNumberTreeNode parent = nodes.get(pid);
        return parent != null && parent.getChildren().stream().anyMatch(c -> c.getNumber().equals(checkNode.getNumber()) || TreeStructureServiceHelper.isChild(nodes, c.getId(), checkNode));
    }

    public static List<SimpleItem> getChild(String entityNum, Long pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(pId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        if (node != null) {
            node.getAllChildren().forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        }
        return s;
    }

    public static List<SimpleItem> getLeafChildren(String entityNum, Long pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(pId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        node.getAllChildren(2).forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        return s;
    }

    public static boolean isChildByCustom(String mEntityNum, Object mId, Object cusPropId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("eb_definedpropertyvalue", 0);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        Set<Long> propIds = TreeStructureServiceHelper.getIds(node.getAllChildren());
        if (propIds.isEmpty()) {
            return false;
        }
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("id", "in", mId)});
    }

    public static List<SimpleItem> getChildByCustom(String mEntityNum, Object cusPropId, String cusPropLongNum, boolean isIncludeSelf) {
        DynamicObject cusPropDyna;
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        ArrayList<Object> propIds = new ArrayList<Object>();
        if (isIncludeSelf) {
            propIds.add(cusPropId);
        }
        if ((cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn,dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)})) == null) {
            return s;
        }
        String dimId = cusPropDyna.getString("dimension");
        DynamicObjectCollection children = QueryServiceHelper.query((String)"eb_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(cusPropLongNum + '!' + "%")), new QFilter("dimension", "=", (Object)dimId)});
        children.forEach(e -> propIds.add(e.get("id")));
        if (!propIds.isEmpty()) {
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray())});
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static boolean isBrother(String entityNum, Object id, Object pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(id);
        if (node != null) {
            return TreeStructureServiceHelper.getIds(node.getBrother()).contains(pId);
        }
        return false;
    }

    public static List<SimpleItem> getBrother(String entityNum, Long pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        IDNumberTreeNode node = nodes.get(pId);
        if (node != null) {
            node.getBrother().forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        }
        return s;
    }

    public static List<SimpleItem> getChildByAssign(String entityNum, Long pId, Object modelId, boolean isOnlyLeaf) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        IDNumberTreeNode node = nodes.get(pId);
        if (node != null) {
            node.getAllChildren(isOnlyLeaf ? 2 : 1).forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        }
        return s;
    }

    public static List<SimpleItem> getAssignChildByCustom(String mEntityNum, Object cusPropId, String cusPropLongNum, boolean isOnlyLeaf) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        ArrayList propIds = new ArrayList();
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn,dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        if (cusPropDyna == null) {
            return s;
        }
        String dimId = cusPropDyna.getString("dimension");
        DynamicObjectCollection children = QueryServiceHelper.query((String)"eb_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(cusPropLongNum + '!' + "%")).or("longnumber", "=", (Object)cusPropLongNum), new QFilter("dimension", "=", (Object)dimId)});
        children.forEach(e -> propIds.add(e.get("id")));
        if (!propIds.isEmpty()) {
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("isleaf", "=", (Object)isOnlyLeaf)});
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static List<SimpleItem> getBrotherByCustom(String mEntityNum, Object cusPropId, boolean isIncludeSelf) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"parentid,propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        if (cusPropDyna == null) {
            return s;
        }
        DynamicObjectCollection brothers = QueryServiceHelper.query((String)"eb_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", cusPropDyna.get("parentid"))});
        ArrayList propIds = new ArrayList();
        brothers.forEach(e -> propIds.add(e.get("id")));
        if (!isIncludeSelf) {
            propIds.remove(cusPropId);
        }
        if (!propIds.isEmpty()) {
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray())});
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static boolean isSelfByCustom(String mEntityNum, Object mId, Object cusPropId) {
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "=", cusPropId), new QFilter("id", "=", mId)});
    }

    public static List<SimpleItem> getSelfByCustom(String mEntityNum, Object cusPropId) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getSelfByCustom", (String)"eb_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)}, null, (int)1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(row.getString("propertyid.propertyn"), "=", cusPropId)});
                result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
            }
        }
        return s;
    }

    public static String getLongNumber(String entityNum, String number, Object modelId) {
        DynamicObject baseMember = MemberServiceHelper.getBaseMember(entityNum, "longnumber", new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", modelId)));
        if (baseMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2\u7684\u6210\u5458", (String)"TreeStructureServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[]{DimEntityNumEnum.getNumberByEntieyNum((String)entityNum), number}));
        }
        return baseMember.getString("longnumber");
    }

    public static String getLongNumber(String entityNum, Long id) {
        DynamicObject baseMember = MemberServiceHelper.queryMemberFromCache(entityNum, "longnumber", id);
        if (baseMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2\u7684\u6210\u5458", (String)"TreeStructureServiceHelper_0", (String)"epm-eb-spread", (Object[])new Object[]{DimEntityNumEnum.getNumberByEntieyNum((String)entityNum), id}));
        }
        return baseMember.getString("longnumber");
    }

    public static Map<Long, IDNumberTreeNode> getAllNode(String entityname, Object modelid) {
        return MemberReader.getAllNodeFromCache((String)entityname, (Object)modelid);
    }

    public static Map<Long, MemberTreeNode> getAllMember(String entityname, Object modelid, Pair<Supplier<String>, Function<DynamicObject, Map<String, Object>>> function) {
        MemberTreeNode node;
        QFilter rfilter;
        String key = "membertree|" + entityname + "|" + modelid + "|" + (String)((Supplier)function.p1).get();
        HashMap<Long, MemberTreeNode> nodes = (HashMap<Long, MemberTreeNode>)ThreadCache.get((Object)key);
        if (nodes != null) {
            return nodes;
        }
        QFilter qf = null;
        boolean isCust = "eb_definedpropertyvalue".equals(entityname);
        if (!isCust) {
            qf = new QFilter("model.id", "=", modelid);
        }
        if ("epm_entitymembertree".equals(entityname)) {
            rfilter = new QFilter("isexchangerate", "=", (Object)0);
            qf = qf == null ? rfilter : qf.and(rfilter);
        } else if ("epm_versionmembertree".equals(entityname)) {
            rfilter = new QFilter("isactual", "!=", (Object)"1");
            qf = qf == null ? rfilter : qf.and(rfilter);
        }
        String parent = isCust ? "parentid" : "parent";
        Map dcs = BusinessDataServiceHelper.loadFromCache((String)entityname, (String)((String)((Supplier)function.p1).get() + "id, number, name, copyfrom.id, " + parent), (QFilter[])(qf == null ? null : qf.toArray()), null);
        nodes = new HashMap<Long, MemberTreeNode>(16);
        for (Map.Entry entry : dcs.entrySet()) {
            node = new MemberTreeNode(((DynamicObject)entry.getValue()).getLong("id"), ((DynamicObject)entry.getValue()).getString("number"), ((DynamicObject)entry.getValue()).getString("name"), ((DynamicObject)entry.getValue()).getLong("copyfrom.id"));
            node.setData((Map)((Function)function.p2).apply(entry.getValue()));
            nodes.put((Long)entry.getKey(), node);
        }
        for (DynamicObject obj : dcs.values()) {
            node = (MemberTreeNode)nodes.get(obj.getLong("id"));
            MemberTreeNode pNode = (MemberTreeNode)nodes.get(obj.getLong(parent + "_id"));
            if (pNode == null) continue;
            node.setParent(pNode);
            pNode.addChild(node);
        }
        ThreadCache.put((Object)key, nodes);
        return nodes;
    }

    public static Set<Long> getIds(List<IDNumberTreeNode> nodes) {
        HashSet<Long> ids = new HashSet<Long>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public static Set<String> getNumbers(List<IDNumberTreeNode> nodes) {
        HashSet<String> numbers = new HashSet<String>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                numbers.add(node.getNumber());
            }
        }
        return numbers;
    }

    public static Set<Long> getStorageIds(List<IDNumberTreeNode> nodes) {
        HashSet<Long> ids = new HashSet<Long>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                if (node.getCopyfromId() != 0L) {
                    ids.add(node.getCopyfromId());
                    continue;
                }
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public static QFilter getFilterByCustomScope(RangeEnum range, Object cusPropId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("eb_definedpropertyvalue", modelId);
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"eb_definedpropertyvalue", (String)"parentid,propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        HashSet<Object> ids = new HashSet<Object>();
        IDNumberTreeNode node = nodes.get(cusPropId);
        switch (range) {
            case VALUE_10: {
                ids.add(cusPropId);
                break;
            }
            case VALUE_20: {
                if (node == null) break;
                ids.addAll(node.getChildrenIds());
                break;
            }
            case VALUE_30: {
                if (node != null) {
                    ids.addAll(node.getChildrenIds());
                }
                ids.add(cusPropId);
                break;
            }
            case VALUE_40: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getAllChildren(0), IDNumberTreeNode::getId));
                break;
            }
            case VALUE_50: {
                if (node != null) {
                    ids.addAll(Lists.transform((List)node.getAllChildren(0), IDNumberTreeNode::getId));
                }
                ids.add(cusPropId);
                break;
            }
            case VALUE_60: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getBrother(), IDNumberTreeNode::getId));
                break;
            }
            case VALUE_70: {
                if (node != null) {
                    ids.addAll(Lists.transform((List)node.getBrother(), IDNumberTreeNode::getId));
                }
                ids.add(cusPropId);
                break;
            }
            case VALUE_90: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getAllChildren(2), IDNumberTreeNode::getId));
                break;
            }
            case VALUE_110: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getAllChildren(1), IDNumberTreeNode::getId));
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u679a\u4e3e{%1}\u3002", (String)"TreeStructureServiceHelper_1", (String)"epm-eb-spread", (Object[])new Object[]{range}));
            }
        }
        QFilter qf = ids.isEmpty() || cusPropDyna == null ? new QFilter("1", "=", (Object)2) : new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)ids.toArray());
        return qf;
    }

    public static long getEntityBaseMemberId(long id) {
        return (Long)ThreadCache.get((Object)("base_" + id), () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"eb_dimsharemember", (String)"id,memberid");
            if (dyna == null) {
                return id;
            }
            return dyna.getLong("memberid");
        });
    }

    public static Map<Long, Long> getEntityBaseMemberIds(Collection<Long> ids) {
        return (Map)ThreadCache.get((Object)("base_" + ids), () -> {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            Map shareMemb = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"eb_dimsharemember");
            for (Long id : ids) {
                DynamicObject m = (DynamicObject)shareMemb.get(id);
                if (m != null) {
                    map.put(id, m.getLong("memberid"));
                    continue;
                }
                map.put(id, id);
            }
            return map;
        });
    }
}

