/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.serviceHelper;

import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.log.DebugHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.ebBusiness.model.UserSelectModel;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;

public class UserSelectServiceHelper {
    public static final String defaultFields = "id,model,application,entity,year,period,scenario,currency,modifier,onlymodel,formid,version,modeltype";

    public static UserSelectModel getUserSelect(Long userId, String selectFileds, ApplicationTypeEnum application) {
        DynamicObject dynamicObject = UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("application", "=", (Object)application.index), new QFilter("modifier", "=", (Object)userId), new QFilter("formid", "=", (Object)" ")});
        return UserSelectServiceHelper.transformDynamicObjectToUserSelect(dynamicObject);
    }

    public static UserSelectModel getUserSelectByForm(Long userId, String selectFileds, ApplicationTypeEnum application, String form) {
        if (StringUtils.isEmpty((CharSequence)form)) {
            return UserSelectServiceHelper.getUserSelect(userId, selectFileds, application);
        }
        DynamicObject dynamicObject = UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("application", "=", (Object)application.index), new QFilter("modifier", "=", (Object)userId), new QFilter("formid", "=", (Object)form)});
        return UserSelectServiceHelper.transformDynamicObjectToUserSelect(dynamicObject);
    }

    public static UserSelectModel transformDynamicObjectToUserSelect(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        UserSelectModel userSelect = new UserSelectModel();
        userSelect.setId(dynamicObject.getString("id"));
        userSelect.setModel(dynamicObject.getString("model"));
        userSelect.setOrg(dynamicObject.getString("entity"));
        userSelect.setCurrency(dynamicObject.getString("currency"));
        userSelect.setModifier(dynamicObject.getLong("modifier"));
        userSelect.setPeriod(dynamicObject.getString("period"));
        userSelect.setScene(dynamicObject.getString("scenario"));
        userSelect.setYear(dynamicObject.getString("year"));
        userSelect.setVersion(dynamicObject.getString("version"));
        userSelect.setApplication(ApplicationTypeEnum.getApplication((String)dynamicObject.getString("application")));
        userSelect.setOnlyModel(dynamicObject.getBoolean("onlymodel"));
        userSelect.setFormid(dynamicObject.getString("formid"));
        return userSelect;
    }

    public static DynamicObject getUserSelectDynamicObject(Long userId, String selectFileds, ApplicationTypeEnum application) {
        return UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("application", "=", (Object)application.index), new QFilter("modifier", "=", (Object)userId), new QFilter("formid", "=", (Object)" ")});
    }

    public static DynamicObject queryUserSelect(String selectFields, QFilter[] qFilters) {
        return QueryServiceHelper.queryOne((String)"epm_userselect", (String)selectFields, (QFilter[])qFilters);
    }

    public static void saveUserSelect(UserSelectModel userSelectModel) {
        if (userSelectModel == null || IDUtils.isNull((Long)userSelectModel.getModifier())) {
            return;
        }
        EBThreadPoolExecutor.executeOnce(() -> {
            DynamicObject userSelect;
            try {
                QFilter qf = new QFilter("formid", "=", (Object)" ");
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getFormid())) {
                    qf = new QFilter("formid", "=", (Object)userSelectModel.getFormid());
                }
                userSelect = BusinessDataServiceHelper.loadSingle((String)"epm_userselect", (String)defaultFields, (QFilter[])new QFilter[]{new QFilter("application", "=", (Object)userSelectModel.getApplication().index), new QFilter("modifier", "=", (Object)userSelectModel.getModifier()), qf});
            }
            catch (Exception e) {
                DebugHelper.debugDataObjectType((String[])new String[]{"epm_userselect", "epm_model"});
                throw new RuntimeException(e);
            }
            DynamicObject userSelectObject = userSelect == null ? BusinessDataServiceHelper.newDynamicObject((String)"epm_userselect") : userSelect;
            userSelectObject.set("model", (Object)userSelectModel.getModel());
            if (!userSelectModel.isOnlyModel()) {
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getOrg())) {
                    userSelectObject.set("entity", (Object)userSelectModel.getOrg());
                }
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getYear())) {
                    userSelectObject.set("year", (Object)userSelectModel.getYear());
                }
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getScene())) {
                    userSelectObject.set("scenario", (Object)userSelectModel.getScene());
                    userSelectObject.set("period", null);
                }
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getPeriod()) || userSelectModel.isSPConfig()) {
                    userSelectObject.set("period", (Object)userSelectModel.getPeriod());
                }
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getCurrency())) {
                    userSelectObject.set("currency", (Object)userSelectModel.getCurrency());
                }
                if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getVersion())) {
                    userSelectObject.set("version", (Object)userSelectModel.getVersion());
                }
            } else {
                userSelectObject.set("entity", null);
                userSelectObject.set("year", null);
                userSelectObject.set("scenario", null);
                userSelectObject.set("period", null);
                userSelectObject.set("currency", null);
                userSelectObject.set("version", null);
            }
            userSelectObject.set("modifier", (Object)userSelectModel.getModifier());
            userSelectObject.set("application", (Object)userSelectModel.getApplication().index);
            userSelectObject.set("onlymodel", (Object)(userSelectModel.isOnlyModel() ? "1" : "0"));
            userSelectObject.set("modeltype", (Object)UserSelectServiceHelper.getModelType(IDUtils.toLong((Object)userSelectModel.getModel())));
            userSelectObject.set("formid", (Object)userSelectModel.getFormid());
            SaveServiceHelper.save((IDataEntityType)userSelectObject.getDynamicObjectType(), (Object[])new Object[]{userSelectObject});
        }, (String)"saveUserSelect");
    }

    private static String getModelType(Long modelId) {
        try {
            DynamicObject model_new = ModelUtils.getModel((Long)modelId);
            String reporttype = model_new.getString("reporttype");
            if (kd.epm.eb.common.enums.ApplicationTypeEnum.EB.getIndex().equals(reporttype)) {
                return kd.epm.eb.common.enums.ApplicationTypeEnum.EB.getAppnum();
            }
            return kd.epm.eb.common.enums.ApplicationTypeEnum.BGM.getAppnum();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Object getEntity(Long userId, Long modelId) {
        return AppCacheServiceHelper.get(UserSelectServiceHelper.getEntityKey(userId, modelId), Object.class);
    }

    public static Object getEntity(Long userId, Long modelId, Function<IFormView, Object> function, IFormView formView) {
        Object result = function.apply(formView);
        if (result == null) {
            return AppCacheServiceHelper.get(UserSelectServiceHelper.getEntityKey(userId, modelId), Object.class);
        }
        return String.valueOf(result);
    }

    public static void setEntity(Long userId, Long modelId, Object id) {
        AppCacheServiceHelper.put(UserSelectServiceHelper.getEntityKey(userId, modelId), id);
    }

    private static String getEntityKey(Long modelId, Long userId) {
        return String.format("SelectedEntity_%s_%s", modelId, userId);
    }
}

