/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.ebBusiness.sql.CellSetResultSet;
import kd.epm.eb.ebBusiness.sql.IMDResultSet;
import kd.epm.eb.ebBusiness.sql.MDColumn;
import kd.epm.eb.ebBusiness.sql.MDResultSetMetaData;
import kd.epm.eb.ebBusiness.sql.Row;
import kd.epm.eb.ebBusiness.sql.exception.MDQueryException;

public class MDResultSet
implements IMDResultSet {
    private int cursorPos = 0;
    private int numRows = 0;
    private Row[] rows;
    private MDResultSetMetaData metaData;
    private String measure;
    private Map<MemberMeta, MemberMeta> memberMetaDic = new HashMap<MemberMeta, MemberMeta>();

    @Override
    public boolean next() {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new MDQueryException("Invalid Cursor position");
        }
        return this.internalNext();
    }

    protected boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        return flag;
    }

    @Override
    public void beforeFirst() {
        this.cursorPos = 0;
    }

    @Override
    public void populate(CellSetResultSet rs) {
        List<String> list = rs.getMetaData();
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
        this.measure = rs.getMeasure();
        ArrayList<Row> rows2 = new ArrayList<Row>(10);
        Object[] values = new Object[rs.getMetaData().size()];
        while (rs.getOlapDataReader().next()) {
            Object v;
            rs.getOlapDataReader().getValues(values);
            if (values[0] == null && !rs.isIncludeNull() || (v = values[0]) != null && rs.isOnlyNumber() && !this.isNumber(v)) continue;
            Row row = new Row(this.metaData, this.memberMetaDic);
            int size = values.length;
            for (int i = 1; i < size; ++i) {
                row.addColumnValue(values[i]);
            }
            row.addMeasureValue(values[0]);
            rows2.add(row);
        }
        this.rows = rows2.toArray(new Row[0]);
        this.numRows = rows2.size();
    }

    private boolean isNumber(Object v) {
        return v == null ? false : v instanceof Number;
    }

    @Override
    public void merger(IMDResultSet rs) {
        if (rs == null || rs.isEmpty()) {
            return;
        }
        int rsSize = rs.getFetchSize();
        if (this.rows == null) {
            this.rows = new Row[0];
        }
        int size = this.rows.length + rsSize;
        Row[] mergerRows = new Row[size];
        System.arraycopy(this.rows, 0, mergerRows, 0, this.rows.length);
        int from = this.rows.length;
        rs.beforeFirst();
        while (rs.next()) {
            mergerRows[from++] = rs.getRow();
        }
        this.rows = mergerRows;
        this.numRows = this.rows.length;
    }

    @Override
    public void mergerReduce(IMDResultSet rs) {
        Map<String, Object> selfMap = this.asMap();
        Map<String, Object> otherMap = rs.asMap();
        otherMap.keySet().removeAll(selfMap.keySet());
        if (otherMap.isEmpty()) {
            return;
        }
        int size = this.rows.length + otherMap.size();
        Row[] mergerRows = new Row[size];
        System.arraycopy(this.rows, 0, mergerRows, 0, this.rows.length);
        int from = this.rows.length;
        for (Map.Entry<String, Object> entry : otherMap.entrySet()) {
            Row row = new Row(this.metaData, this.memberMetaDic);
            for (String memb : entry.getKey().split("\\|")) {
                row.addColumnValue(memb);
            }
            row.addMeasureValue(entry.getValue());
            mergerRows[from++] = row;
        }
        this.rows = mergerRows;
        this.numRows = this.rows.length;
        rs.beforeFirst();
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> kvMap = new HashMap<String, Object>(16);
        this.beforeFirst();
        ArrayList keys = new ArrayList(this.metaData.getMetaDatas().size());
        while (this.next()) {
            keys.clear();
            this.metaData.getMetaDatas().forEach(m -> {
                if (!m.getMdName().equals(this.measure)) {
                    keys.add(this.getCurrRow().getString(m.getMdName()));
                }
            });
            kvMap.put(String.join((CharSequence)"|", keys), this.getCurrRow().getOriginalValue(this.measure));
        }
        this.beforeFirst();
        return kvMap;
    }

    @Override
    public Map<String, Object> asMap(String joinSign, List<String> selectDims) {
        HashMap<String, Object> kvMap = new HashMap<String, Object>(16);
        this.beforeFirst();
        ArrayList keys = new ArrayList(selectDims.size());
        while (this.next()) {
            keys.clear();
            selectDims.forEach(s -> keys.add(this.getCurrRow().getString((String)s)));
            kvMap.put(String.join((CharSequence)joinSign, keys), this.getCurrRow().getOriginalValue(this.measure));
        }
        this.beforeFirst();
        return kvMap;
    }

    public void transVirtrual2RealEntity() {
        int index = this.metaData.getColIndex(PresetConstant.ENTITY_DIM);
        if (index == -1) {
            return;
        }
        MDColumn colum = this.metaData.getColumnMeta(PresetConstant.ENTITY_DIM);
        String entity = null;
        for (Row row : this.rows) {
            entity = row.getString(colum.getMdName());
            if (!entity.contains("_")) continue;
            row.replaceColumnValue(colum.getColIndex(), entity.split("_")[1]);
        }
    }

    @Override
    public int getFetchSize() {
        return this.rows == null ? 0 : this.rows.length;
    }

    @Override
    public String getString(String colName) {
        this.checkCursor();
        return this.getCurrRow().getString(colName);
    }

    @Override
    public Object getOriginalValue(String colName) {
        this.checkCursor();
        return this.getCurrRow().getOriginalValue(colName);
    }

    @Override
    public Date getDate(String colName) {
        this.checkCursor();
        return this.getCurrRow().getDate(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        this.checkCursor();
        return this.getCurrRow().getBigDecimal(colName);
    }

    @Override
    public int getInt(String colName) {
        this.checkCursor();
        return this.getCurrRow().getInt(colName);
    }

    protected void checkCursor() {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new MDQueryException("Invalid cursor position");
        }
    }

    private Row getCurrRow() {
        return this.rows[this.cursorPos - 1];
    }

    private boolean isAfterLast() {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    private boolean isBeforeFirst() {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public Row getRow() {
        return this.getCurrRow();
    }

    public int getCount() {
        return this.numRows;
    }

    @Override
    public MDResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void close() {
        this.rows = null;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == null || this.rows.length == 0;
    }

    public static class MemberMeta {
        private Object val;

        MemberMeta(Object v) {
            this.val = v;
        }

        Object get() {
            return this.val;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberMeta) {
                MemberMeta oth = (MemberMeta)obj;
                return oth.toString().equals(this.toString());
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.val == null ? "" : this.val.toString();
        }
    }
}

