/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.utils.ToStringHelper;
import kd.epm.eb.ebBusiness.sql.exception.MDQueryException;

public class SQLBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _cubecatalog;
    private List<String> selector = new LinkedList<String>();
    private List<Pair<String, String[]>> filter = new ArrayList<Pair<String, String[]>>();
    private List<String> measures = new LinkedList<String>();
    private int top = -1;
    private boolean isIncludeNull = false;
    private boolean isCancel = false;
    private boolean isOnlyNumber = false;

    public SQLBuilder(String cubecatalog) {
        this._cubecatalog = cubecatalog;
    }

    public String getCubecatalog() {
        return this._cubecatalog;
    }

    public void addSelectField(String ... dimKeys) {
        for (String f : dimKeys) {
            if (this.selector.contains(f)) {
                throw new MDQueryException(String.format("set repeated field:%s", f));
            }
            this.selector.add(f);
        }
    }

    public String[] getSelectField() {
        return this.selector.toArray(new String[0]);
    }

    public void addFilter(String dimKey, String ... values) {
        this.filter.add((Pair<String, String[]>)Pair.onePair((Object)dimKey, (Object)values));
    }

    public void replaceOrAddFilter(String dimKey, String ... values) {
        boolean isReplace = false;
        for (int i = 0; i < this.filter.size(); ++i) {
            if (!dimKey.equals(this.filter.get((int)i).p1)) continue;
            this.filter.set(i, (Pair<String, String[]>)Pair.onePair((Object)this.filter.get((int)i).p1, (Object)values));
            isReplace = true;
            break;
        }
        if (!isReplace) {
            this.addFilter(dimKey, values);
        }
    }

    public List<Pair<String, String[]>> getFilters() {
        return this.filter;
    }

    public void addMeasures(String ... measures) {
        for (String m : measures) {
            if (this.measures.contains(m)) {
                throw new MDQueryException(String.format("set repeated measure:%s", m));
            }
            this.measures.add(m);
        }
    }

    public String[] getMeasures() {
        String[] stringArray;
        if (this.measures.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = FacTabFieldDefEnum.FIELD_MONEY.getField();
        } else {
            stringArray = this.measures.toArray(new String[0]);
        }
        return stringArray;
    }

    public void reset() {
        this.selector.clear();
        this.filter.clear();
        this.measures.clear();
    }

    public void checkSelf() {
        if (StringUtils.isEmpty((String)this._cubecatalog) || this.selector.isEmpty()) {
            throw new MDQueryException(String.format("SQLBuilder is not complete SQL:%s", ToStringHelper.deepToString((Object)this)));
        }
    }

    public int getTop() {
        return this.top;
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }

    public void setTop(int top) {
        this.top = top;
    }

    public boolean isIncludeNull() {
        return this.isIncludeNull;
    }

    public void setIncludeNull(boolean isIncludeNull) {
        this.isIncludeNull = isIncludeNull;
    }

    public void setCancel(boolean cancel) {
        this.isCancel = cancel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public boolean isOnlyNumber() {
        return this.isOnlyNumber;
    }

    public void setOnlyNumber(boolean isOnlyNumber) {
        this.isOnlyNumber = isOnlyNumber;
    }
}

