/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.sql.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.SysMembConstant;
import kd.epm.eb.common.ebcommon.common.enums.PeriodTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;

public class QCfilterUtils {
    private static final int[] dayofMonth = new int[SysMembConstant.dayofMonth.size()];

    public static QFBuilder getFyAndPeriodFilter(Long modelid, Long yearId, Long periodId, String type) {
        QFBuilder timeBuilder;
        block19: {
            String numLike;
            block21: {
                block20: {
                    timeBuilder = new QFBuilder();
                    DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)periodId).toArray());
                    numLike = dy.getString("number");
                    if (numLike.startsWith("YD_D")) {
                        DynamicObject fy = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_yearmembertree", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)yearId).toArray());
                        return QCfilterUtils.getFyAndPeriodFilterByYD(modelid, fy.getString("number"), numLike, type);
                    }
                    if (!PeriodTypeEnum.PRE.getIndex().equals(type)) break block20;
                    int realMaxPre = 0;
                    if (numLike.startsWith("M_M")) {
                        numLike = "M_M";
                        realMaxPre = 11;
                    } else if (numLike.startsWith("Q_Q")) {
                        numLike = "Q_Q";
                        realMaxPre = 3;
                    } else if (numLike.startsWith("HF_HF")) {
                        numLike = "HF_HF";
                        realMaxPre = 1;
                    }
                    DynamicObjectCollection periods = QueryServiceHelper.query((String)"epm_periodmembertree", (String)"id, name", (QFilter[])new QFBuilder("model", "=", (Object)modelid).add("number", "like", (Object)(numLike + "%")).toArray(), (String)"number");
                    block0: for (int i = periods.size() - 1; i >= 0; --i) {
                        DynamicObject period = (DynamicObject)periods.get(i);
                        if (!periodId.equals(period.getLong("id"))) continue;
                        if (i != 0) {
                            timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(i > realMaxPre ? realMaxPre - 1 : i - 1)).getLong("id"));
                            timeBuilder.add("fy", "=", (Object)yearId);
                            break block19;
                        }
                        timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(periods.size() > realMaxPre + 1 ? realMaxPre : periods.size() - 1)).getLong("id"));
                        DynamicObject parentFy = QueryServiceHelper.queryOne((String)"epm_yearmembertree", (String)"parent", (QFilter[])new QFBuilder("id", "=", (Object)yearId).toArray());
                        DynamicObjectCollection years = QueryServiceHelper.query((String)"epm_yearmembertree", (String)"id, name", (QFilter[])new QFBuilder("parent.id", "=", (Object)parentFy.getLong("parent")).toArray(), (String)"number");
                        for (int j = years.size() - 1; j >= 0; --j) {
                            DynamicObject year = (DynamicObject)years.get(j);
                            if (!yearId.equals(year.getLong("id"))) continue;
                            if (j != 0) {
                                timeBuilder.add("fy", "=", (Object)((DynamicObject)years.get(j - 1)).getLong("id"));
                                continue block0;
                            }
                            timeBuilder.add("1", "=", (Object)"0");
                        }
                    }
                    break block19;
                }
                if (!PeriodTypeEnum.CURRENT.getIndex().equals(type)) break block21;
                timeBuilder.add("period", "=", (Object)periodId);
                timeBuilder.add("fy", "=", (Object)yearId);
                break block19;
            }
            if (!PeriodTypeEnum.NEXT.getIndex().equals(type)) break block19;
            if (numLike.startsWith("M_M")) {
                numLike = "M_M";
            } else if (numLike.startsWith("Q_Q")) {
                numLike = "Q_Q";
            } else if (numLike.startsWith("HF_HF")) {
                numLike = "HF_HF";
            }
            QFilter periodFilter = new QFilter("id", "=", (Object)periodId);
            DynamicObject period = QueryServiceHelper.queryOne((String)"epm_periodmembertree", (String)"level, parent, number", (QFilter[])new QFilter[]{periodFilter});
            int level = period.getInt("level");
            QFilter periodModelFilter = new QFilter("model", "=", (Object)modelid);
            QFilter periodLevelFilter = new QFilter("level", "=", (Object)level);
            QFilter periodNumberFilter = new QFilter("number", "like", (Object)(numLike + "%"));
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"epm_periodmembertree", (String)"id, number", (QFilter[])new QFilter[]{periodModelFilter, periodLevelFilter, periodNumberFilter}, (String)"longNumber");
            block2: for (int i = 0; i <= periods.size() - 1; ++i) {
                period = (DynamicObject)periods.get(i);
                if (!periodId.equals(period.getLong("id"))) continue;
                if (i != periods.size() - 1) {
                    timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(i + 1)).getLong("id"));
                    timeBuilder.add("fy", "=", (Object)yearId);
                    break;
                }
                timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(0)).getLong("id"));
                QFilter fyFilter = new QFilter("id", "=", (Object)yearId);
                DynamicObject fy = QueryServiceHelper.queryOne((String)"epm_yearmembertree", (String)"level", (QFilter[])new QFilter[]{fyFilter});
                level = fy.getInt("level");
                QFilter fyModelFilter = new QFilter("model", "=", (Object)modelid);
                QFilter fyLevelFilter = new QFilter("level", "=", (Object)level);
                DynamicObjectCollection fys = QueryServiceHelper.query((String)"epm_yearmembertree", (String)"id", (QFilter[])new QFilter[]{fyModelFilter, fyLevelFilter}, (String)"longNumber");
                for (int j = 0; j <= fys.size() - 1; ++j) {
                    fy = (DynamicObject)fys.get(j);
                    if (!yearId.equals(fy.getLong("id"))) continue;
                    if (j != fys.size() - 1) {
                        timeBuilder.add("fy", "=", (Object)((DynamicObject)fys.get(j + 1)).getLong("id"));
                        continue block2;
                    }
                    timeBuilder.add("1", "=", (Object)"0");
                }
            }
        }
        return timeBuilder;
    }

    public static QFBuilder getFyAndPeriodFilterByYD(Long modelid, String yearnum, String periodnum, String type) {
        for (int i = 0; i < SysMembConstant.dayofMonth.size(); ++i) {
            QCfilterUtils.dayofMonth[i] = (Integer)SysMembConstant.dayofMonth.get(i);
        }
        QFBuilder timeBuilder = new QFBuilder();
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)modelid).toArray());
        String[] yearperiod = new String[2];
        if (PeriodTypeEnum.PRE.getIndex().equals(type)) {
            yearperiod = PeriodUtils.getLastPeriodIncludeYear((String)model.getString("number"), (String)yearnum, (String)periodnum, (boolean)false);
        } else if (PeriodTypeEnum.CURRENT.getIndex().equals(type)) {
            yearperiod[0] = yearnum;
            yearperiod[1] = periodnum;
        } else if (PeriodTypeEnum.NEXT.getIndex().equals(type)) {
            int mouth = Integer.parseInt(periodnum.substring(0, 2));
            int day = Integer.parseInt(periodnum.substring(2));
            int year = Integer.parseInt(yearnum.split("FY")[1]);
            if (++day > dayofMonth[mouth]) {
                day = 1;
                if (++mouth > 12) {
                    mouth = 1;
                    ++year;
                }
            }
            yearperiod[0] = "FY" + year;
            yearperiod[1] = String.format("%02d%02d", mouth, day);
        }
        DynamicObject year = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_yearmembertree", (String)"number", (QFilter[])new QFBuilder("number", "=", (Object)yearperiod[0]).add("model", "=", (Object)modelid).toArray());
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"number", (QFilter[])new QFBuilder("number", "=", (Object)yearperiod[1]).add("model", "=", (Object)modelid).toArray());
        if (year == null || period == null) {
            timeBuilder.add("1", "=", (Object)"0");
        } else {
            timeBuilder.add("period", "=", period.get("id"));
            timeBuilder.add("fy", "=", year.get("id"));
        }
        return timeBuilder;
    }

    public static String[] getNextPeriod(Long modelid, Long yearId, Long periodId, String type) {
        String[] nextPeriod = new String[2];
        QFBuilder builder = QCfilterUtils.getFyAndPeriodFilter(modelid, yearId, periodId, type);
        QFilter[] result = builder.toArray();
        if (result.length == 0) {
            return null;
        }
        for (QFilter qFilter : result) {
            if ("1".equals(qFilter.getProperty())) {
                return null;
            }
            if ("period".equals(qFilter.getProperty())) {
                nextPeriod[1] = qFilter.getValue().toString();
                continue;
            }
            if (!"fy".equals(qFilter.getProperty())) continue;
            nextPeriod[0] = qFilter.getValue().toString();
        }
        return nextPeriod;
    }
}

