/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.sql.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import kd.bos.util.StringUtils;
import kd.epm.eb.ebBusiness.sql.exception.IllegalConversionException;
import kd.epm.eb.ebBusiness.sql.exception.InvalidDataException;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;

public class TypeConversionUtils {
    public static String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public static BigDecimal objToBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
            return null;
        }
        try {
            if (obj instanceof Double) {
                return BigDecimal.valueOf((Double)obj);
            }
            return new BigDecimal(obj.toString());
        }
        catch (RuntimeException ex) {
            IllegalConversionException illegalConversionException = new IllegalConversionException("NumberFormatException\uff1a" + ex.getMessage());
            illegalConversionException.initCause(ex);
            throw illegalConversionException;
        }
    }

    public static int objToInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).ordinal();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (RuntimeException ex) {
            IllegalConversionException illegalConversionException = new IllegalConversionException("Illegal conversion\uff1a" + ex.getMessage());
            illegalConversionException.initCause(ex);
            throw illegalConversionException;
        }
    }

    public static Date objToDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        try {
            if (obj instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)obj;
                return new Date(timestamp.getTime());
            }
            if (obj instanceof Date) {
                java.sql.Date date = (java.sql.Date)obj;
                return new Date(date.getTime());
            }
            return new Date(DateTimeUtils.parseDate(obj.toString()).getTime());
        }
        catch (RuntimeException ex) {
            InvalidDataException invalidDataException = new InvalidDataException("Illegal date value - Java Date Objects cannot be earlier than 1/1/70\uff1a" + ex.getMessage());
            invalidDataException.initCause(ex);
            throw invalidDataException;
        }
        catch (Exception ex) {
            IllegalConversionException illegalConversionException = new IllegalConversionException("Illegal conversion\uff1a" + ex.getMessage());
            illegalConversionException.initCause(ex);
            throw illegalConversionException;
        }
    }
}

