/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.template.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.ebBusiness.template.model.BaseEntry;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.ILoader;
import kd.epm.eb.ebBusiness.template.model.Member;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class PageDimensionEntry
extends BaseEntry
implements ILoader<DynamicObjectCollection, List<PageDimensionEntry>, TemplateModel> {
    private static final long serialVersionUID = 1L;

    public PageDimensionEntry(TemplateModel template) {
        super(template);
        this.put("members", (Object)new ArrayList());
        this.setDataEntityNumber("eb_templateentity_bg.pagemembentry");
    }

    public List<Member> getMembers() {
        return (List)this.get("members");
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        for (Member m : this.getMembers()) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("pagedimension", (Object)this.getDimension().getId());
            dyna.set("pagemembid", (Object)m.getId());
            dyna.set("seq", (Object)incrementer.getAndIncrement());
            dyna.set("membbound", (Object)m.getScope());
            coll.add((Object)dyna);
        }
        if (this.getMembers().isEmpty()) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("pagedimension", (Object)this.getDimension().getId());
            dyna.set("pagemembid", null);
            dyna.set("seq", (Object)incrementer.getAndIncrement());
            dyna.set("membbound", (Object)10);
            coll.add((Object)dyna);
        }
        return coll;
    }

    @Override
    public List<PageDimensionEntry> loadDynaObject(DynamicObjectCollection t, Supplier<TemplateModel> s) {
        Long dimId;
        PageDimensionEntry entry;
        LinkedHashMap<Long, PageDimensionEntry> dimMap = new LinkedHashMap<Long, PageDimensionEntry>();
        LinkedHashMap<Long, List<Long>> dimtoMembMap = new LinkedHashMap<Long, List<Long>>();
        LinkedHashMap<Long, Integer> membMaptoScope = new LinkedHashMap<Long, Integer>();
        LinkedHashMap memberEntityMap = new LinkedHashMap();
        for (DynamicObject o2 : t) {
            DynamicObject dyna = o2.getDynamicObject("pagedimension");
            long id = dyna.getLong("id");
            if (!dimMap.containsKey(id)) {
                Dimension d = new Dimension();
                entry = new PageDimensionEntry(s.get());
                entry.setSeq(o2.getInt("seq"));
                entry.setId(id);
                d.loadSimpleDynamicObject(dyna);
                entry.setDimension(d);
                d.setDataEntityNumber(dyna.getDataEntityType().getName());
                d.setMemberEntityNumber(dyna.getString("membermodel"));
                d.setFieldmapped(dyna.getString("fieldmapped"));
                dimMap.put(id, entry);
            }
            if (!dimtoMembMap.containsKey(id)) {
                dimtoMembMap.put(id, new ArrayList());
            }
            ((List)dimtoMembMap.get(id)).add(o2.getLong("pagemembid"));
            membMaptoScope.put(o2.getLong("pagemembid"), o2.getInt("membbound"));
        }
        String memberEnityNumber = "";
        ArrayList<PageDimensionEntry> entries = new ArrayList<PageDimensionEntry>(dimMap.size());
        LinkedHashMap<Long, PageDimensionEntry> pageDimensionEntryMap = new LinkedHashMap<Long, PageDimensionEntry>(dimMap.size());
        for (Map.Entry e : dimMap.entrySet()) {
            entry = (PageDimensionEntry)e.getValue();
            memberEnityNumber = entry.getDimension().getMemberEntityNumber();
            dimId = entry.getDimension().getId();
            if (!memberEntityMap.containsKey(memberEnityNumber)) {
                memberEntityMap.put(memberEnityNumber, new ArrayList());
            }
            ((List)memberEntityMap.get(memberEnityNumber)).add(dimId);
            entries.add(entry);
            pageDimensionEntryMap.put(dimId, entry);
        }
        entries.sort(new Comparator<PageDimensionEntry>(){

            @Override
            public int compare(PageDimensionEntry o1, PageDimensionEntry o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        ArrayList memberIdList = new ArrayList();
        String selectFields = "id,name,number";
        Map map = (Map)ThreadCache.get((Object)"dim-mem");
        for (Map.Entry memberEntity : memberEntityMap.entrySet()) {
            memberEnityNumber = (String)memberEntity.getKey();
            List dimIdList = (List)memberEntity.getValue();
            dimIdList.forEach((? super T p) -> {
                List temp = (List)dimtoMembMap.get(p);
                memberIdList.addAll(temp);
            });
            DynamicObjectCollection dyMemberEntityCol = null;
            if (map != null) {
                dyMemberEntityCol = new DynamicObjectCollection();
                for (Long memId : memberIdList) {
                    if (memId == 0L) continue;
                    dyMemberEntityCol.add(map.get(memberEnityNumber + "|" + memId));
                }
            } else {
                dyMemberEntityCol = QueryServiceHelper.query((String)memberEnityNumber, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", memberIdList)});
            }
            HashMap objmaps = new HashMap();
            dyMemberEntityCol.forEach(o -> objmaps.put(o.getLong("id"), o));
            for (Long mid : memberIdList) {
                DynamicObject item = (DynamicObject)objmaps.get(mid);
                if (item == null) continue;
                Long memberId = item.getLong("id");
                dimId = PageDimensionEntry.getDimToMemberDimId(dimtoMembMap, memberId);
                entry = (PageDimensionEntry)pageDimensionEntryMap.get(dimId);
                Member m = new Member();
                m.setDimension(entry.getDimension());
                m.setScope((Integer)membMaptoScope.get(memberId));
                m.loadSimpleDynamicObject(item);
                m.setDataEntityNumber(entry.getDimension().getMemberEntityNumber());
                entry.getMembers().add(m);
            }
            memberIdList.clear();
        }
        return entries;
    }

    private static Long getDimToMemberDimId(Map<Long, List<Long>> dimtoMembMap, Long value) {
        for (Map.Entry<Long, List<Long>> entry : dimtoMembMap.entrySet()) {
            List<Long> tempValueList = entry.getValue();
            if (!tempValueList.contains(value)) continue;
            return entry.getKey();
        }
        return 0L;
    }

    @Override
    protected boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "members".equals(key) || "dimension".equals(key);
    }
}

