/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.template.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.ebBusiness.template.model.BaseEntry;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.ILoader;
import kd.epm.eb.ebBusiness.template.model.Member;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class ViewPointDimensionEntry
extends BaseEntry
implements ILoader<DynamicObjectCollection, List<ViewPointDimensionEntry>, TemplateModel> {
    private static final long serialVersionUID = 1L;

    public ViewPointDimensionEntry(TemplateModel template) {
        super(template);
        this.setDataEntityNumber("eb_templateentity_bg.viewpointmembentry");
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        dyna.set("viewdimension", (Object)this.getDimension().getId());
        dyna.set("viewmembid", (Object)this.getMember().getId());
        dyna.set("seq", (Object)incrementer.getAndIncrement());
        coll.add((Object)dyna);
        return coll;
    }

    @Override
    public List<ViewPointDimensionEntry> loadDynaObject(DynamicObjectCollection t, Supplier<TemplateModel> s) {
        Member m;
        ViewPointDimensionEntry entry;
        ArrayList<ViewPointDimensionEntry> entries = new ArrayList<ViewPointDimensionEntry>();
        LinkedHashMap memberEntityMap = new LinkedHashMap();
        LinkedHashMap<Long, ViewPointDimensionEntry> viewPointDimEntityMap = new LinkedHashMap<Long, ViewPointDimensionEntry>();
        for (DynamicObject o : t) {
            entry = new ViewPointDimensionEntry(s.get());
            entry.setId(o.getLong("id"));
            entry.setSeq(o.getInt("seq"));
            Dimension d = new Dimension();
            DynamicObject dyna = o.getDynamicObject("viewdimension");
            if (dyna == null) continue;
            d.loadSimpleDynamicObject(dyna);
            d.setDataEntityNumber(dyna.getDataEntityType().getName());
            d.setMemberEntityNumber(dyna.getString("membermodel"));
            d.setFieldmapped(dyna.getString("fieldmapped"));
            entry.setDimension(d);
            if (!memberEntityMap.containsKey(d.getMemberEntityNumber())) {
                memberEntityMap.put(d.getMemberEntityNumber(), new ArrayList());
            }
            ((List)memberEntityMap.get(d.getMemberEntityNumber())).add(o.getLong("viewmembid"));
            m = new Member();
            m.setDimension(d);
            m.setDataEntityNumber(d.getMemberEntityNumber());
            entry.setMember(m);
            entries.add(entry);
            viewPointDimEntityMap.put(o.getLong("viewmembid"), entry);
        }
        String entryMember = "";
        String selectFields = "id,name,number";
        Map map = (Map)ThreadCache.get((Object)"dim-mem-viewpoint");
        for (Map.Entry entryMemberEntry : memberEntityMap.entrySet()) {
            entryMember = (String)entryMemberEntry.getKey();
            List viewMembIdList = (List)entryMemberEntry.getValue();
            Object dyEntryMemberCol = null;
            QFilter filterEntryMember = new QFilter("id", "in", (Object)viewMembIdList);
            if (map != null) {
                dyEntryMemberCol = new DynamicObjectCollection();
                for (Long memId : viewMembIdList) {
                    if (memId == 0L) continue;
                    dyEntryMemberCol.add(map.get(entryMember + "|" + memId));
                }
            } else {
                dyEntryMemberCol = BusinessDataServiceHelper.loadFromCache((String)entryMember, (String)selectFields, (QFilter[])filterEntryMember.toArray()).values();
            }
            Iterator iterator = dyEntryMemberCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject item = (DynamicObject)iterator.next();
                Long entryMemberId = item.getLong("id");
                entry = (ViewPointDimensionEntry)viewPointDimEntityMap.get(entryMemberId);
                m = entry.getMember();
                m.loadSimpleDynamicObject(item);
                m.setDataEntityNumber(entry.getDimension().getMemberEntityNumber());
            }
        }
        return entries;
    }

    @Override
    protected boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "member".equals(key) || "dimension".equals(key);
    }
}

