/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;
import kd.epm.eb.ebBusiness.util.EntityVersioningUtil;

public class AccountVersioningUtil {
    public static Collection<DynamicObject> getVersionAccountTree(long modelId, long yearId, long periodId) {
        Collection<DynamicObject> accountTree = BusinessDataServiceHelper.loadFromCache((String)"epm_accountmembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArray()).values();
        AccountVersioningUtil.filterVersionAccountTree(accountTree, modelId, yearId, periodId);
        return accountTree;
    }

    public static void filterVersionAccountTree(Collection<DynamicObject> accountTree, long modelId, long yearId, long periodId) {
        String yearNum = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"epm_yearmembertree", (String)"number").getString("number");
        AccountVersioningUtil.filterVersionAccountTree(accountTree, modelId, yearNum, periodId);
    }

    public static void filterVersionAccountTree(Collection<DynamicObject> doc, long modelId, String yearNum, long periodId) {
        DynamicObject periodDo;
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo = EntityVersioningUtil.getPeriodFilter(periodId));
        if (lastDate == null) {
            return;
        }
        HashSet set = new HashSet();
        doc.forEach(a -> set.add(a.getLong("id")));
        Collection allData = BusinessDataServiceHelper.loadFromCache((String)"epm_accountmembertree", (String)"id, isleaf, bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate", (QFilter[])new QFBuilder("id", "in", set).toArray()).values();
        HashSet<Long> exist = new HashSet<Long>();
        block0: for (DynamicObject account : allData) {
            DynamicObjectCollection bizchangerds = account.getDynamicObjectCollection("bizchangerds");
            if (bizchangerds != null && !bizchangerds.isEmpty()) {
                for (int i = 0; i < bizchangerds.size(); ++i) {
                    DynamicObject rd = (DynamicObject)bizchangerds.get(i);
                    Date bizeffdate = rd.getDate("bizeffdate");
                    Date bizexpdate = rd.getDate("bizexpdate");
                    if ((bizeffdate.getTime() > lastDate.getTime() || bizexpdate != null) && (bizeffdate.getTime() > lastDate.getTime() || bizexpdate.getTime() < lastDate.getTime())) continue;
                    exist.add(account.getLong("id"));
                    continue block0;
                }
                continue;
            }
            exist.add(account.getLong("id"));
        }
        HashSet toDel = new HashSet();
        Map<Long, IDNumberTreeNode> nodeMap = TreeStructureServiceHelper.getAllNode("epm_accountmembertree", modelId);
        allData.forEach(tmp -> {
            IDNumberTreeNode node;
            Long accountId = tmp.getLong("id");
            if (!exist.contains(accountId) && !tmp.getBoolean("isleaf") && (node = (IDNumberTreeNode)nodeMap.get(tmp.getLong("id"))) != null) {
                toDel.addAll(TreeStructureServiceHelper.getIds(node.getAllChildren()));
            }
        });
        doc.removeIf(o -> {
            Long accountId = o.getLong("id");
            return toDel.contains(accountId) || !exist.contains(accountId);
        });
    }

    public static void insertInitAccountVersionData(DynamicObject[] accounts, Date initEffDate, long userId) {
        DynamicObject[] accountsBizChangerds = new DynamicObject[accounts.length];
        Date today = new Date();
        int idx = 0;
        String modelid = accounts[0].getDynamicObject("model").getString("id");
        DynamicObjectType accountType = accounts[0].getDynamicObjectCollection("bizchangerds").getDynamicObjectType();
        for (DynamicObject account : accounts) {
            DynamicObject tmpData = new DynamicObject(accountType);
            if (account.getDynamicObject("model") == null) continue;
            tmpData.set("bizmodifytime", (Object)today);
            tmpData.set("modelid", (Object)modelid);
            tmpData.set("bizmodifier", (Object)userId);
            tmpData.set("bizeffdate", (Object)initEffDate);
            DynamicObjectCollection bizs = account.getDynamicObjectCollection("bizchangerds");
            if (bizs.size() < 1) {
                account.getDynamicObjectCollection("bizchangerds").add((Object)tmpData);
            } else {
                tmpData.set("bizexpdate", (Object)((DynamicObject)bizs.get(bizs.getStartRowIndex())).getDate("bizexpdate"));
                account.getDynamicObjectCollection("bizchangerds").set(0, (Object)tmpData);
            }
            accountsBizChangerds[idx] = account;
            ++idx;
        }
        SaveServiceHelper.save((DynamicObject[])Arrays.copyOfRange(accountsBizChangerds, 0, idx));
    }

    public static void changeAccountVersionInitEffectDate(DynamicObject model, long userId) {
        Date fyBeginDate = EntityVersioningUtil.getModelBeginDate(model);
        String showNumber = model.getString("shownumber");
        QFilter selectByShowNumber = new QFilter("shownumber", "=", (Object)showNumber);
        DynamicObject thisModel = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id", (QFilter[])selectByShowNumber.toArray());
        String thisModelId = thisModel.getString("id");
        QFilter selectAccountByModelId = new QFilter("model.id", "=", (Object)thisModelId);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"epm_accountmembertree", (String)"id, model, bizchangerds, bizeffdate, bizexpdate, bizmodifier, bizmodifytime, modelid", (QFilter[])selectAccountByModelId.toArray());
        try {
            AccountVersioningUtil.insertInitAccountVersionData(accounts, fyBeginDate, userId);
        }
        catch (Exception exception) {
            exception.getMessage();
        }
    }
}

