/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.util;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.cache.IDNumberTreeNode;
import kd.epm.eb.common.ebcommon.common.enums.FyEnum;
import kd.epm.eb.common.ebcommon.common.enums.OrgBizChangeTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;

public class EntityVersioningUtil {
    private static int FROM_COMMON = 1;
    private static int FROM_REPORT = 2;
    private static int FROM_CHECK = 3;
    private static int FROM_TASK = 4;

    public static DynamicObjectCollection queryFYFirstDay(Object modelId) {
        String selectFields = "startfy,beginyearofmonth,beginperiod";
        QFilter filter1 = new QFilter("id", "=", modelId);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_model", (String)selectFields, (QFilter[])filters, (String)"");
        return dcs;
    }

    public static String checkModelDate(Object modelId, Date date) {
        DynamicObjectCollection dcs = EntityVersioningUtil.queryFYFirstDay(modelId);
        if (dcs != null && dcs.size() == 1) {
            String startfy = ((DynamicObject)dcs.get(0)).getString("startfy");
            String beginyearofmonth = ((DynamicObject)dcs.get(0)).getString("beginyearofmonth");
            String beginperiod = ((DynamicObject)dcs.get(0)).getString("beginperiod");
            int fyyear = Integer.parseInt(startfy) + 1996;
            int fymonth = Integer.parseInt(beginperiod);
            if (FyEnum.PRE.getIndex().equals(beginyearofmonth)) {
                --fyyear;
            }
            LocalDate ld = LocalDate.of(fyyear, fymonth, 1);
            ZoneId zd = ZoneId.systemDefault();
            ZonedDateTime zdt = ld.atStartOfDay(zd);
            Date modelEffDate = Date.from(zdt.toInstant());
            if (date == null || date.compareTo(modelEffDate) < 0) {
                String strfymonth = "";
                strfymonth = fymonth < 10 ? "0" + fymonth : String.valueOf(fymonth);
                return ResManager.loadResFormat((String)"\u751f\u6548\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u4e0d\u53ef\u65e9\u4e8e%1-%2-01\u3002", (String)"EntityVersioningUtil_0", (String)"epm-eb-spread", (Object[])new Object[]{fyyear, strfymonth});
            }
        }
        return "";
    }

    public static DynamicObjectCollection getOrgChangeRecords(List<DynamicObject> orgs, int from) {
        HashSet<Long> set = new HashSet<Long>();
        for (int i = 0; i < orgs.size(); ++i) {
            if (from == FROM_COMMON) {
                set.add(orgs.get(i).getLong("id"));
                continue;
            }
            if (from == FROM_REPORT) {
                set.add(orgs.get(i).getLong("entity.id"));
                continue;
            }
            if (from == FROM_CHECK) {
                set.add(orgs.get(i).getLong("org.id"));
                continue;
            }
            if (from != FROM_TASK) continue;
            set.add(orgs.get(i).getLong("entity"));
        }
        QFilter qcs = new QFilter("id", "in", (Object)set.toArray());
        DynamicObjectCollection allData = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,name,number,isleaf,longNumber,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate", (QFilter[])new QFilter[]{qcs}, (String)"dseq, bizchangerds.seq, namechangerds.seq");
        return allData;
    }

    public static DynamicObjectCollection getOrgCollectionAfterVersion(Object modelId, String yearNum, Object periodId, QFilter[] orgFilter, Function<DynamicObjectCollection, DynamicObjectCollection> permissionHandle) {
        DynamicObjectCollection doc = EntityVersioningUtil.getOrgCollection("epm_entitymembertree", orgFilter, "dseq");
        if (permissionHandle != null) {
            permissionHandle.apply(doc);
        }
        if (StringUtils.isNotEmpty((String)yearNum) && periodId != null) {
            EntityVersioningUtil.filterVersionOrgTree(doc, modelId, yearNum, periodId);
        }
        return doc;
    }

    public static DynamicObjectCollection getOrgCollection(String entityName, QFilter[] filters, String orderBys) {
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.addAll(BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,name,number,parent.id,isleaf,storagetype,orgcode,currency", (QFilter[])filters, (String)orderBys).values());
        return coll;
    }

    public static void filterVersionOrgTree(DynamicObjectCollection orgTree, Object modelId, String yearNum, Object periodId) {
        EntityVersioningUtil.filterVersionOrgTree((List<DynamicObject>)orgTree, modelId, yearNum, periodId, EntityVersioningUtil.getOrgChangeRecords((List<DynamicObject>)orgTree, FROM_COMMON));
    }

    public static void filterVersionOrgTree(List<DynamicObject> orgTree, Object modelId, String yearNum, Object periodId, DynamicObjectCollection allData) {
        EntityVersioningUtil.filterOrgsByVersion(orgTree, modelId, yearNum, periodId, allData, FROM_COMMON);
    }

    public static void filterOrgOnReportList(DynamicObjectCollection reportList, Object modelId, String yearNum, Object periodId) {
        EntityVersioningUtil.filterOrgsByVersion((List<DynamicObject>)reportList, modelId, yearNum, periodId, EntityVersioningUtil.getOrgChangeRecords((List<DynamicObject>)reportList, FROM_REPORT), FROM_REPORT);
    }

    private static void filterOrgsByVersion(List<DynamicObject> doc, Object modelId, String yearNum, Object periodId, DynamicObjectCollection allData, int from) {
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return;
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        HashSet<Long> exist = new HashSet<Long>();
        HashSet<Long> toDel = new HashSet<Long>();
        for (DynamicObject tmp2 : allData) {
            String name = tmp2.getString("namechangerds.namerds");
            Date bizeffdate = tmp2.getDate("bizchangerds.bizeffdate");
            if (bizeffdate == null || name == null) {
                exist.add(tmp2.getLong("id"));
                continue;
            }
            if (exist.contains(tmp2.getLong("id")) || toDel.contains(tmp2.getLong("id"))) continue;
            Date bizexpdate = tmp2.getDate("bizchangerds.bizexpdate");
            Date nameeffdate = tmp2.getDate("namechangerds.nameeffdate");
            Date nameexpdate = tmp2.getDate("namechangerds.nameexpdate");
            if (bizeffdate.compareTo(lastDate) > 0 || bizexpdate != null && bizexpdate.compareTo(lastDate) < 0) continue;
            if (tmp2.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.disable.getValue())) {
                toDel.add(tmp2.getLong("id"));
                continue;
            }
            if ((tmp2.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || tmp2.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue())) && DateTimeUtils.getYear(firstDate) - DateTimeUtils.getYear(bizeffdate) > 0) {
                toDel.add(tmp2.getLong("id"));
                continue;
            }
            if (tmp2.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue()) && firstDate.compareTo(bizeffdate) > 0) {
                toDel.add(tmp2.getLong("id"));
                continue;
            }
            if (nameeffdate.compareTo(lastDate) > 0 || nameexpdate != null && nameexpdate.compareTo(lastDate) < 0) continue;
            exist.add(tmp2.getLong("id"));
            map.put(tmp2.getLong("id"), name);
        }
        HashSet toDelInNotLeafLongNumbers = new HashSet();
        Map<Long, IDNumberTreeNode> nodeMap = TreeStructureServiceHelper.getAllNode("epm_entitymembertree", modelId);
        allData.forEach(tmp -> {
            IDNumberTreeNode node;
            Long orgId = tmp.getLong("id");
            String longNumber = tmp.getString("longNumber");
            if (toDelInNotLeafLongNumbers.add(longNumber) && (toDel.contains(orgId) || !exist.contains(orgId)) && !tmp.getBoolean("isleaf") && (node = (IDNumberTreeNode)nodeMap.get(tmp.getLong("id"))) != null) {
                toDel.addAll(TreeStructureServiceHelper.getIds(node.getAllChildren()));
            }
        });
        doc.removeIf(o -> {
            Long orgId = null;
            if (from == FROM_COMMON) {
                orgId = o.getLong("id");
            } else if (from == FROM_REPORT) {
                orgId = o.getLong("entity.id");
            } else if (from == FROM_CHECK) {
                orgId = o.getLong("org.id");
            } else if (from == FROM_TASK) {
                orgId = o.getLong("entity");
            }
            return toDel.contains(orgId) || !exist.contains(orgId);
        });
        if (doc.size() == 0) {
            return;
        }
        DataEntityPropertyCollection properties = doc.get(0).getDataEntityType().getProperties();
        if (!(properties.containsKey((Object)"name") || properties.containsKey((Object)"entity") || properties.containsKey((Object)"org"))) {
            return;
        }
        doc.forEach(o -> {
            if (from == FROM_COMMON) {
                if (!"Entity".equals(o.getString("number")) && map.get(o.getLong("id")) != null) {
                    o.set("name", map.get(o.getLong("id")));
                }
            } else if (from == FROM_REPORT) {
                if (map.get(o.getLong("entity.id")) != null) {
                    o.set("entity.name", map.get(o.getLong("entity.id")));
                }
            } else if (from == FROM_CHECK) {
                if (map.get(o.getLong("org.id")) != null) {
                    o.set("org.name", map.get(o.getLong("org.id")));
                }
            } else if (from == FROM_TASK && map.get(o.getLong("entity")) != null) {
                o.set("entity.name", map.get(o.getLong("entity")));
            }
        });
    }

    private static DynamicObject getOrgBizInfo(long orgId, Object modelId, Object yearId, Object periodId) {
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        String yearNum = EntityVersioningUtil.getYearFilter(yearId).getString("number");
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return null;
        }
        DynamicObjectCollection allData = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id, name, bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)}, (String)"bizchangerds.seq, namechangerds.seq");
        for (DynamicObject tmp : allData) {
            String name = tmp.getString("namechangerds.namerds");
            Date bizeffdate = tmp.getDate("bizchangerds.bizeffdate");
            if (bizeffdate == null || name == null) {
                return null;
            }
            Date bizexpdate = tmp.getDate("bizchangerds.bizexpdate");
            Date nameeffdate = tmp.getDate("namechangerds.nameeffdate");
            Date nameexpdate = tmp.getDate("namechangerds.nameexpdate");
            if (bizeffdate.compareTo(lastDate) > 0 || bizexpdate != null && bizexpdate.compareTo(lastDate) < 0 || nameeffdate.compareTo(lastDate) > 0 || nameexpdate != null && nameexpdate.compareTo(lastDate) < 0) continue;
            return tmp;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"epm_entitymembertree");
    }

    public static boolean isLiquidation(DynamicObject org, Object modelId, Object yearId, Object periodId) {
        DynamicObject orgBizInfo = EntityVersioningUtil.getOrgBizInfo(org.getLong("id"), modelId, yearId, periodId);
        if (orgBizInfo != null) {
            DataEntityPropertyCollection properties = orgBizInfo.getDataEntityType().getProperties();
            if (properties != null && properties.containsKey((Object)"name")) {
                Date realDay;
                org.set("name", orgBizInfo.get("namechangerds.namerds"));
                if ((OrgBizChangeTypeEnum.liquidationDisposal.getValue().equals(orgBizInfo.getString("bizchangerds.changetype")) || OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(orgBizInfo.getString("bizchangerds.changetype"))) && DateTimeUtils.getMonth(realDay = EntityVersioningUtil.getRealDay(modelId, yearId, periodId)) - DateTimeUtils.getMonth(orgBizInfo.getDate("bizchangerds.bizeffdate")) > 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static String getEffOrgName(DynamicObject org, Object modelId, Object yearId, Object periodId) {
        DynamicObject orgBizInfo = EntityVersioningUtil.getOrgBizInfo(org.getLong("id"), modelId, yearId, periodId);
        if (orgBizInfo != null) {
            DataEntityPropertyCollection properties = orgBizInfo.getDataEntityType().getProperties();
            if (properties != null && properties.containsKey((Object)"name")) {
                return orgBizInfo.getString("namechangerds.namerds");
            }
            return orgBizInfo.getString("name");
        }
        return "";
    }

    public static DynamicObject getModelFilter(Object modelId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)modelId), (String)"epm_model", (String)"id, beginyearofmonth");
    }

    public static DynamicObject getYearFilter(Object yearId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"epm_yearmembertree", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)yearId))});
    }

    public static DynamicObject getPeriodFilter(Object periodId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"id, effmonth, effday, expmonth, expday", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)periodId))});
    }

    public static Date getRealDay(Object modelId, Object yearId, Object periodId) {
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        DynamicObject yearDo = EntityVersioningUtil.getYearFilter(yearId);
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        return EntityVersioningUtil.getFilterDay(true, modelDo, yearDo.getString("number"), periodDo);
    }

    public static Date getFilterDay(boolean isFirst, DynamicObject modelDo, String yearNum, DynamicObject periodDo) {
        int year = 0;
        try {
            year = Integer.parseInt(yearNum.substring(2));
        }
        catch (Exception e) {
            return null;
        }
        String beginyearofmonth = modelDo.getString("beginyearofmonth");
        if (FyEnum.PRE.getIndex().equals(beginyearofmonth)) {
            --year;
        }
        int month = 0;
        int day = 0;
        try {
            if (isFirst) {
                month = periodDo.getInt("effmonth");
                day = periodDo.getInt("effday");
            } else {
                month = periodDo.getInt("expmonth");
                day = periodDo.getInt("expday");
            }
        }
        catch (Exception e) {
            return null;
        }
        String dateStr = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month)).concat("-").concat(day < 10 ? "0" + day : String.valueOf(day));
        try {
            return DateTimeUtils.parseDate(dateStr);
        }
        catch (ParseException e) {
            if (day == 29) {
                dateStr = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month)).concat("-").concat(day < 10 ? "0" + day : String.valueOf(--day));
            }
            try {
                return DateTimeUtils.parseDate(dateStr);
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    public static boolean checkChildrenIsLiquidation(Object orgId) {
        QFilter filter = new QFilter("parent", "=", orgId);
        DynamicObjectCollection children = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,bizchangerds.changetype", (QFilter[])new QFilter[]{filter}, (String)"dseq, bizchangerds.seq desc");
        ArrayList<String> isLiquidationList = new ArrayList<String>();
        ArrayList<String> notLiquidationList = new ArrayList<String>();
        for (DynamicObject tmp : children) {
            if (isLiquidationList.contains(tmp.getString("id")) || notLiquidationList.contains(tmp.getString("id"))) continue;
            if (tmp.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || tmp.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue())) {
                isLiquidationList.add(tmp.getString("id"));
                continue;
            }
            notLiquidationList.add(tmp.getString("id"));
        }
        return notLiquidationList.size() > 0;
    }

    public static boolean checkParentIsLiquidation(Object orgId) {
        if ("0".equals(orgId.toString())) {
            return false;
        }
        QFilter filter = new QFilter("id", "=", orgId);
        DynamicObjectCollection parent = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"parent.number,parent.bizchangerds.changetype", (QFilter[])new QFilter[]{filter}, (String)"parent.bizchangerds.seq desc");
        if (parent.size() > 0) {
            DynamicObject lastRecord = (DynamicObject)parent.get(0);
            String changeType = lastRecord.getString("parent.bizchangerds.changetype");
            return !"Entity".equals(lastRecord.getString("parent.number")) && (OrgBizChangeTypeEnum.liquidationDisposal.getValue().equals(changeType) || OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(changeType));
        }
        return false;
    }

    public static Date getModelBeginDate(Object modelId) {
        QFilter qModel = new QFilter("id", "=", modelId);
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"number,startfy,beginperiod,beginyearofmonth", (QFilter[])new QFilter[]{qModel});
        return EntityVersioningUtil.getModelBeginDate(model);
    }

    public static Date getModelBeginDate(DynamicObject model) {
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"EntityVersioningUtil_9", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        int firstYear = model.getInt("startfy") + 1997 - 1;
        int firstMonth = model.getInt("beginperiod");
        String beginYearType = model.getString("beginyearofmonth");
        if (FyEnum.PRE.getIndex().equals(beginYearType)) {
            --firstYear;
        }
        String dateStr = String.valueOf(firstYear).concat("-").concat(String.valueOf(firstMonth)).concat("-01");
        Date date = null;
        try {
            date = DateTimeUtils.parseDate(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return date;
    }
}

