/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.util;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.constant.BCMConstant;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.enums.CacheTypeEnum;
import kd.epm.eb.ebBusiness.mq.MQMessagePublisherServiceHelper;

public class ModelDataClearUtils {
    private static final String[] modelTypes = new String[]{"BillFormModel", "BaseFormModel"};

    public static Set<String> getAllEntityTable() {
        QFBuilder qf = new QFBuilder("bizappid.number", "=", (Object)ApplicationTypeEnum.EB.getAppnum());
        qf.add("id", "like", (Object)"eb_%");
        qf.add("id", "not in", (Object)new String[]{"eb_currencytmpl", "eb_analysischart"});
        qf.add("modeltype", "in", (Object)modelTypes);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_entityobject", (String)"id", (QFilter[])qf.toArray());
        HashSet<String> tableEntitys = new HashSet<String>();
        for (DynamicObject dy : doc) {
            tableEntitys.add(dy.getString("id"));
        }
        return tableEntitys;
    }

    public static void clearModelData(long modelId) {
        ModelDataClearUtils.clearModels(modelId);
    }

    public static void clearModels(Object ... modelId) {
        Set<String> forms = ModelDataClearUtils.getAllEntityTable();
        try (TXHandle tx = TX.required();){
            try {
                QFilter filter = null;
                for (String entity : forms) {
                    String table = EntityMetadataCache.getDataEntityType((String)entity).getAlias();
                    if (StringUtils.isEmpty((String)table) || !DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)table)) continue;
                    DataEntityPropertyCollection dy = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
                    if (dy.get((Object)"model") != null) {
                        filter = new QFilter("model", "in", (Object)modelId);
                    } else if (dy.get((Object)"taskcatalog.model") != null) {
                        filter = new QFilter("taskcatalog.model", "in", (Object)modelId);
                    } else if (dy.get((Object)"template.model") != null) {
                        filter = new QFilter("template.model", "in", (Object)modelId);
                    } else if (dy.get((Object)"noteinfo.model") != null) {
                        filter = new QFilter("noteinfo.model", "in", (Object)modelId);
                    } else if (dy.get((Object)"modelid") != null) {
                        filter = new QFilter("modelid", "in", (Object)modelId);
                    } else if (dy.get((Object)"issueid") != null) {
                        filter = new QFilter("issueid", "in", (Object)modelId);
                    } else {
                        if (dy.get((Object)"guidemenuids.model") == null) continue;
                        filter = new QFilter("guidemenuids.model", "in", (Object)modelId);
                    }
                    DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{filter});
                }
                BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"epm_model"), (Object[])modelId);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    public static void deleteModel(long modelId) {
        Object[] objs = new Object[]{modelId};
        BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"epm_model"), (Object[])objs);
    }

    public static void reMoveCatalogCache(String catalog) {
        AppCache.get((String)"_eb.").remove(catalog);
        GlobalCacheServiceHelper.invalidateAnyCache((CacheTypeEnum)CacheTypeEnum.CommonCache);
        MQMessagePublisherServiceHelper.publishClearAllCacheByType(CacheTypeEnum.CommonCache);
    }
}

