/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.util;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.TemplateUsageEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.ebcommon.enums.TemplateTypeEnum;
import kd.epm.eb.common.enums.CacheTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.permission.cache.MembRangeItem;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.DistributionDetailsSpreadLogic;
import kd.epm.eb.ebBusiness.serviceHelper.TemplateServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.PageDimPropEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;

public class TemplateRangeService {
    public static boolean isInnerRange(String entity, TemplateModel template, Object cpId) {
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handleViewPointRange(status, entity, template, cpId);
        TemplateRangeService.handlePageDimRange(status, entity, template, cpId);
        TemplateRangeService.handlePagePropRange(status, entity, template, cpId);
        TemplateRangeService.handleInnerRowOrColRange(status, entity, template);
        return status.isInner;
    }

    public static boolean isInnerPageRange(String entity, TemplateModel template, Object cpId) {
        RangeStatus status = new RangeStatus();
        TemplateRangeService.handlePageDimRange(status, entity, template, cpId);
        TemplateRangeService.handlePagePropRange(status, entity, template, cpId);
        return status.isInner;
    }

    public static Set<String> findMembsBySpecificDim(String entity, TemplateModel template) {
        HashSet<String> membs = new HashSet<String>();
        block0: for (AreaRangeEntry areaRangeEntry : template.getAreaRangeEntries()) {
            for (RowDimensionEntry rowDimensionEntry : areaRangeEntry.getRowDimEntries()) {
                if (!rowDimensionEntry.getDimension().getMemberEntityNumber().equals(entity)) continue;
                rowDimensionEntry.getMembers().forEach(m -> membs.add(m.getNumber()));
                break;
            }
            for (ColDimensionEntry colDimensionEntry : areaRangeEntry.getColDimEntries()) {
                if (!colDimensionEntry.getDimension().getMemberEntityNumber().equals(entity)) continue;
                colDimensionEntry.getMembers().forEach(m -> membs.add(m.getNumber()));
                continue block0;
            }
        }
        for (ViewPointDimensionEntry viewPointDimensionEntry : template.getViewPointDimensionEntries()) {
            if (!viewPointDimensionEntry.getDimension().getMemberEntityNumber().equals(entity)) continue;
            membs.add(viewPointDimensionEntry.getMember().getNumber());
            return membs;
        }
        for (PageDimensionEntry pageDimensionEntry : template.getPageDimensionEntries()) {
            if (!pageDimensionEntry.getDimension().getMemberEntityNumber().equals(entity)) continue;
            pageDimensionEntry.getMembers().forEach(m -> new MembRangeItem(entity, m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, template.getModelId()).matchItems(c -> membs.add(c.number)));
        }
        for (PageDimPropEntry pageDimPropEntry : template.getPagePropEntries()) {
            if (!pageDimPropEntry.getDimension().getMemberEntityNumber().equals(entity)) continue;
            pageDimPropEntry.getAllMembProperties().forEach(p -> new MembRangeItem(entity, p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, template.getModelId()).matchItems(c -> membs.add(c.number)));
        }
        return membs;
    }

    public static void handleInnerRowOrColRange(RangeStatus status, String entity, TemplateModel template) {
        boolean isNotInPageOrViewDim;
        if (status.isInner) {
            return;
        }
        status.isInner = template.getAreaRangeEntries().stream().anyMatch(e -> {
            boolean flag = template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType() ? e.getColDimEntriesExt().stream().anyMatch(ext -> ext.getDimMembers().toList().stream().anyMatch(dimMemberPair -> ((Dimension)dimMemberPair.p1).getMemberEntityNumber().equals(entity))) : e.getColDimEntries().stream().anyMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity));
            return e.getRowDimEntries().stream().anyMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity)) || flag;
        });
        if (status.isInner) {
            return;
        }
        boolean bl = isNotInPageOrViewDim = template.getViewPointDimensionEntries().stream().noneMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity)) && template.getPageDimensionEntries().stream().noneMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity)) && template.getPagePropEntries().stream().noneMatch(p -> p.getDimension().getMemberEntityNumber().equals(entity));
        if (!status.isInner && isNotInPageOrViewDim) {
            status.isInner = true;
        }
    }

    public static void handleViewPointRange(RangeStatus status, String entity, TemplateModel template, Object cpId) {
        if (status.isInner) {
            return;
        }
        template.getViewPointDimensionEntries().forEach(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity) && cpId.equals(e.getMember().getId())) {
                status.isInner = true;
            }
        });
    }

    public static void handlePageDimRange(RangeStatus status, String entity, TemplateModel template, Object cpId) {
        if (status.isInner) {
            return;
        }
        template.getPageDimensionEntries().stream().anyMatch(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity)) {
                e.getMembers().stream().anyMatch(m -> {
                    boolean isMatched = new MembRangeItem(entity, m.getId(), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, template.getModelId()).isMatched(cpId);
                    if (isMatched) {
                        status.isInner = true;
                    }
                    return status.isInner;
                });
            }
            return status.isInner;
        });
    }

    public static void handlePagePropRange(RangeStatus status, String entity, TemplateModel template, Object cpId) {
        if (status.isInner) {
            return;
        }
        template.getPagePropEntries().stream().anyMatch(e -> {
            if (e.getDimension().getMemberEntityNumber().equals(entity)) {
                e.getAllMembProperties().stream().anyMatch(p -> {
                    boolean isMatch = new MembRangeItem(entity, p.getId(), p.getNumber(), RangeEnum.getRangeByVal((int)p.getScope()), true, template.getModelId()).isMatched(cpId);
                    if (isMatch) {
                        status.isInner = true;
                    }
                    return status.isInner;
                });
            }
            return status.isInner;
        });
    }

    public static List<TemplateModel> getDispTemplateModels(Object modelId, boolean isExcludeNoFormulaTemplate, boolean isOnlyWeaveTmpl) {
        ArrayList templates = new ArrayList();
        Set<Long> ids = TemplateRangeService.getDispenseTemplateIds(modelId);
        List<TemplateModel> ss = TemplateRangeService.getCompleteTemplateModels(ids);
        List resultList = ss.stream().filter(temp -> !temp.isSaveByDim()).collect(Collectors.toList());
        templates.addAll(resultList);
        return ss;
    }

    public static List<TemplateModel> getWholeTemplateModels(Collection<?> ids) {
        Pair<List<TemplateModel>, Collection<Object>> pairs = TemplateServiceHelper.getTemplateModelsFromCache(ids);
        List templateModels = (List)pairs.p1;
        ((Collection)pairs.p2).forEach(id -> templateModels.add(TemplateServiceHelper.getTemplateModelById(id)));
        return templateModels;
    }

    public static List<TemplateModel> getTemplateModels(Collection<?> ids, boolean isExcludeNoFormulaTemplate, boolean isOnlyWeaveTmpl) {
        ArrayList<TemplateModel> templates = new ArrayList<TemplateModel>();
        if (isExcludeNoFormulaTemplate) {
            ids = TemplateRangeService.getExistIntergrateFormulaTemplates(ids);
        }
        Pair<List<TemplateModel>, Collection<Object>> pairs = TemplateServiceHelper.getTemplateModelsFromCache(ids);
        ids = (Collection)pairs.p2;
        ((List)pairs.p1).forEach(e -> {
            if (e.isFinTemplate() && (!isOnlyWeaveTmpl || isOnlyWeaveTmpl && TemplateUsageEnum.FORWEAVE.getValue().equals(e.getUsage()))) {
                templates.add((TemplateModel)e);
            }
        });
        if (!ids.isEmpty()) {
            DynamicObjectCollection memColl;
            QFBuilder fb = new QFBuilder();
            fb.add("isfintemplate", "=", (Object)true).add("id", "in", (Object)IDUtils.toLongs((Object[])ids.toArray()));
            if (isOnlyWeaveTmpl) {
                fb.add("usage", "=", (Object)"1");
            }
            DynamicObject[] dynas = BusinessDataServiceHelper.load((String)"eb_templateentity_bg", (String)TemplateModel.getSimpleModelSeleter(), (QFilter[])fb.toArray(), (String)"createtime");
            HashMap<String, Set> idMap = new HashMap<String, Set>();
            HashMap<String, Set> idViewPointMap = new HashMap<String, Set>();
            for (DynamicObject dyna : dynas) {
                Object entry2;
                DynamicObjectCollection entries = dyna.getDynamicObjectCollection("pagemembentry");
                for (Object entry2 : entries) {
                    DynamicObject dim = entry2.getDynamicObject("pagedimension");
                    Long memId = entry2.getLong("pagemembid");
                    Set memIds = idMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet());
                    memIds.add(memId);
                }
                DynamicObjectCollection viePointEntries = dyna.getDynamicObjectCollection("viewpointmembentry");
                entry2 = viePointEntries.iterator();
                while (entry2.hasNext()) {
                    DynamicObject entry3 = (DynamicObject)entry2.next();
                    DynamicObject dim = entry3.getDynamicObject("viewdimension");
                    Long memId = entry3.getLong("viewmembid");
                    if (dim == null) continue;
                    Set memIds = idViewPointMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet());
                    memIds.add(memId);
                }
            }
            HashMap<String, DynamicObject> memMap = new HashMap<String, DynamicObject>();
            HashMap<String, DynamicObject> viewPointMap = new HashMap<String, DynamicObject>();
            String selectFields = "id,name,number";
            for (Map.Entry entry : idMap.entrySet()) {
                memColl = QueryServiceHelper.query((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                for (DynamicObject obj : memColl) {
                    memMap.put((String)entry.getKey() + "|" + obj.getLong("id"), obj);
                }
            }
            for (Map.Entry entry : idViewPointMap.entrySet()) {
                memColl = QueryServiceHelper.query((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                for (DynamicObject obj : memColl) {
                    viewPointMap.put((String)entry.getKey() + "|" + obj.getLong("id"), obj);
                }
            }
            ThreadCache.put((Object)"dim-mem", memMap);
            ThreadCache.put((Object)"dim-mem-viewpoint", viewPointMap);
            for (DynamicObject d : dynas) {
                TemplateModel t = new TemplateModel();
                t.loadDynaObj2SimpleModel(d);
                t.setUsage(d.getString("usage"));
                templates.add(t);
            }
            ThreadCache.remove((Object)"dim-mem");
            ThreadCache.remove((Object)"dim-mem-viewpoint");
        }
        return templates;
    }

    private static List<Object> getExistIntergrateFormulaTemplates(Collection<?> disps) {
        ArrayList<Object> ids = new ArrayList<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getExistIntergrateFormulaTemplates", (String)"eb_intergration_entity", (String)"template", (QFilter[])new QFBuilder().add("template", "in", disps).toArray(), null);){
            Iterator iter = ds.iterator();
            Row data = null;
            while (iter != null && iter.hasNext()) {
                data = (Row)iter.next();
                ids.add(data.get("template"));
            }
        }
        return ids;
    }

    public static Set<Long> getDispenseTemplateIds(Object modelId) {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        for (DynamicObject e : BusinessDataServiceHelper.loadFromCache((String)"eb_distributionentity", (String)"template.id", (QFilter[])new QFilter[]{new QFilter("model", "=", modelId)}).values()) {
            ids.add(e.getLong("template.id"));
        }
        return ids;
    }

    public static HashMultimap<Long, MembRangeItem> getTemplateDispenseMap(Long modelId) {
        DynamicObject[] coll;
        HashMultimap dispenses = HashMultimap.create();
        for (DynamicObject dis : coll = new DistributionDetailsSpreadLogic().queryDistributeCollectionByModelId(modelId)) {
            DynamicObject dyna = dis.getDynamicObject("entity");
            if (dyna == null) continue;
            long org = dyna.getLong("id");
            dispenses.put((Object)dis.getLong("template.id"), (Object)new MembRangeItem("epm_entitymembertree", org, dyna.getString("longnumber"), dyna.getString("number"), RangeEnum.getRangeByVal((int)dis.getInt("memrangdecombo")), false, modelId));
        }
        return dispenses;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfDispense(Long modelId) {
        if (modelId == null) {
            return new HashMap<Long, Set<Long>>();
        }
        String modelNum = QueryServiceHelper.queryOne((String)"epm_model", (String)"number", (QFilter[])new QFBuilder().add("id", "=", (Object)modelId).toArray()).getString("number");
        String cache = AppCacheServiceHelper.getTemplateDispenseCache(modelNum);
        if (StringUtils.isNotEmpty((String)cache)) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)cache);
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        HashMultimap<Long, MembRangeItem> dispenses = TemplateRangeService.getTemplateDispenseMap(modelId);
        dispenses.entries().forEach(e -> {
            if (!map.containsKey(e.getKey())) {
                map.put((Long)e.getKey(), new HashSet());
            }
            Set temp = (Set)map.get(e.getKey());
            ((MembRangeItem)e.getValue()).matchItems(c -> temp.add((Long)c.id));
        });
        AppCacheServiceHelper.cacheTemplateDispenseCache(modelNum, ObjectSerialUtil.toByteSerialized(map));
        return map;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfDispense(Long modelId, Set<Long> templateIds, Set<Long> dispenseOrgIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        String modelNum = TemplateRangeService.getModelNumber(modelId);
        Map localCache = (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("template_dis_cache_" + modelNum), () -> {
            String serial = AppCacheServiceHelper.getTemplateDispenseCacheByPart(modelNum);
            if (StringUtils.isNotEmpty((String)serial)) {
                return (Map)ObjectSerialUtil.parseObject((String)serial, (TypeReference)new TypeReference<Map<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
            }
            return TemplateRangeService.getTemplate2OrgMapOfDispense(modelId, templateIds);
        });
        templateIds.forEach(id -> {
            Set allOrgSet = (Set)localCache.get(id);
            if (allOrgSet != null) {
                map.put((Long)id, (Set<Long>)(dispenseOrgIds.isEmpty() ? new HashSet(allOrgSet) : dispenseOrgIds.stream().filter(p -> allOrgSet.contains(p)).collect(Collectors.toSet())));
            }
        });
        templateIds.removeAll(localCache.keySet());
        if (!templateIds.isEmpty()) {
            Map<Long, Set<Long>> diffMap = TemplateRangeService.getTemplate2OrgMapOfDispense(modelId, templateIds);
            templateIds.forEach(id -> {
                if (diffMap.containsKey(id)) {
                    Set allOrgSet = (Set)diffMap.get(id);
                    map.put((Long)id, (Set<Long>)(dispenseOrgIds.isEmpty() ? new HashSet(allOrgSet) : dispenseOrgIds.stream().filter(p -> allOrgSet.contains(p)).collect(Collectors.toSet())));
                }
            });
            templateIds.forEach(e -> localCache.compute(e, (k, v) -> diffMap.containsKey(e) ? (Set)diffMap.get(e) : new HashSet(0)));
            AppCacheServiceHelper.cacheTemplateDispenseCacheByPart(modelNum, ObjectSerialUtil.toJson((Object)localCache));
            GlobalCacheServiceHelper.replaceCache((CacheTypeEnum)CacheTypeEnum.CommonCache, (String)("template_dis_cache_" + modelNum), (Object)localCache);
        }
        return map;
    }

    private static String getModelNumber(Long modelId) {
        return MemberReader.findModelNumberById((Object)modelId);
    }

    public static HashMultimap<Long, MembRangeItem> getTemplateDispenseMap(Long modelId, Set<Long> templateIds) {
        DynamicObject[] coll;
        HashMultimap dispenses = HashMultimap.create();
        for (DynamicObject dis : coll = new DistributionDetailsSpreadLogic().queryDistributeCollectionByTemplate(templateIds, modelId.toString())) {
            DynamicObject dyna = dis.getDynamicObject("entity");
            if (dyna == null) continue;
            long org = dyna.getLong("id");
            dispenses.put((Object)dis.getLong("template.id"), (Object)new MembRangeItem("epm_entitymembertree", org, dyna.getString("longnumber"), dyna.getString("number"), RangeEnum.getRangeByVal((int)dis.getInt("memrangdecombo")), false, modelId));
        }
        return dispenses;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfDispense(Long modelId, Set<Long> templateIds) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        HashMultimap<Long, MembRangeItem> dispenses = TemplateRangeService.getTemplateDispenseMap(modelId, templateIds);
        dispenses.entries().forEach(e -> {
            if (!map.containsKey(e.getKey())) {
                map.put((Long)e.getKey(), new HashSet());
            }
            Set temp = (Set)map.get(e.getKey());
            temp.addAll((Collection)ThreadCache.get((Object)((MembRangeItem)e.getValue()).genKey(null), () -> {
                HashSet ids = new HashSet();
                ((MembRangeItem)e.getValue()).matchItems(c -> ids.add((Long)c.id));
                return MemberReader.change2BaseMember((long)modelId, (String)"epm_entitymembertree", ids);
            }));
        });
        return map;
    }

    public static Set<Long> getAllTemplateIdByModel(Object modelId) {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        for (DynamicObject e : BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", modelId).and("isfintemplate", "=", (Object)1)}).values()) {
            ids.add(e.getLong("id"));
        }
        return ids;
    }

    public static List<TemplateModel> getCompleteTemplateModels(Collection<?> ids) {
        DynamicObjectCollection memColl;
        ArrayList<TemplateModel> templates = new ArrayList<TemplateModel>(10);
        DynamicObject[] dynas = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_templateentity_bg"));
        HashMap<String, Set> idMap = new HashMap<String, Set>(10);
        HashMap<String, Set> idViewPointMap = new HashMap<String, Set>(10);
        for (DynamicObject dyna : dynas) {
            Object entry2;
            DynamicObjectCollection entries = dyna.getDynamicObjectCollection("pagemembentry");
            for (Object entry2 : entries) {
                DynamicObject dim = entry2.getDynamicObject("pagedimension");
                Long memId = entry2.getLong("pagemembid");
                Set memIds = idMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet());
                memIds.add(memId);
            }
            DynamicObjectCollection viePointEntries = dyna.getDynamicObjectCollection("viewpointmembentry");
            entry2 = viePointEntries.iterator();
            while (entry2.hasNext()) {
                DynamicObject entry3 = (DynamicObject)entry2.next();
                DynamicObject dim = entry3.getDynamicObject("viewdimension");
                Long memId = entry3.getLong("viewmembid");
                Set memIds = idViewPointMap.computeIfAbsent(dim.getString("membermodel"), key -> new HashSet());
                memIds.add(memId);
            }
        }
        HashMap<String, DynamicObject> memMap = new HashMap<String, DynamicObject>(10);
        HashMap<String, DynamicObject> viewPointMap = new HashMap<String, DynamicObject>(10);
        String selectFields = "id,name,number";
        for (Map.Entry entry : idMap.entrySet()) {
            memColl = QueryServiceHelper.query((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            for (DynamicObject obj : memColl) {
                memMap.put((String)entry.getKey() + "|" + obj.getLong("id"), obj);
            }
        }
        for (Map.Entry entry : idViewPointMap.entrySet()) {
            memColl = QueryServiceHelper.query((String)((String)entry.getKey()), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            for (DynamicObject obj : memColl) {
                viewPointMap.put((String)entry.getKey() + "|" + obj.getLong("id"), obj);
            }
        }
        ThreadCache.put((Object)"dim-mem", memMap);
        ThreadCache.put((Object)"dim-mem-viewpoint", viewPointMap);
        for (DynamicObject d : dynas) {
            TemplateModel t = new TemplateModel();
            t.loadDynaObj2Model(d);
            t.setUsage(d.getString("usage"));
            templates.add(t);
        }
        ThreadCache.remove((Object)"dim-mem");
        ThreadCache.remove((Object)"dim-mem-viewpoint");
        return templates;
    }

    public static class RangeStatus {
        private boolean isInner = false;

        public boolean isInner() {
            return this.isInner;
        }
    }
}

