/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebBusiness.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.util.EntityVersioningUtil;

public class TemplateUtils {
    public static List<Long> getTemplateIds(Long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"eb_templateentity_bg", (String)"group");
        if (template == null) {
            return new ArrayList<Long>();
        }
        Set templateIds = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)"id", (QFilter[])new QFBuilder("group", "=", (Object)template.getLong("group")).toArray()).keySet();
        ArrayList<Long> result = new ArrayList<Long>();
        templateIds.forEach(t -> result.add(Long.valueOf(t.toString())));
        return result;
    }

    public static Collection<Long> getAllVersionTemplateIds(Collection<Long> templateIds) {
        HashSet result = Sets.newHashSet();
        try (DataSet dateSet = QueryServiceHelper.queryDataSet((String)"kd.epm.eb.ebBusiness.util.TemplateUtils.getTemplateIds(Collection<Long>).one", (String)"eb_templateentity_bg", (String)"group", (QFilter[])new QFilter("id", "in", templateIds).toArray(), null);){
            TemplateUtils.propertyValue2Collection(dateSet, result, "group");
            try (DataSet allDataSet = QueryServiceHelper.queryDataSet((String)"kd.epm.eb.ebBusiness.util.TemplateUtils.getTemplateIds(Collection<Long>).two", (String)"eb_templateentity_bg", (String)"id", (QFilter[])new QFilter("group", "in", (Object)result).toArray(), null);){
                result.clear();
                TemplateUtils.propertyValue2Collection(allDataSet, result, "id");
            }
        }
        return result;
    }

    private static void propertyValue2Collection(DataSet dateSet, Set<Long> groupIds, String property) {
        dateSet.forEach(row -> groupIds.add(row.getLong(property)));
    }

    public static Map<Long, Long> getRightTplIdByVersioned(Long modelId, Long yearId, Long periodId, Set<Long> templateIds) {
        HashMap<Long, Long> source2Right = new HashMap<Long, Long>();
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        String yearNum = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"epm_yearmembertree", (String)"number").getString("number");
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return source2Right;
        }
        HashMap group2SourceId = new HashMap();
        BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)"group", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach((id, t) -> group2SourceId.put(t.getLong("group"), (Long)id));
        Map<Long, List<DynamicObject>> templateGroups = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)"id, group, effectivedate, expiringdate,versionnumber", (QFilter[])new QFBuilder("group", "in", group2SourceId.keySet()).add("status", "=", (Object)"1").toArray(), (String)"group, versionnumber").values().stream().collect(Collectors.groupingBy(e -> e.getLong("group")));
        templateGroups.forEach((group, tpls) -> {
            for (DynamicObject t : tpls) {
                Long id = t.getLong("id");
                Date effectivedate = t.getDate("effectivedate");
                if (effectivedate == null) {
                    source2Right.put(id, id);
                    continue;
                }
                Date expiringdate = t.getDate("expiringdate");
                if (effectivedate.getTime() <= firstDate.getTime() && (expiringdate == null || expiringdate.getTime() >= firstDate.getTime())) {
                    source2Right.put((Long)group2SourceId.get(group), t.getLong("id"));
                    continue;
                }
                if (effectivedate.getTime() < firstDate.getTime() || effectivedate.getTime() > lastDate.getTime()) continue;
                source2Right.put((Long)group2SourceId.get(group), t.getLong("id"));
            }
        });
        return source2Right;
    }
}

