/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.common.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import kd.bos.dataentity.utils.StringUtils;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String RETURN = "\r\n";

    public static final boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean equals(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equals(str2);
    }

    public static final boolean equalsIgnoreCase(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equalsIgnoreCase(str2);
    }

    public static String replaceFirst(String source, String subStr, String replacement) {
        int sublen = subStr.length();
        int srclen = source.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        int index = source.indexOf(subStr);
        if (index == -1) {
            return source;
        }
        return source.substring(0, index) + replacement + source.substring(index + sublen, srclen);
    }

    public static String replace(String source, String subStr, String replacement, boolean matchFull, boolean matchCase) {
        if (matchFull || StringUtil.isEmptyString(subStr)) {
            return replacement;
        }
        if (StringUtil.isEmptyString(source)) {
            return replacement;
        }
        String formulaForCompare = source;
        String valueForFind = subStr;
        if (!matchCase) {
            formulaForCompare = formulaForCompare.toLowerCase();
            valueForFind = valueForFind.toLowerCase();
        }
        int vLen = valueForFind.length();
        int index = formulaForCompare.lastIndexOf(valueForFind);
        if (index < 0) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source);
        while (index != -1) {
            sb.replace(index, index + vLen, replacement);
            index = formulaForCompare.lastIndexOf(valueForFind, index - 1);
        }
        return sb.toString();
    }

    public static String replace(String source, String subStr, String replacement) {
        return StringUtil.replace(source, subStr, replacement, false, true);
    }

    public static boolean indexOf(String filter, char source) {
        boolean b = false;
        if (filter != null && filter.indexOf(source) != -1) {
            b = true;
        }
        return b;
    }

    public static final String getClassName(Class<?> cls, boolean full) {
        String fullName = cls.getName();
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static final String getClassName(Object obj, boolean full) {
        return StringUtil.getClassName(obj.getClass(), full);
    }

    public static final String getDisplayName(String name, String alias) {
        if (alias == null || alias.length() == 0) {
            return name;
        }
        return alias + "(" + name + ")";
    }

    public static String[] splitString(String str, String sep) {
        int index;
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(10);
        int lastIndex = 0;
        int sepLen = sep.length();
        while ((index = str.indexOf(sep, lastIndex)) != -1) {
            list.add(str.substring(lastIndex, index));
            lastIndex = index + sepLen;
        }
        if (lastIndex != str.length()) {
            list.add(str.substring(lastIndex));
        } else {
            list.add(EMPTY_STRING);
        }
        String[] strArray = new String[list.size()];
        return list.toArray(strArray);
    }

    public static byte[] getBytes(String s) throws UnsupportedEncodingException {
        return s.getBytes("UTF-8");
    }

    public static boolean checkNumber(String str) {
        int dotCount = 0;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char c = str.charAt(i);
            if (i == 0 && c == '-') {
                return true;
            }
            if (!(c == '.' ? ++dotCount >= 2 : !Character.isDigit(c))) continue;
            return false;
        }
        return true;
    }
}

