/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.common.variant;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.ebSpread.common.variant.ExprErr;
import kd.epm.eb.ebSpread.common.variant.SyntaxErrorException;
import kd.epm.eb.ebSpread.common.variant.VarBase;
import kd.epm.eb.ebSpread.common.variant.Variant;

class VarBigDecimal
extends VarBase {
    VarBigDecimal() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 11: {
                    Variant vleft = new Variant();
                    Variant vright = new Variant();
                    if (left.isNumeric(vleft) && right.isNumeric(vright)) {
                        result.setVariant(vleft.add(vright));
                        break;
                    }
                    result.setObject(left.toString().concat((String)right.getValue()), 11);
                    break;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                    break;
                }
                default: {
                    result.setObject(((BigDecimal)left.getValue()).add(right.toBigDecimal()), 10);
                }
            }
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                    return;
                }
            }
            result.setObject(((BigDecimal)left.getValue()).subtract(right.toBigDecimal()), 10);
            return;
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                    return;
                }
            }
            result.setObject(((BigDecimal)left.getValue()).multiply(right.toBigDecimal()), 10);
            return;
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                    return;
                }
            }
            BigDecimal r = right.toBigDecimal();
            if (r.signum() == 0) {
                ExprErr.goError(2L, null);
            }
            BigDecimal dividend = (BigDecimal)left.getValue();
            BigDecimal divisor = right.toBigDecimal();
            result.setObject(dividend.divide(divisor, 16, 4), 10);
            return;
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double db = left.doubleValue() % right.doubleValue();
        result.setObject(BigDecimal.valueOf(db), 10);
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
    }
}

