/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.common.variant;

import java.math.BigDecimal;
import java.util.Calendar;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.ebSpread.common.variant.ExprErr;
import kd.epm.eb.ebSpread.common.variant.SyntaxErrorException;
import kd.epm.eb.ebSpread.common.variant.VarBase;
import kd.epm.eb.ebSpread.common.variant.Variant;

class VarCalendar
extends VarBase {
    VarCalendar() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        BigDecimal bd = Variant.calendarToDecimal(cal).add(right.toBigDecimal());
        result.setObject(Variant.decimalToCalender(bd), 13);
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        BigDecimal bd = Variant.calendarToDecimal(cal).subtract(right.toBigDecimal());
        result.setObject(bd, 10);
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        BigDecimal days = left.toBigDecimal().multiply(right.toBigDecimal());
        days = days.setScale(7, 4);
        if (right.isNumber()) {
            result.setObject(Variant.decimalToCalender(days), 13);
        } else {
            result.setObject(days, 10);
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        BigDecimal bdRight = right.toBigDecimal();
        if (bdRight.doubleValue() == 0.0) {
            ExprErr.goError(2L, null);
        }
        BigDecimal days = left.toBigDecimal().divide(bdRight, 7, 4);
        result.setObject(days, 10);
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double dfRight = right.doubleValue();
        if (BigDecimal.valueOf(dfRight).compareTo(BigDecimal.ZERO) == 0) {
            ExprErr.goError(2L, null);
        } else {
            BigDecimal bd = BigDecimal.valueOf(left.doubleValue() % dfRight);
            if (right.isNumber()) {
                result.setObject(Variant.decimalToCalender(bd), 13);
            } else {
                result.setObject(bd, 10);
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97\u3002", (String)"Variant_2", (String)"epm-eb-spread", (Object[])new Object[0]));
    }
}

