/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.enums.DataTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.ebBusiness.sql.util.TypeConversionUtils;
import kd.epm.eb.ebSpread.common.variant.Variant;
import kd.epm.eb.ebSpread.domain.Domain;
import kd.epm.eb.ebSpread.domain.view.CellDeserializer;
import kd.epm.eb.ebSpread.domain.view.CellSerializer;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.model.CellData;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.SpanInfo;
import kd.epm.eb.ebSpread.model.UserObject;

@JsonSerialize(using=CellSerializer.class)
@JsonDeserialize(using=CellDeserializer.class)
public class Cell
extends Domain {
    private static final long serialVersionUID = 1L;
    private CellData cellData;
    private String formula;
    private SpanInfo spanInfo;
    private UserObject userObject = new UserObject(0);
    private boolean isChangeVal = false;
    protected boolean isMdDataDomain = false;
    @JsonIgnore
    private transient int row = -1;
    @JsonIgnore
    private transient int col = -1;
    @JsonIgnore
    private transient DataTypeEnum cellDataType;
    @JsonIgnore
    private transient PositionInfo positionInfo;
    @JsonIgnore
    private transient BasePointInfo basePointInfo;
    @JsonIgnore
    private transient BasePointInnerLineInfo[] innerInfoFromFolatSetting;
    @JsonIgnore
    private transient boolean isOnRowOrColSetting = true;
    @JsonIgnore
    private transient Object newValue;
    @JsonIgnore
    private transient int _cachedHashCode = -1;
    @JsonIgnore
    private transient Map<String, String> _cacheMemberFromUserObjectDimNumbers;

    public Cell() {
        this.cellData = new CellData();
    }

    protected CellData getCellData() {
        return this.cellData;
    }

    public void setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    @Deprecated
    public void setRow(int row) {
        this.row = row;
    }

    @Deprecated
    public void setCol(int col) {
        this.col = col;
    }

    public int hashCode() {
        if (this.row > Short.MAX_VALUE && this.col > Short.MAX_VALUE) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u5143\u683c\u7684\u884c\uff0c\u5217\u7ec4\u5408\u6570\u91cf\u8d85\u8fc7\u4e86\uff1a%1", (String)"Cell_0", (String)"epm-eb-spread", (Object[])new Object[]{Integer.MAX_VALUE}));
        }
        this._cachedHashCode = this.row << 16 ^ this.col;
        return this._cachedHashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof Cell && ((Cell)obj).row == this.row && ((Cell)obj).col == this.col;
    }

    public boolean setValue(Object val) {
        boolean oldValIsNull;
        Variant temp = this.convert2Variant(val);
        Variant oldCellData = this.cellData.getData();
        boolean bl = oldValIsNull = oldCellData == null || oldCellData.isNull() || oldCellData.isEmpty();
        if (oldValIsNull && val != null && StringUtils.isNotEmpty((String)val.toString()) || !oldValIsNull && val == null || !oldValIsNull && (this.cellData.getData().getVt() != temp.getVt() || temp.compareTo(oldCellData) != 0)) {
            this.isChangeVal = true;
            this.cellData.setData(temp);
        }
        return this.isChangeVal;
    }

    public Map<String, String> getMemberFromUserObjectDimNumbers() {
        if (this._cacheMemberFromUserObjectDimNumbers == null) {
            this._cacheMemberFromUserObjectDimNumbers = new HashMap<String, String>();
            if (this.userObject.getMemberFromUserObject() != null) {
                for (IDimMember member : this.userObject.getMemberFromUserObject()) {
                    if (member.getDimension() == null) continue;
                    this._cacheMemberFromUserObjectDimNumbers.put(member.getDimension().getNumber(), member.getNumber());
                }
            }
        }
        return this._cacheMemberFromUserObjectDimNumbers;
    }

    private Variant convert2Variant(Object val) {
        if (val instanceof BigDecimal) {
            return new Variant((BigDecimal)val);
        }
        if (val instanceof Long) {
            return new Variant(new BigDecimal((Long)val));
        }
        if (val instanceof Number) {
            return new Variant(new BigDecimal(val.toString()));
        }
        if (val instanceof Variant && Variant.encryptVariant.equals(val)) {
            return (Variant)val;
        }
        return new Variant(val);
    }

    public Object getValue() {
        return this.cellData.getData().getValue();
    }

    public Variant getVariant() {
        return this.cellData.getData();
    }

    public boolean isChangeVal() {
        return this.isChangeVal;
    }

    public void setChangeVal(boolean isChange) {
        this.isChangeVal = isChange;
    }

    public void setCellData(CellData cellData) {
        this.cellData = cellData;
    }

    public Object getUserObject(String key) {
        return this.userObject.getUserObject(key);
    }

    public UserObject getUserObject() {
        return this.userObject;
    }

    public void setUserObject(String key, Object val) {
        this.userObject.setUserObject(key, val);
    }

    public void removeUserObject(String key) {
        this.userObject.remove(key);
    }

    public void clearAllUserObject() {
        this.userObject.clearAllUserObject();
    }

    public <T> T getUserObject(String key, T defaultValue) {
        Object v = this.getUserObject(key);
        return (T)(v == null ? defaultValue : v);
    }

    public void addDim2UserObject(IDimMember member) {
        this.userObject.addDim2UserObject(member);
    }

    public void addDims2UserObject(List<IDimMember> members) {
        for (IDimMember m : members) {
            this.addDim2UserObject(m);
        }
    }

    public List<IDimMember> getMemberFromUserObject() {
        return this.userObject.getMemberFromUserObject();
    }

    public void copyDimMember2UserObject(Cell other) {
        this.userObject.copyDimMember2UserObject(other);
    }

    public SpanInfo getSpanInfo() {
        return this.spanInfo;
    }

    public void setSpanInfo(SpanInfo spanInfo) {
        this.spanInfo = spanInfo;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean hasFormula() {
        return StringUtils.isNotEmpty((String)this.formula);
    }

    public boolean isMdDataDomain() {
        return this.isMdDataDomain;
    }

    public void setMdDataDomain(boolean isMdDataDomain) {
        this.isMdDataDomain = isMdDataDomain;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getExcelAxis() {
        return ExcelUtils.xy2Pos((int)this.col, (int)this.row);
    }

    public String displayDimMsg() {
        return Cell.formatDimMsg(this.getMemberFromUserObject());
    }

    public static String formatDimMsg(List<IDimMember> members) {
        StringBuilder sb = new StringBuilder();
        if (members != null && !members.isEmpty()) {
            sb.append('[');
            for (IDimMember mem : members) {
                sb.append(mem.getDimension().getName()).append('!').append(mem.getName()).append('|').append(mem.getNumber()).append(';');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(']');
        }
        return sb.toString();
    }

    public String displayDimMsg(int pattern) {
        List<IDimMember> members = this.getMemberFromUserObject();
        StringBuilder sb = new StringBuilder();
        if (members != null && !members.isEmpty()) {
            if (members.size() == 1) {
                IDimMember member = members.get(0);
                switch (pattern) {
                    case 1: {
                        sb.append(member.getName());
                        break;
                    }
                    case 2: {
                        sb.append(member.getNumber()).append('|').append(member.getName());
                        break;
                    }
                    case 3: {
                        sb.append(member.getNumber());
                        break;
                    }
                    default: {
                        sb.append(member.getDimension().getName()).append('!').append(member.getName()).append('|').append(member.getNumber());
                        break;
                    }
                }
            } else {
                switch (pattern) {
                    case 1: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getName()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    case 2: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getNumber()).append('|').append(mem.getName()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    case 3: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getNumber()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    default: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getName()).append('|').append(mem.getNumber()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
            }
            this.setUserObject("floatmember", Boolean.TRUE);
        }
        return sb.toString();
    }

    public void clearMembersOfUserObject() {
        if (this.userObject.containsKey("KEY_DIM_FLAG")) {
            this.getMemberFromUserObject().clear();
        }
        this._cacheMemberFromUserObjectDimNumbers = null;
    }

    public String[] toSaveFormat() {
        ArrayList<String> arrs = new ArrayList<String>();
        if (this.getMemberFromUserObject() != null) {
            for (IDimMember m : this.getMemberFromUserObject()) {
                arrs.add(m.getNumber());
            }
        }
        return arrs.toArray(new String[0]);
    }

    public String valueToString() {
        Variant val = this.cellData.getData();
        if (val == null) {
            return "";
        }
        if (val.isNumber()) {
            return val.toString();
        }
        if (val.isDate()) {
            return TypeConversionUtils.objToDate(val).toString();
        }
        return val.toString();
    }

    public String toJSon() {
        return this.cellData.toJSon();
    }

    @JsonIgnore
    public void overrideCellDataWithNewData() {
        this.setValue(this.newValue);
    }

    @JsonIgnore
    public Object getNewValue() {
        return this.newValue;
    }

    @JsonIgnore
    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @JsonIgnore
    public DataTypeEnum getCellDataType() {
        return this.cellDataType;
    }

    @JsonIgnore
    public void setCellDataType(DataTypeEnum cellDataType) {
        this.cellDataType = cellDataType;
    }

    @JsonIgnore
    public PositionInfo getPositionInfo() {
        return this.positionInfo;
    }

    @JsonIgnore
    public void setPositionInfo(PositionInfo positionInfo) {
        this.positionInfo = positionInfo;
    }

    @JsonIgnore
    public BasePointInnerLineInfo[] getInnerInfoFromFolatSetting() {
        return this.innerInfoFromFolatSetting;
    }

    @JsonIgnore
    public void setInnerInfoFromFolatSetting(BasePointInnerLineInfo[] innerInfoFromFolatSetting) {
        this.innerInfoFromFolatSetting = innerInfoFromFolatSetting;
        this.isOnRowOrColSetting = innerInfoFromFolatSetting != null && innerInfoFromFolatSetting.length != 0;
    }

    @JsonIgnore
    public boolean isOnRowOrColSetting() {
        return this.isOnRowOrColSetting;
    }

    @JsonIgnore
    public BasePointInfo getBasePointInfo() {
        return this.basePointInfo;
    }

    @JsonIgnore
    public void setBasePointInfo(BasePointInfo basePointInfo) {
        this.basePointInfo = basePointInfo;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("value", (Object)this.cellData.getData()).add("formula", (Object)this.formula).add("isChangeVal", this.isChangeVal).add("isMDData", this.isMdDataDomain).add("userObject", (Object)this.userObject).toString();
    }
}

