/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.epm.eb.ebSpread.common.variant.Variant;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.model.CellData;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.Dimension;
import kd.epm.eb.ebSpread.model.IDimMember;

public class CellDeserializer
extends JsonDeserializer<Cell> {
    public Cell deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        IntNode isChangeVal;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Cell cell = new Cell();
        this.deserializeCellData(node, cell, ctx);
        TextNode formula = (TextNode)node.get("f");
        if (formula != null) {
            cell.setFormula(formula.textValue());
        }
        cell.setChangeVal((isChangeVal = (IntNode)node.get("c")) != null && isChangeVal.intValue() == 1);
        IntNode isMdDataDomain = (IntNode)node.get("m");
        cell.setMdDataDomain(isMdDataDomain == null || isMdDataDomain.intValue() != 1);
        Map mems = (Map)ThreadCache.get((Object)"dim_member_map");
        this.deserializeUserObject(node, cell, mems);
        this.deserializeDimMember(node, cell, mems);
        return cell;
    }

    private void deserializeDimMember(JsonNode node, Cell cell, Map<Long, IDimMember> mems) {
        ArrayNode dms = (ArrayNode)node.get("d");
        if (dms == null) {
            return;
        }
        Iterator dmIt = dms.elements();
        while (dmIt.hasNext()) {
            JsonNode dm = (JsonNode)dmIt.next();
            if (dm.isInt()) {
                long dmId = dm.longValue();
                cell.addDim2UserObject(mems.get(dmId));
                continue;
            }
            if (!dm.isObject()) continue;
            String dimNum = dm.get("di").asText();
            Map dimMap = (Map)ThreadCache.get((Object)"dimension_data");
            Dimension dim = dimMap.computeIfAbsent(dimNum, key -> {
                String dimNam = null;
                if (dm.get("din") != null) {
                    dimNam = dm.get("din").asText();
                }
                return new Dimension(dimNam, (String)key, null);
            });
            String dmNum = dm.get("dm").asText();
            String dmNam = null;
            if (dm.get("dmn") != null) {
                dmNam = dm.get("dmn").asText();
            }
            DimMember mem = new DimMember(dmNam, dmNum, null, dim);
            dim.addMember(mem);
            cell.addDim2UserObject(mem);
        }
    }

    private void deserializeUserObject(JsonNode node, Cell cell, Map<Long, IDimMember> mems) {
        JsonNode userObject = node.get("o");
        if (userObject == null) {
            return;
        }
        Iterator objIt = userObject.fields();
        while (objIt.hasNext()) {
            Map.Entry entry = (Map.Entry)objIt.next();
            if (((String)entry.getKey()).equals("seqobject")) {
                long dmId = ((JsonNode)entry.getValue()).longValue();
                cell.setUserObject((String)entry.getKey(), mems.get(dmId));
                continue;
            }
            if (((JsonNode)entry.getValue()).isInt()) {
                cell.setUserObject((String)entry.getKey(), ((JsonNode)entry.getValue()).asInt());
                continue;
            }
            if (((JsonNode)entry.getValue()).isBoolean()) {
                cell.setUserObject((String)entry.getKey(), ((JsonNode)entry.getValue()).asBoolean());
                continue;
            }
            if (((JsonNode)entry.getValue()).isLong()) {
                cell.setUserObject((String)entry.getKey(), ((JsonNode)entry.getValue()).asLong());
                continue;
            }
            cell.setUserObject((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
        }
    }

    private void deserializeCellData(JsonNode node, Cell cell, DeserializationContext ctx) {
        ArrayNode val = (ArrayNode)node.get("v");
        if (val == null) {
            return;
        }
        CellData cellData = null;
        Iterator vals = val.elements();
        if (vals.hasNext()) {
            cellData = new CellData();
            Variant v = null;
            int vt = ((JsonNode)vals.next()).intValue();
            JsonNode valNode = (JsonNode)vals.next();
            switch (vt) {
                case 12: {
                    v = new Variant(new Date(valNode.longValue()), vt);
                    break;
                }
                case 10: {
                    v = new Variant(new BigDecimal(valNode.textValue()), vt);
                    break;
                }
                case 9: {
                    v = new Variant(valNode.longValue(), vt);
                    break;
                }
                case 8: {
                    v = new Variant(valNode.booleanValue(), vt);
                    break;
                }
                case 13: {
                    v = new Variant(ctx.constructCalendar(new Date(((LongNode)valNode).longValue())), vt);
                    break;
                }
                case 7: {
                    v = new Variant(valNode.textValue(), vt);
                    break;
                }
                case 3: {
                    v = new Variant(((IntNode)valNode).intValue(), vt);
                    break;
                }
                default: {
                    v = new Variant(valNode.textValue(), vt);
                }
            }
            cellData.setData(v);
            cell.setCellData(cellData);
        }
    }
}

