/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;

public class CellSerializer
extends JsonSerializer<Cell> {
    protected static final String CELLDATA = "v";
    protected static final String FORMULA = "f";
    protected static final String ISCHANGEVAL = "c";
    protected static final String ISMDDATADOMAIN = "m";
    protected static final String DIMMEMBERS = "d";
    protected static final String DIMENSION_NUMBER = "di";
    protected static final String DIMENSION_NAME = "din";
    protected static final String DIMMEMBSER_NUMBER = "dm";
    protected static final String DIMMEMBSER_NAME = "dmn";
    protected static final String USEROBJECT = "o";

    public void serialize(Cell cell, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.serializeCellData(cell, jgen, provider);
        if (cell.getFormula() != null) {
            jgen.writeStringField(FORMULA, cell.getFormula());
        }
        if (cell.isChangeVal()) {
            jgen.writeNumberField(ISCHANGEVAL, 1);
        }
        if (!cell.isMdDataDomain()) {
            jgen.writeNumberField(ISMDDATADOMAIN, 1);
        }
        this.serializeDimMember(cell, jgen);
        this.serializeUserObject(cell, jgen, provider);
        jgen.writeEndObject();
    }

    private void serializeCellData(Cell cell, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (cell.getValue() != null) {
            jgen.writeArrayFieldStart(CELLDATA);
            jgen.writeNumber(cell.getVariant().getVt());
            this.defaultSerialize(cell.getVariant().getVt(), cell.getValue(), provider, jgen);
            jgen.writeEndArray();
        }
    }

    private void serializeDimMember(Cell cell, JsonGenerator jgen) throws IOException {
        List<IDimMember> dmList = cell.getMemberFromUserObject();
        if (dmList == null || dmList.isEmpty()) {
            return;
        }
        jgen.writeArrayFieldStart(DIMMEMBERS);
        for (IDimMember dm : dmList) {
            if (dm == null) continue;
            if (((DimMember)dm).getId() == 0L) {
                jgen.writeStartObject();
                jgen.writeStringField(DIMENSION_NUMBER, dm.getDimension().getNumber());
                if (dm.getDimension().getName() != null) {
                    jgen.writeStringField(DIMENSION_NAME, dm.getDimension().getName());
                }
                jgen.writeStringField(DIMMEMBSER_NUMBER, dm.getNumber());
                if (dm.getName() != null) {
                    jgen.writeStringField(DIMMEMBSER_NAME, dm.getName());
                }
                jgen.writeEndObject();
                continue;
            }
            jgen.writeNumber(((DimMember)dm).getId());
        }
        jgen.writeEndArray();
    }

    private void serializeUserObject(Cell cell, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (!cell.getUserObject().isEmpty()) {
            HashSet keys = new HashSet(cell.getUserObject().keySet());
            keys.remove("KEY_DIM_FLAG");
            if (!keys.isEmpty()) {
                jgen.writeObjectFieldStart(USEROBJECT);
                for (String key : keys) {
                    Object obj = cell.getUserObject().get(key);
                    if (obj == null) continue;
                    if (obj instanceof DimMember) {
                        jgen.writeNumberField(key, ((DimMember)obj).getId());
                        continue;
                    }
                    provider.defaultSerializeField(key, cell.getUserObject().get(key), jgen);
                }
                jgen.writeEndObject();
            }
        }
    }

    private void defaultSerialize(int vt, Object val, SerializerProvider provider, JsonGenerator jgen) throws IOException {
        switch (vt) {
            case 10: {
                jgen.writeString(val.toString());
                break;
            }
            default: {
                provider.defaultSerializeValue((Object)val.toString(), jgen);
            }
        }
    }
}

