/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import java.io.IOException;
import java.util.Iterator;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.Dimension;

public class DimensionDeserializer
extends JsonDeserializer<Dimension> {
    public Dimension deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String name = null;
        if (node.get("na") != null) {
            name = node.get("na").textValue();
        }
        String uqCode = null;
        if (node.get("uc") != null) {
            uqCode = node.get("uc").textValue();
        }
        String number = node.get("nu").textValue();
        Dimension dim = new Dimension(name, number, uqCode);
        JsonNode mn = node.get("m");
        if (mn != null) {
            Iterator mIt = mn.elements();
            while (mIt.hasNext()) {
                this.readDimMember(mn, dim);
            }
        }
        return dim;
    }

    private void readDimMember(JsonNode mem, Dimension dim) {
        String number = mem.get("nu").textValue();
        String name = null;
        JsonNode nameNode = mem.get("na");
        if (nameNode != null) {
            name = nameNode.textValue();
        }
        String simpleName = null;
        JsonNode simpleNameNode = mem.get("sn");
        if (simpleNameNode != null) {
            simpleName = simpleNameNode.textValue();
        }
        DimMember dm = new DimMember(name, number, simpleName, dim);
        Long id = ((LongNode)mem.get("id")).longValue();
        dm.setId(id);
        dim.addMember(dm);
    }
}

