/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.Dimension;
import kd.epm.eb.ebSpread.model.IDimMember;

public class DimensionSerializer
extends JsonSerializer<Dimension> {
    protected static final String ID = "id";
    protected static final String NUMBER = "nu";
    protected static final String NAME = "na";
    protected static final String SIMPLE_NAME = "sn";
    protected static final String UQCODE = "uc";
    protected static final String DIMMEMBERS = "m";

    public void serialize(Dimension dim, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        List<IDimMember> members;
        jgen.writeStartObject();
        jgen.writeStringField(NUMBER, dim.getNumber());
        if (dim.getName() != null) {
            jgen.writeStringField(NAME, dim.getName());
        }
        if (dim.getUqCode() != null) {
            jgen.writeStringField(UQCODE, dim.getUqCode());
        }
        if (!(members = dim.getMembers()).isEmpty()) {
            jgen.writeArrayFieldStart(DIMMEMBERS);
            for (IDimMember dm : members) {
                this.writeDimMember((DimMember)dm, jgen);
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }

    private void writeDimMember(DimMember dm, JsonGenerator jgen) throws IOException {
        jgen.writeStartObject();
        jgen.writeNumberField(ID, dm.getId());
        jgen.writeStringField(NUMBER, dm.getNumber());
        if (dm.getName() != null) {
            jgen.writeStringField(NAME, dm.getName());
        }
        if (dm.getSimpleName() != null) {
            jgen.writeStringField(SIMPLE_NAME, dm.getSimpleName());
        }
        jgen.writeEndObject();
    }
}

