/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;

public class JsonSerializerUtil {
    private static final Log log = LogFactory.getLog((String)"JsonSerializerUtil");
    public static final String DIM_MEMBER = "dim_member_map";
    public static final String DIMENSION = "dimension_data";
    public static final String SHEETS = "sheets";
    public static final String DATA = "data";
    public static final String DATA_TABLE = "dataTable";
    public static final String STYLE = "style";
    public static final String VALUE = "value";
    public static final String CELL_TYPE = "cellType";
    public static final String S = "s";
    public static final String V = "v";
    public static final String ACTIVE_ROW = "activeRow";
    public static final String ACTIVE_COL = "activeCol";
    public static final String SELECTIONS = "selections";

    private JsonSerializerUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static SpreadManager toSpreadManager(String spreadSerial) {
        SpreadManager sm = null;
        ObjectMapper om = new ObjectMapper();
        try {
            if (spreadSerial != null && spreadSerial.startsWith("#gzip#")) {
                spreadSerial = ObjectSerialUtil.uncompress4GZip((String)spreadSerial);
            }
            sm = (SpreadManager)om.readValue(spreadSerial, SpreadManager.class);
        }
        catch (Exception e) {
            sm = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)spreadSerial);
        }
        return sm;
    }

    public static String toJson(SpreadManager sm) {
        if (sm.getAreaManager().getPostionInfoSet().size() == 0) {
            return ObjectSerialUtil.toByteSerialized((Object)sm);
        }
        ObjectMapper om = new ObjectMapper();
        try {
            String ss = om.writeValueAsString((Object)sm);
            return ObjectSerialUtil.compress4GZip((String)ss);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String getSpreadStyleJson(String compressedStr) {
        String json = JsonSerializerUtil.uncompress(compressedStr.substring(6));
        try {
            Map spread = (Map)JSONUtils.cast((String)json, Map.class);
            Map sheets = (Map)spread.get(SHEETS);
            HashMap<Map, Integer> styles = new HashMap<Map, Integer>();
            HashMap<Integer, Map> styleData = new HashMap<Integer, Map>();
            HashMap<Integer, Integer> styleCount = new HashMap<Integer, Integer>();
            int index = 1;
            for (Map.Entry entry : sheets.entrySet()) {
                Map sheet = (Map)entry.getValue();
                sheet.remove(ACTIVE_ROW);
                sheet.remove(ACTIVE_COL);
                sheet.remove(SELECTIONS);
                Map data = (Map)sheet.get(DATA);
                Map dataTable = (Map)data.get(DATA_TABLE);
                for (Map.Entry rowEnry : dataTable.entrySet()) {
                    Map row = (Map)rowEnry.getValue();
                    for (Map.Entry cellEntry : row.entrySet()) {
                        Map style;
                        Map cell = (Map)cellEntry.getValue();
                        Object remove = cell.remove(VALUE);
                        if (remove != null) {
                            cell.put(V, remove);
                        }
                        if ((style = (Map)cell.get(STYLE)) == null) continue;
                        int id = 0;
                        if (!styles.containsKey(style)) {
                            id = index++;
                            styles.put(style, id);
                            styleData.put(id, style);
                            styleCount.put(id, 1);
                        } else {
                            id = (Integer)styles.get(style);
                            styleCount.put(id, (Integer)styleCount.get(id) + 1);
                        }
                        cell.remove(STYLE);
                        cell.put(S, id);
                    }
                }
            }
            String spreadJson = JSONUtils.toString((Object)spread);
            String styleJson = JSONUtils.toString(styleData);
            return "{\"spread\":" + spreadJson + ",\"styles\":" + styleJson + "}";
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String uncompress(String compressedStr) {
        return ObjectSerialUtil.uncompress((String)compressedStr);
    }
}

