/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.model.dao.Tuple;

public class MultiAreaPositionsManager
implements Serializable,
Iterable<Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>>> {
    private static final long serialVersionUID = 1L;
    private Map<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> dic = new HashMap<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>>(1);
    private Map<PositionInfo, Set<Tuple<String[], Object>>> dynaDelVal = new HashMap<PositionInfo, Set<Tuple<String[], Object>>>();

    public void addArea(PositionInfo p, RowDimDomain r, ColumnDimDomain c) {
        this.dic.put(p, Tuple.newOne(r, c));
    }

    public boolean containsKey(PositionInfo p) {
        PositionInfo pos = this.searchStorePositionInfo(p);
        return this.dic.containsKey(pos);
    }

    public PositionInfo searchStorePositionInfo(PositionInfo p) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.equals(p) && !e.equalsByOriginal(p)) continue;
            return e;
        }
        return null;
    }

    public PositionInfo searchStorePositionInfoByOriginal(PositionInfo p) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.equalsByOriginal(p)) continue;
            return e;
        }
        return null;
    }

    public PositionInfo searchStorePositionInfo(String area) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.getAreaRange().equals(area)) continue;
            return e;
        }
        return null;
    }

    public Set<PositionInfo> getPostionInfoSet() {
        return this.dic.keySet();
    }

    public int getPositionSize() {
        return this.dic.size();
    }

    public Tuple<RowDimDomain, ColumnDimDomain> getRowAndColDomainByPosition(PositionInfo p) {
        PositionInfo pos = this.searchStorePositionInfo(p);
        return this.dic.get(pos);
    }

    public Tuple<RowDimDomain, ColumnDimDomain> removeArea(PositionInfo p) {
        PositionInfo pos = this.searchStorePositionInfo(p);
        return this.dic.remove(pos);
    }

    @Override
    public Iterator<Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>>> iterator() {
        return this.dic.entrySet().iterator();
    }

    public Iterator<Tuple<RowDimDomain, ColumnDimDomain>> iteratorValues() {
        return this.dic.values().iterator();
    }

    public RowDimDomain getFirstAreaRowDimDomain() {
        for (Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> e : this) {
            if (((RowDimDomain)e.getValue().k).getAllMembers().size() <= 0) continue;
            return (RowDimDomain)e.getValue().k;
        }
        return null;
    }

    public ColumnDimDomain getFirstAreaColDimDomain() {
        for (Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> e : this) {
            if (((ColumnDimDomain)e.getValue().v).getAllMembers().size() <= 0) continue;
            return (ColumnDimDomain)e.getValue().v;
        }
        return null;
    }

    public void reSetRowColDimDomain() {
        this.dic.entrySet().forEach(e -> e.setValue(Tuple.newOne(new RowDimDomain(), new ColumnDimDomain())));
    }

    public RowDimDomain getRowDimDoman(PositionInfo p) {
        Tuple<RowDimDomain, ColumnDimDomain> t = this.getRowAndColDomainByPosition(p);
        if (t != null) {
            return (RowDimDomain)t.k;
        }
        return null;
    }

    public ColumnDimDomain getColDimDomain(PositionInfo p) {
        Tuple<RowDimDomain, ColumnDimDomain> t = this.getRowAndColDomainByPosition(p);
        if (t != null) {
            return (ColumnDimDomain)t.v;
        }
        return null;
    }

    public Map<PositionInfo, Set<Tuple<String[], Object>>> getDynaDelVal() {
        return this.dynaDelVal;
    }

    public void putDynaDelVal(PositionInfo pos, String[] dimMembCross, Object val) {
        if (!this.dynaDelVal.containsKey(pos)) {
            this.dynaDelVal.put(pos, new HashSet());
        }
        this.dynaDelVal.get(pos).add(Tuple.newOne(dimMembCross, val));
    }

    public Set<Tuple<String[], Object>> getDelDynaValsByPos(PositionInfo pos) {
        return this.dynaDelVal.get(pos);
    }

    public void clearDynaDelVals() {
        this.dynaDelVal.clear();
    }

    private Object readResolve() {
        if (this.dynaDelVal == null) {
            this.dynaDelVal = new HashMap<PositionInfo, Set<Tuple<String[], Object>>>();
        }
        return this;
    }
}

