/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.builder.PrintLogger;
import kd.epm.eb.ebSpread.util.SpanMergeHandler;

public class Sheet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_ROW = 2000;
    private static final int DEFAULT_MAX_COL = 52;
    private List<List<Cell>> table = new ArrayList<List<Cell>>();
    private String sheetName;
    private Map<String, Object> userObject;

    public Sheet() {
    }

    public Sheet(String sheetName) {
        this.sheetName = sheetName;
    }

    public void putUserObject(String key, Object val) {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>();
        }
        this.userObject.put(key, val);
    }

    public <T> T getUserObject(String key) {
        if (this.userObject == null) {
            return null;
        }
        return (T)this.userObject.get(key);
    }

    public void addRow() {
        this.table.add(this.extendSameColCountAtOneRow());
    }

    private List<Cell> extendSameColCountAtOneRow() {
        ArrayList<Cell> cols = new ArrayList<Cell>(this.getMaxColumnCount());
        if (this.getMaxColumnCount() > 0) {
            for (int i = 0; i < this.getMaxColumnCount(); ++i) {
                cols.add(this.createCell(false));
            }
        }
        return cols;
    }

    private Cell createCell(boolean isCreated) {
        return isCreated ? new Cell() : null;
    }

    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
    }

    public void addRange(int rowCount, int colCount) {
        this.addRows(rowCount);
        this.addColumns(colCount);
    }

    public Cell getCell(int row, int col) {
        this.ensureCapacity(row, col);
        Cell cell = this.table.get(row).get(col);
        if (cell == null) {
            cell = this.createCell(true);
            this.table.get(row).set(col, cell);
        }
        cell.setRowAndCol(row, col);
        return cell;
    }

    private void ensureCapacity(int row, int col) {
        int maxrow = this.getMaxRowCount();
        int maxcol = this.getMaxColumnCount();
        if (row > maxrow - 1) {
            this.autoGrowRows(row - maxrow + 1);
        }
        if (col > maxcol - 1) {
            this.autoGrowCols(col - maxcol + 1);
        }
    }

    private void autoGrowRows(int rowCount) {
        this.addRows(rowCount);
    }

    private void autoGrowCols(int colCount) {
        this.addColumns(colCount);
    }

    public void insertRow(int i) {
        if (!this.ensureMaxRow(i)) {
            return;
        }
        i = Math.min(i, this.table.size() - 1);
        this.table.add(i, this.extendSameColCountAtOneRow());
    }

    public void insertRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int r;
        for (r = 0; r < rowcount; ++r) {
            this.insertRow(r + selcRowindex);
        }
        this.ensureCapacity(selcRowindex, toColIdx + rowcount);
        for (r = rowcount - 1; r >= 0; --r) {
            this.moveRowUp(fromColIdx, toColIdx, selcRowindex + r, r);
        }
        PrintLogger.outputLogFile(this);
    }

    public void delRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        this.moveRowUpInRangeField(fromColIdx, toColIdx, selcRowindex, rowcount);
    }

    private void moveRowUpInRangeField(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int c;
        List<Cell> targ;
        int from;
        int maxRowCount = this.getMaxRowCount();
        for (from = selcRowindex + rowcount; from < maxRowCount; ++from) {
            List<Cell> source = this.table.get(from);
            targ = this.table.get(from - rowcount);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, source.get(c));
            }
        }
        for (from = maxRowCount - rowcount; from < maxRowCount; ++from) {
            targ = this.table.get(from);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, this.createCell(false));
            }
        }
    }

    public void delRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        this.moveColLeftInRangeField(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private void moveColLeftInRangeField(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        int maxColCount = this.getMaxColumnCount();
        for (int r = fromRowIdx; r <= toRowIdx; ++r) {
            List<Cell> targ = this.table.get(r);
            for (int c = selcColindex + colCount; c < maxColCount; ++c) {
                targ.set(c - colCount, targ.get(c));
            }
        }
        for (int from = maxColCount - colCount; from < maxColCount; ++from) {
            for (int r = fromRowIdx; r <= toRowIdx; ++r) {
                this.table.get(r).set(from, this.createCell(false));
            }
        }
    }

    public void insertRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        for (int c = 0; c < colCount; ++c) {
            this.insertColumn(c + selcColindex);
        }
        this.ensureCapacity(toRowIdx, selcColindex + colCount);
        this.moveColLeft(fromRowIdx, toRowIdx, selcColindex, colCount);
        PrintLogger.outputLogFile(this);
    }

    private void moveColLeft(int excludeFromRowIdx, int excludeToRowIdx, int selcColindex, int colCount) {
        List<Cell> currRow = null;
        int size = this.getMaxRowCount();
        for (int r = 0; r < size; ++r) {
            if (r >= excludeFromRowIdx && r <= excludeToRowIdx) continue;
            currRow = this.getRowInner(r);
            this.doMoveColLeft(currRow, selcColindex, colCount);
        }
    }

    private void doMoveColLeft(List<Cell> currRow, int selcColindex, int colCount) {
        Cell[] dataElements = currRow.toArray(new Cell[0]);
        int size = dataElements.length;
        System.arraycopy(dataElements, selcColindex + colCount, dataElements, selcColindex, this.getMaxColumnCount() - (selcColindex + colCount));
        for (int c = 0; c < colCount; ++c) {
            dataElements[--size] = this.createCell(false);
        }
        currRow.clear();
        currRow.addAll(Arrays.asList(dataElements));
    }

    public static void main(String[] args) {
        Sheet sheet = new Sheet("test");
        for (int r = 0; r < 10; ++r) {
            for (int c = 0; c < 8; ++c) {
                sheet.getCell(r, c).setValue(ExcelUtils.xy2Pos((int)c, (int)r));
            }
        }
        PrintLogger.outputLogFile(sheet);
        sheet.insertRangeRows(1, 5, 1, 1);
        sheet.insertRangeCols(2, 5, 1, 1);
    }

    private void moveRowUp(int excludeFromColIdx, int excludeToColIdx, int startIndex, int offset) {
        List<Cell> nextRow = null;
        int columSize = this.getMaxColumnCount();
        int size = this.table.size();
        for (int idx = startIndex; idx < size && idx != size - 1 - offset; ++idx) {
            this.ensureCapacity(idx + 1, this.getMaxColumnCount() - 1);
            List<Cell> currRow = this.table.get(idx);
            nextRow = this.table.get(idx + 1);
            this.doReplace(currRow, nextRow, 0, excludeFromColIdx - 1);
            this.doReplace(currRow, nextRow, excludeToColIdx + 1, columSize - 1);
        }
        if (nextRow == null) {
            return;
        }
        size = nextRow.size();
        for (int i = 0; i < size; ++i) {
            if (i >= excludeFromColIdx && i <= excludeToColIdx) continue;
            nextRow.set(i, this.createCell(false));
        }
    }

    private void doReplace(List<Cell> targ, List<Cell> src, int start, int end) {
        if (start > end) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            targ.set(i, src.get(i));
        }
    }

    private List<Cell> getRowInner(int i) {
        return this.table.get(i);
    }

    public void delRow(int i) {
        if (!this.ensureMaxRow(i)) {
            return;
        }
        this.table.remove(i);
    }

    public void delColumn(int i) {
        if (!this.ensureMaxCol(i)) {
            return;
        }
        for (List<Cell> column : this.table) {
            column.remove(i);
        }
    }

    private boolean ensureMaxRow(int rowIndex) {
        return rowIndex < this.getMaxRowCount();
    }

    private boolean ensureMaxCol(int colIndex) {
        return colIndex < this.getMaxColumnCount();
    }

    @Deprecated
    public Iterator<Cell> iteratorCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        int rowIdx = 0;
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, colIdx);
                    cells.add(cell);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
        return cells.iterator();
    }

    public void iteratorCells(Consumer<Cell> consumer) {
        int rowIdx = 0;
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, colIdx);
                    consumer.accept(cell);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    public void iteratorCellsByPredicateBreak(Predicate<Cell> predicate) {
        int rowIdx = 0;
        int colIdx = 0;
        block0: for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, colIdx);
                    if (predicate.test(cell)) break block0;
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    public void iteratorRangeByPredicateBreak(int fromRow, int endRow, int fromCol, int endCol, Predicate<Cell> predicate) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        block0: for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell = this.table.get(r).get(c);
                if (cell == null) continue;
                cell.setRowAndCol(r, c);
                if (predicate.test(cell)) break block0;
            }
        }
    }

    public void iteratorRowRangeCells(int fromRow, int endRow, Consumer<Cell> consumer) {
        this.iteratorRowRangeCells(fromRow, endRow, false, consumer);
    }

    public void iteratorRowRangeCells(int fromRow, int endRow, boolean isCreateNew, Consumer<Cell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        int colIdx = 0;
        for (int r = fromRow; r <= endRow; ++r) {
            colIdx = 0;
            for (Cell cell : this.table.get(r)) {
                if (cell != null) {
                    cell.setRowAndCol(r, colIdx);
                    consumer.accept(cell);
                } else if (isCreateNew) {
                    cell = this.getCell(r, colIdx);
                    consumer.accept(cell);
                }
                ++colIdx;
            }
        }
    }

    public void iteratorColRangeCells(int fromCol, int endCol, Consumer<Cell> consumer) {
        this.iteratorColRangeCells(fromCol, endCol, false, consumer);
    }

    public void iteratorColRangeCells(int fromCol, int endCol, boolean isCreateNew, Consumer<Cell> consumer) {
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        int rowIdx = 0;
        for (List<Cell> row : this.table) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell = row.get(c);
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, c);
                    consumer.accept(cell);
                    continue;
                }
                if (!isCreateNew) continue;
                cell = this.getCell(rowIdx, c);
                consumer.accept(cell);
            }
            ++rowIdx;
        }
    }

    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, Consumer<Cell> consumer) {
        this.iteratorRangeCells(fromRow, endRow, fromCol, endCol, false, consumer);
    }

    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, boolean isCreateNew, Consumer<Cell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell;
                if (isCreateNew) {
                    cell = this.getCell(r, c);
                    consumer.accept(cell);
                    continue;
                }
                cell = this.table.get(r).get(c);
                if (cell == null) continue;
                cell.setRowAndCol(r, c);
                consumer.accept(cell);
            }
        }
    }

    public List<Cell> getRow(int rowIndex) {
        return this.getRow(rowIndex, false);
    }

    public List<Cell> getRow(int rowIndex, boolean isCreateNew) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        this.iteratorRowRangeCells(rowIndex, rowIndex, isCreateNew, cell -> cells.add((Cell)cell));
        return cells;
    }

    public List<Cell> getCol(int colIndex) {
        return this.getCol(colIndex, false);
    }

    public List<Cell> getCol(int colIndex, boolean isCreateNew) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        this.iteratorColRangeCells(colIndex, colIndex, isCreateNew, cell -> cells.add((Cell)cell));
        return cells;
    }

    public void shrinkSheetModel(boolean isTemplate) {
        this.shrinkContent(isTemplate);
        this.shrinkRow();
        this.shrinkCol();
    }

    private void shrinkCol() {
        if (this.table.isEmpty()) {
            return;
        }
        int maxColCount = this.getMaxColumnCount();
        int delFromIndex = -1;
        Recorder r = new Recorder((Object)-1);
        boolean canRemoveCol = false;
        int c = maxColCount - 1;
        while (c >= 1) {
            r.setRecord((Object)c);
            canRemoveCol = this.table.parallelStream().allMatch(row -> row.get((Integer)r.getRecord()) == null);
            if (!canRemoveCol) break;
            delFromIndex = c--;
        }
        if (delFromIndex != -1) {
            for (List<Cell> row2 : this.table) {
                for (int c2 = row2.size() - 1; c2 >= delFromIndex; --c2) {
                    row2.remove(c2);
                }
            }
        }
    }

    private void shrinkRow() {
        boolean isAllNull;
        for (int i = this.table.size() - 1; i >= 1 && (isAllNull = this.table.get(i).stream().allMatch(cell -> cell == null)); --i) {
            this.table.remove(i);
        }
    }

    public void shrinkContent(boolean isTemplate) {
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty()) {
                        cell.getMemberFromUserObject().forEach(e -> {
                            if (e.getDimension() != null) {
                                e.getDimension().setName(null);
                            }
                            e.setName(null);
                        });
                        if (isTemplate) {
                            cell.setValue(null);
                            cell.setChangeVal(false);
                        }
                    } else if (cell.getUserObject() == null && !cell.hasFormula()) {
                        row.set(colIdx, null);
                    }
                }
                ++colIdx;
            }
        }
    }

    public void insertColumn(int i) {
        if (!this.ensureMaxCol(i)) {
            return;
        }
        for (List<Cell> column : this.table) {
            column.add(i, this.createCell(false));
        }
    }

    public void addColumn() {
        for (List<Cell> column : this.table) {
            column.add(this.createCell(false));
        }
    }

    public void addColumns(int colCount) {
        for (List<Cell> row : this.table) {
            for (int i = 0; i < colCount; ++i) {
                row.add(this.createCell(false));
            }
        }
    }

    public void clear() {
        this.table.clear();
    }

    public int getMaxRowCount() {
        return this.table.size() > 0 ? this.table.size() : 0;
    }

    public int getCountOnRow(int row) {
        return this.table.get(row).size();
    }

    public int getMaxColumnCount() {
        return this.table.size() > 0 ? this.table.get(0).size() : 0;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String toJSon() {
        StringBuilder json = new StringBuilder();
        json.append('\"').append(this.sheetName).append("\":{");
        json.append("\"name\":\"").append(this.sheetName).append("\",");
        json.append("\"rowCount\":\"").append(this.getMaxOrDefault(this.getMaxRowCount(), true)).append("\",");
        json.append("\"columnCount\":\"").append(this.getMaxOrDefault(this.getMaxColumnCount(), false)).append("\",");
        json.append(this.toTableJSon());
        json.append('}');
        return json.toString();
    }

    private int getMaxOrDefault(int max, boolean isRow) {
        return Math.max(max, isRow ? 2000 : 52);
    }

    public String toJson_dataDomain() {
        StringBuilder json = new StringBuilder();
        json.append("{\"data\":[");
        int maxRows = this.getMaxRowCount();
        int maxCols = this.getMaxColumnCount();
        boolean hasMoreOne = false;
        for (int r = 0; r < maxRows; ++r) {
            for (int c = 0; c < maxCols; ++c) {
                Cell cell = this.getCell(r, c);
                if (!cell.isMdDataDomain() || !cell.isChangeVal()) continue;
                if (hasMoreOne) {
                    json.append(',');
                }
                json.append("{\"r\":").append(r).append(',');
                json.append("\"c\":").append(c).append(',');
                json.append("\"v\":").append(cell.valueToString());
                json.append('}');
                cell.setChangeVal(false);
                hasMoreOne = true;
            }
        }
        json.append("]}");
        return json.toString();
    }

    public List<Map<String, Object>> createClientValuesConfig() {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        this.iteratorCells(cell -> {
            Object locked = cell.getUserObject("locked");
            boolean lock = false;
            if (locked != null) {
                lock = (Boolean)locked;
            }
            if (cell.isChangeVal() && !lock) {
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", cell.getRow());
                e.put("c", cell.getCol());
                e.put("v", cell.getValue());
                cellValues.add(e);
                cell.setChangeVal(false);
            }
        });
        return cellValues;
    }

    public boolean hasModified(boolean isOnlyMd) {
        for (List<Cell> row : this.table) {
            for (Cell cell : row) {
                if (cell == null || !cell.isChangeVal()) continue;
                if (cell.isMdDataDomain()) {
                    return true;
                }
                if (isOnlyMd) continue;
                return true;
            }
        }
        return false;
    }

    public List<List<Cell>> getTable() {
        return this.table;
    }

    public Map<String, Object> getUserObject() {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>();
        }
        return this.userObject;
    }

    public String toTableJSon() {
        StringBuilder json = new StringBuilder();
        SpanMergeHandler spanHandler = new SpanMergeHandler();
        json.append("\"data\": {").append("\"dataTable\": {");
        int r = -1;
        for (List<Cell> row : this.table) {
            json.append('\"').append(++r).append("\":{");
            int c = -1;
            int nullcount = 0;
            if (row == null) continue;
            for (Cell cell : row) {
                ++c;
                if (cell == null) {
                    ++nullcount;
                    continue;
                }
                json.append('\"').append(c).append("\":{");
                json.append(cell.toJSon());
                json.append("},");
                spanHandler.findAndMergeSpan(cell, r, c);
            }
            if (nullcount != row.size()) {
                json.deleteCharAt(json.length() - 1);
            }
            json.append("},");
        }
        if (!this.table.isEmpty()) {
            json.deleteCharAt(json.length() - 1);
        }
        json.append("}}");
        if (!spanHandler.isEmpty()) {
            json.insert(0, spanHandler.toJSon() + ",");
        }
        return json.toString();
    }

    public void setCellToNULL(int row, int col) {
        if (row < this.getMaxRowCount() && col < this.getMaxColumnCount()) {
            this.table.get(row).set(col, null);
        }
    }
}

