/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kd.epm.eb.common.ebcommon.common.util.RangeModel;
import kd.epm.eb.ebSpread.domain.view.Book;
import kd.epm.eb.ebSpread.domain.view.FilterView;
import kd.epm.eb.ebSpread.domain.view.MultiAreaPositionsManager;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManagerDeserializer;
import kd.epm.eb.ebSpread.domain.view.SpreadManagerSerializer;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.model.IDimMember;

@JsonSerialize(using=SpreadManagerSerializer.class)
@JsonDeserialize(using=SpreadManagerDeserializer.class)
public class SpreadManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Book book;
    private FilterView filter = null;
    private MultiAreaPositionsManager pm;
    private static final BasePointInnerLineInfo[] EmptyBasePointInnerLineInfo = new BasePointInnerLineInfo[0];
    @JsonIgnore
    private transient Map<String, String> cachedSpreadModelAllFilterDimNumbers;
    @JsonIgnore
    private transient NavigableMap<Integer, TreeMap<Integer, RangeModelWrap>> basePointRangeModelRowIndexMap;
    @JsonIgnore
    private transient TreeMap<Integer, RangeModelWrap> positionRangeModelRowIndexMap;
    @JsonIgnore
    private transient TreeMap<Integer, RangeModelWrap> positionRangeModelColumnIndexMap;

    public void rebuildBasePointInfoLookupMap() {
        TreeMap<Integer, TreeMap<Integer, RangeModelWrap>> rowIndexMap = new TreeMap<Integer, TreeMap<Integer, RangeModelWrap>>();
        this.positionRangeModelRowIndexMap = new TreeMap();
        this.positionRangeModelColumnIndexMap = new TreeMap();
        for (PositionInfo positionInfo : this.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                RangeModelWrap rangeModelWrap = new RangeModelWrap(positionInfo, basePointInfo);
                int x = rangeModelWrap.basePointDirectionRange.getX_start();
                int y = rangeModelWrap.basePointDirectionRange.getY_start();
                TreeMap<Integer, RangeModelWrap> tempBufRangeModelMap = (TreeMap<Integer, RangeModelWrap>)rowIndexMap.get(y);
                if (tempBufRangeModelMap == null) {
                    tempBufRangeModelMap = new TreeMap<Integer, RangeModelWrap>();
                    rowIndexMap.put(y, tempBufRangeModelMap);
                }
                tempBufRangeModelMap.put(x, rangeModelWrap);
                if (!this.positionRangeModelRowIndexMap.containsKey(y)) {
                    this.positionRangeModelRowIndexMap.put(y, rangeModelWrap);
                }
                if (this.positionRangeModelColumnIndexMap.containsKey(x)) continue;
                this.positionRangeModelColumnIndexMap.put(x, rangeModelWrap);
            }
        }
        this.basePointRangeModelRowIndexMap = rowIndexMap.descendingMap();
    }

    public RangeModelWrap getInAreaRangeModelWrapByXY(int row, int column) {
        NavigableMap<Integer, TreeMap<Integer, RangeModelWrap>> matchRowMap;
        if (this.basePointRangeModelRowIndexMap == null) {
            this.rebuildBasePointInfoLookupMap();
        }
        if (!(matchRowMap = this.basePointRangeModelRowIndexMap.tailMap(row, true)).isEmpty()) {
            for (Map.Entry rowEn : matchRowMap.entrySet()) {
                RangeModelWrap result;
                RangeModel basePointInfoRange;
                Map.Entry matchRangeEntryBuf = ((TreeMap)rowEn.getValue()).floorEntry(column);
                if (matchRangeEntryBuf == null || (basePointInfoRange = (result = (RangeModelWrap)matchRangeEntryBuf.getValue()).getBasePointInfoRange()).getY_end() < row || basePointInfoRange.getX_end() < column) continue;
                return result;
            }
        }
        return null;
    }

    public BasePointInfo getInAreaBasePointInfoByXY(int row, int column) {
        RangeModelWrap wrap = this.getInAreaRangeModelWrapByXY(row, column);
        return wrap != null ? wrap.getBasePointInfo() : null;
    }

    public PositionInfo getInAreaPositionInfoByXY(int row, int column) {
        RangeModelWrap wrap = this.getInAreaRangeModelWrapByXY(row, column);
        return wrap != null ? wrap.getPositionInfo() : null;
    }

    public PositionInfo.FloatMemDisplayPattern getInAreaFloatMemDisplayPatternByXY(int row, int column) {
        PositionInfo position = this.getInAreaPositionInfoByXY(row, column);
        return position != null ? position.getFloatMemDisplayPattern() : null;
    }

    public RangeModelWrap getInDirectionBasePointInfoAndPositionInfobyXY(boolean horizontalMode, int row, int column) {
        RangeModel basePointDirectionRange;
        Map.Entry<Integer, RangeModelWrap> matchMapEntry;
        if (this.positionRangeModelRowIndexMap == null || this.positionRangeModelColumnIndexMap == null) {
            this.rebuildBasePointInfoLookupMap();
        }
        if ((matchMapEntry = horizontalMode ? this.positionRangeModelRowIndexMap.floorEntry(row) : this.positionRangeModelColumnIndexMap.floorEntry(column)) != null && (basePointDirectionRange = matchMapEntry.getValue().basePointDirectionRange).getY_end() >= row && basePointDirectionRange.getX_end() >= column) {
            return matchMapEntry.getValue();
        }
        return null;
    }

    public BasePointInnerLineInfo[] getBasePointInnerLineInfos(int row, int column) {
        RangeModelWrap basePointInfo = this.getInAreaRangeModelWrapByXY(row, column);
        if (basePointInfo != null) {
            int comparePos;
            int basePos;
            if (basePointInfo.getBasePointInfo().getDirect() == 2) {
                basePos = basePointInfo.getBasePointInfoRange().getY_start();
                comparePos = column;
            } else {
                basePos = basePointInfo.getBasePointInfoRange().getX_start();
                comparePos = row;
            }
            ArrayList<BasePointInnerLineInfo> items = new ArrayList<BasePointInnerLineInfo>();
            for (BasePointInnerLineInfo innerInfo : basePointInfo.getBasePointInfo().getBasePointInnerLineInfo()) {
                if (basePos + innerInfo.getOffset() != comparePos) continue;
                items.add(innerInfo);
            }
            return items.toArray(EmptyBasePointInnerLineInfo);
        }
        return EmptyBasePointInnerLineInfo;
    }

    public SpreadManager(String sheetName, FilterView filter) {
        this.filter = filter;
        this.book = new Book();
        this.book.addSheet(new Sheet(sheetName));
        this.pm = new MultiAreaPositionsManager();
    }

    public MultiAreaPositionsManager getAreaManager() {
        return this.pm;
    }

    public void setAreaManager(MultiAreaPositionsManager pm) {
        this.pm = pm;
    }

    public FilterView getFilter() {
        return this.filter;
    }

    public void setFilter(FilterView filter) {
        this.filter = filter;
    }

    public Book getBook() {
        return this.book;
    }

    public void setBook(Book book) {
        this.book = book;
    }

    public boolean hasModified(boolean isOnlyMd) {
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            if (!this.book.getSheet(i).hasModified(isOnlyMd)) continue;
            return true;
        }
        return false;
    }

    public void resetAllCachedMemberList() {
        this.getFilter().getPageDomain().resetCachedMemberList();
        this.getFilter().getViewPointDomain().resetCachedMemberList();
        this.cachedSpreadModelAllFilterDimNumbers = null;
    }

    @JsonIgnore
    public Map<String, String> getCachedSpreadModelAllFilterDimNumbers() {
        if (this.cachedSpreadModelAllFilterDimNumbers == null) {
            this.cachedSpreadModelAllFilterDimNumbers = new HashMap<String, String>();
            if (this.filter != null) {
                List<IDimMember> listMemmber;
                if (this.filter.getPageDomain() != null && (listMemmber = this.filter.getPageDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        this.cachedSpreadModelAllFilterDimNumbers.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
                if (this.filter.getViewPointDomain() != null && (listMemmber = this.filter.getViewPointDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        this.cachedSpreadModelAllFilterDimNumbers.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
            }
        }
        return this.cachedSpreadModelAllFilterDimNumbers;
    }

    public static class RangeModelWrap {
        private PositionInfo positionInfo;
        private BasePointInfo basePointInfo;
        private RangeModel positionInfoRange;
        private RangeModel basePointInfoRange;
        private RangeModel basePointDirectionRange;
        private int _cachedHashCode = -1;

        public PositionInfo getPositionInfo() {
            return this.positionInfo;
        }

        public BasePointInfo getBasePointInfo() {
            return this.basePointInfo;
        }

        public RangeModel getPositionInfoRange() {
            return this.positionInfoRange;
        }

        public RangeModel getBasePointInfoRange() {
            return this.basePointInfoRange;
        }

        public RangeModel getBasePointDirectionRange() {
            return this.basePointDirectionRange;
        }

        public RangeModelWrap(PositionInfo positionInfo, BasePointInfo basePointInfo) {
            this.positionInfo = positionInfo;
            this.basePointInfo = basePointInfo;
            this.basePointInfoRange = new RangeModel(basePointInfo.getDynaRange());
            this.positionInfoRange = new RangeModel(positionInfo.getAreaRange());
            this.basePointDirectionRange = basePointInfo.getDirect() == 1 ? new RangeModel(this.basePointInfoRange.getX_start(), this.positionInfoRange.getX_end(), this.basePointInfoRange.getY_start(), this.basePointInfoRange.getY_end()) : new RangeModel(this.basePointInfoRange.getX_start(), this.basePointInfoRange.getX_end(), this.basePointInfoRange.getY_start(), this.positionInfoRange.getY_end());
            this._cachedHashCode = basePointInfo.getDynaRange().hashCode();
        }

        public int hashCode() {
            return this._cachedHashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RangeModelWrap) {
                return this._cachedHashCode == ((RangeModelWrap)obj).hashCode();
            }
            return false;
        }
    }
}

