/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.Book;
import kd.epm.eb.ebSpread.domain.view.MultiAreaPositionsManager;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.dao.Tuple;

public class SpreadManagerSerializer
extends JsonSerializer<SpreadManager> {
    protected static final String BOOK = "book";
    protected static final String AREA_MANAGER = "ma";
    protected static final String NAME = "name";
    protected static final String TABLE = "table";
    protected static final String USEROBJECT = "o";
    protected static final String CELLDATA = "v";
    protected static final String FORMULA = "f";
    protected static final String ISCHANGEVAL = "c";
    protected static final String ISMDDATADOMAIN = "m";
    protected static final String DIMMEMBERS = "d";
    protected static final String DIMENSION_NUMBER = "di";
    protected static final String DIMENSION_NAME = "din";
    protected static final String DIMMEMBSER_NUMBER = "dm";
    protected static final String DIMMEMBSER_NAME = "dmn";

    public void serialize(SpreadManager manager, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.writeAreaManager(manager, jgen, provider);
        this.writeBook(manager.getBook(), jgen, provider);
        jgen.writeEndObject();
    }

    private void writeAreaManager(SpreadManager manager, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Book book = manager.getBook();
        this.setDimMemberId(manager.getAreaManager());
        manager.setBook(null);
        jgen.writeStringField(AREA_MANAGER, ObjectSerialUtil.toByteSerialized((Object)manager));
        manager.setBook(book);
    }

    private void setDimMemberId(MultiAreaPositionsManager pm) {
        int id = 1;
        Iterator<Tuple<RowDimDomain, ColumnDimDomain>> it = pm.iteratorValues();
        while (it.hasNext()) {
            Tuple<RowDimDomain, ColumnDimDomain> val = it.next();
            if (val.k == null) continue;
            for (IDimension dim : ((RowDimDomain)val.k).getDimensions()) {
                for (IDimMember dm : dim.getMembers()) {
                    ((DimMember)dm).setId(id++);
                }
            }
            for (IDimension dim : ((ColumnDimDomain)val.v).getDimensions()) {
                for (IDimMember dm : dim.getMembers()) {
                    ((DimMember)dm).setId(id++);
                }
            }
        }
    }

    private void writeBook(Book book, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeArrayFieldStart(BOOK);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            this.writeSheets(book.getSheet(i), jgen, provider);
        }
        jgen.writeEndArray();
    }

    private void writeSheets(Sheet sheet, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField(NAME, sheet.getSheetName());
        jgen.writeArrayFieldStart(TABLE);
        List<List<Cell>> rows = sheet.getTable();
        for (List<Cell> row : rows) {
            jgen.writeStartArray();
            for (Cell cell : row) {
                this.writeCell(cell, jgen, provider);
            }
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
        this.writeSheetUserObject(sheet, jgen, provider);
        jgen.writeEndObject();
    }

    private void writeSheetUserObject(Sheet sheet, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (sheet.getUserObject() != null && !sheet.getUserObject().isEmpty()) {
            Set<String> keys = sheet.getUserObject().keySet();
            jgen.writeObjectFieldStart(USEROBJECT);
            for (String key : keys) {
                Object obj = sheet.getUserObject().get(key);
                if (obj == null) continue;
                provider.defaultSerializeField(key, obj, jgen);
            }
            jgen.writeEndObject();
        }
    }

    private void writeCell(Cell cell, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (cell != null) {
            this.writeCellData(cell, jgen, provider);
            if (cell.getFormula() != null) {
                jgen.writeStringField(FORMULA, cell.getFormula());
            }
            if (cell.isChangeVal()) {
                jgen.writeNumberField(ISCHANGEVAL, 1);
            }
            if (!cell.isMdDataDomain()) {
                jgen.writeNumberField(ISMDDATADOMAIN, 1);
            }
            this.writeDimMember(cell, jgen);
            this.writeUserObject(cell, jgen, provider);
        }
        jgen.writeEndObject();
    }

    private void writeCellData(Cell cell, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (cell.getValue() != null) {
            if (10 == cell.getVariant().getVt()) {
                jgen.writeNumberField(CELLDATA, (BigDecimal)cell.getValue());
            } else {
                jgen.writeArrayFieldStart(CELLDATA);
                jgen.writeNumber(cell.getVariant().getVt());
                this.defaultSerialize(cell.getVariant().getVt(), cell.getValue(), provider, jgen);
                jgen.writeEndArray();
            }
        }
    }

    private void writeDimMember(Cell cell, JsonGenerator jgen) throws IOException {
        List<IDimMember> dmList = cell.getMemberFromUserObject();
        if (dmList == null || dmList.isEmpty()) {
            return;
        }
        jgen.writeArrayFieldStart(DIMMEMBERS);
        for (IDimMember dm : dmList) {
            if (dm == null) continue;
            if (((DimMember)dm).getId() == 0L) {
                jgen.writeStartObject();
                jgen.writeStringField(DIMENSION_NUMBER, dm.getDimension().getNumber());
                if (dm.getDimension().getName() != null) {
                    jgen.writeStringField(DIMENSION_NAME, dm.getDimension().getName());
                }
                jgen.writeStringField(DIMMEMBSER_NUMBER, dm.getNumber());
                if (dm.getName() != null) {
                    jgen.writeStringField(DIMMEMBSER_NAME, dm.getName());
                }
                jgen.writeEndObject();
                continue;
            }
            jgen.writeNumber(((DimMember)dm).getId());
        }
        jgen.writeEndArray();
    }

    private void writeUserObject(Cell cell, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (!cell.getUserObject().isEmpty()) {
            HashSet keys = new HashSet(cell.getUserObject().keySet());
            keys.remove("KEY_DIM_FLAG");
            Object obj = cell.getUserObject().get("notupdata");
            if (obj != null && Boolean.FALSE.equals(obj)) {
                keys.remove("notupdata");
            }
            if (keys.isEmpty()) {
                return;
            }
            jgen.writeObjectFieldStart(USEROBJECT);
            for (String key : keys) {
                obj = cell.getUserObject().get(key);
                if (obj == null) continue;
                if (obj instanceof DimMember) {
                    jgen.writeNumberField(key, ((DimMember)obj).getId());
                    continue;
                }
                provider.defaultSerializeField(key, cell.getUserObject().get(key), jgen);
            }
            jgen.writeEndObject();
        }
    }

    private void defaultSerialize(int vt, Object val, SerializerProvider provider, JsonGenerator jgen) throws IOException {
        provider.defaultSerializeValue((Object)val.toString(), jgen);
    }
}

