/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view.builder;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.Domain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.FilterView;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.builder.AbstractBuilder;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.model.IDimMember;

public class FreeStyleTemplateBuilder
extends AbstractBuilder {
    private PositionInfo positionInfo;
    private List<List<IDimMember>> rowDimMembCrossList;
    private List<List<IDimMember>> colDimMembCrossList;

    public FreeStyleTemplateBuilder(Sheet sheet, FilterView filter, RowDimDomain rowDimDoman, ColumnDimDomain colDimDomain, PositionInfo positionInfo) {
        super(sheet, filter, rowDimDoman, colDimDomain);
        this.positionInfo = positionInfo;
    }

    @Override
    protected void buildStruct() {
        this.buildDataDomain();
    }

    private void buildDataDomain() {
        this.rowDimMembCrossList = this.extendDimDomain(this._rowDimDomain);
        this.colDimMembCrossList = this.extendDimDomain(this._colDimDomain);
        int startX = ExcelUtils.pos2X((String)this.positionInfo.getStartPosition());
        int startY = ExcelUtils.pos2Y((String)this.positionInfo.getStartPosition());
        int cycleX = 0;
        int rSize = this.rowDimMembCrossList.size();
        for (int r = 0; r < rSize; ++r) {
            cycleX = 0;
            int cSize = this.colDimMembCrossList.size();
            for (int c = 0; c < cSize; ++c) {
                Cell cell = this._sheet.getCell(startY, startX + cycleX);
                if (cell.getMemberFromUserObject() != null) {
                    cell.getMemberFromUserObject().clear();
                }
                cell.setMdDataDomain(false);
                if (this.isNotNullAllItems(this.rowDimMembCrossList.get(r)) && this.isNotNullAllItems(this.colDimMembCrossList.get(c))) {
                    cell.addDims2UserObject(this.rowDimMembCrossList.get(r));
                    cell.addDims2UserObject(this.colDimMembCrossList.get(c));
                    cell.setMdDataDomain(true);
                }
                ++cycleX;
            }
            ++startY;
        }
    }

    private boolean isNotNullAllItems(List<IDimMember> items) {
        boolean isNotNullAllItems = false;
        if (items != null) {
            isNotNullAllItems = items.stream().allMatch(e -> e != null);
        }
        return isNotNullAllItems;
    }

    private List<List<IDimMember>> extendDimDomain(Domain domain) {
        if (this._rowDimDomain.getDimSize() == 0) {
            return new ArrayList<List<IDimMember>>();
        }
        int memberCounts = domain.getDimension(0).getMembers().size();
        ArrayList<List<IDimMember>> memberCrossList = new ArrayList<List<IDimMember>>(memberCounts);
        int dimSize = domain.getDimSize();
        for (int r = 0; r < memberCounts; ++r) {
            ArrayList<IDimMember> item = new ArrayList<IDimMember>(dimSize);
            for (int c = 0; c < dimSize; ++c) {
                item.add(domain.getDimension(c).getMembers().get(r));
            }
            memberCrossList.add(item);
        }
        return memberCrossList;
    }
}

