/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.enums.TemplateTypeEnum;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntryExt;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.MembSettingBaseDetail;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.util.SerialSpliter;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.PrintLogger;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.dao.Tuple;

public class FreeStyleTemplateFinalBuilder {
    private SpreadManager spread;
    private Map<PositionInfo, Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>> posMap;
    private boolean isStoreCrossNums = false;
    private TemplateModel template;

    public FreeStyleTemplateFinalBuilder(SpreadManager spread, TemplateModel template) {
        this.spread = spread;
        this.template = template;
        this.posMap = new HashMap<PositionInfo, Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>>(spread.getAreaManager().getPositionSize());
    }

    public void doBuildReport(boolean isShrink, boolean isStoreCrossNums) {
        this.isStoreCrossNums = isStoreCrossNums;
        this.collectRowAndColMemberInfo();
        this.cross();
        PrintLogger.outputLogFile(this.getEffectiveSheet());
        if (isShrink) {
            this.shrinkShellModel();
        }
    }

    private void shrinkShellModel() {
        this.getEffectiveSheet().shrinkContent(true);
        this.getEffectiveSheet().shrinkSheetModel(false);
    }

    private Sheet getEffectiveSheet() {
        return this.spread.getBook().getSheet(0);
    }

    private void cross() {
        Sheet sheet = this.getEffectiveSheet();
        this.posMap.entrySet().forEach(e -> {
            if (!((List)((Tuple)e.getValue()).k).isEmpty() && !((List)((Tuple)e.getValue()).v).isEmpty()) {
                ((List)((Tuple)e.getValue()).k).forEach(r -> ((List)((Tuple)e.getValue()).v).forEach(c -> {
                    if (!sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).getUserObject("not_cross", Boolean.FALSE).booleanValue()) {
                        sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).clearMembersOfUserObject();
                        sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).addDims2UserObject(((DimensionMemberInfo)r).members);
                        sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).addDims2UserObject(((DimensionMemberInfo)c).members);
                        if (this.isStoreCrossNums) {
                            sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).setUserObject("cross_nums", this.collectMembNums(((DimensionMemberInfo)r).members, ((DimensionMemberInfo)c).members));
                        }
                        sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).setMdDataDomain(true);
                    }
                }));
            }
        });
    }

    private String collectMembNums(List<IDimMember> ... list) {
        StringBuilder sb = new StringBuilder();
        for (List<IDimMember> l : list) {
            l.forEach(m -> sb.append(m.getDimension().getNumber()).append(':').append(m.getNumber()).append('#'));
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private void collectRowAndColMemberInfo() {
        boolean isDynamic = false;
        int dynaDirect = -1;
        for (PositionInfo p : this.spread.getAreaManager().getPostionInfoSet()) {
            IDimension newOne;
            ArrayList<IDimMember> markmembers;
            List<IDimMember> members;
            AreaRangeEntry area = this.getAreaByStratpoint(p.getStartPosition());
            int[] dataxy = ExcelUtils.pos2XY((String)p.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[1]);
            int startCol = dataxy[0];
            HashMap<Integer, ArrayList<IDimMember>> fixMemberPosition = new HashMap<Integer, ArrayList<IDimMember>>();
            isDynamic = !p.getBasePoints().isEmpty();
            dynaDirect = isDynamic ? p.getBasePoints().get(0).getDirect() : -1;
            int FixMemberPosition = -1;
            RowDimDomain rowDomain = new RowDimDomain();
            ArrayList<DimensionMemberInfo> rows = new ArrayList<DimensionMemberInfo>();
            for (int r = dataxy[1]; r <= endxy[1]; ++r) {
                members = this.getEffectiveSheet().getCell(r, startCol).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList<IDimMember>(members);
                markmembers = new ArrayList<IDimMember>();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("row", m.getDimension().getNumber(), area)) continue;
                    if (!rowDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    rows.add(new DimensionMemberInfo(r, startCol, markmembers));
                }
                if (!isDynamic || dynaDirect != 1) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            ColumnDimDomain colDomain = new ColumnDimDomain();
            ArrayList<DimensionMemberInfo> cols = new ArrayList<DimensionMemberInfo>();
            int startRow = dataxy[1];
            FixMemberPosition = -1;
            for (int c = dataxy[0]; c <= endxy[0]; ++c) {
                members = this.getEffectiveSheet().getCell(startRow, c).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList<IDimMember>(members);
                markmembers = new ArrayList();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("col", m.getDimension().getNumber(), area)) continue;
                    if (!colDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        colDomain.addDimension(newOne);
                    }
                    colDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    cols.add(new DimensionMemberInfo(startRow, c, markmembers));
                }
                if (!isDynamic || dynaDirect != 2) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            if (this.template.getTemplateType() == null || this.template.getTemplateType().intValue() != TemplateTypeEnum.MSN.getType()) {
                AreaRangeEntry areaEntry = this.template.findAreaByArea(p.getAreaRange());
                RowDimDomain rowDomain2 = rowDomain;
                ColumnDimDomain colDomain2 = colDomain;
                int dimSize = areaEntry.getRowDimEntries().size() + areaEntry.getColDimEntries().size();
                this.getEffectiveSheet().iteratorRangeCells(dataxy[1], endxy[1], dataxy[0], endxy[0], cell -> {
                    if (cell.isMdDataDomain()) {
                        List<IDimMember> members2 = cell.getMemberFromUserObject();
                        if (members2 != null && !members2.isEmpty() && !cell.getUserObject("not_cross", Boolean.FALSE).booleanValue()) {
                            this.appendMember2RowOrColDomain(cell.getMemberFromUserObject(), areaEntry, rowDomain2, colDomain2, null, null);
                        } else {
                            SerialSpliter spliter;
                            String serial = cell.getUserObject("cross_nums", "");
                            if (StringUtils.isNotEmpty((String)serial) && serial.split(String.valueOf('#')).length == dimSize && (spliter = new SerialSpliter(serial)).getPairs().size() == dimSize) {
                                ArrayList<IDimMember> newmembers = new ArrayList<IDimMember>(dimSize);
                                for (int i = 0; i < spliter.getPairs().size(); ++i) {
                                    kd.epm.eb.ebSpread.model.Dimension dim = new kd.epm.eb.ebSpread.model.Dimension(null, (String)spliter.getPairs().getPair((int)i).p1, null);
                                    DimMember member = new DimMember(null, (String)spliter.getPairs().getPair((int)i).p2, null, dim);
                                    newmembers.add(member);
                                }
                                cell.clearMembersOfUserObject();
                                cell.addDims2UserObject(newmembers);
                                this.appendMember2RowOrColDomain(cell.getMemberFromUserObject(), areaEntry, rowDomain2, colDomain2, null, null);
                            }
                        }
                    }
                });
            }
            this.posMap.put(p, Tuple.newOne(rows, cols));
            this.spread.getAreaManager().addArea(p, rowDomain, colDomain);
            p.getBasePoints().forEach(bp -> bp.setFixMemberPosition(fixMemberPosition));
        }
    }

    private void appendMember2RowOrColDomain(List<IDimMember> members, AreaRangeEntry areaEntry, RowDimDomain rowDomain, ColumnDimDomain colDomain, Consumer<IDimMember> rowCons, Consumer<IDimMember> colCons) {
        if (members != null && !members.isEmpty()) {
            areaEntry.getRowDimEntries().forEach(row -> members.forEach(m -> {
                if (row.getDimension().getNumber().equals(m.getDimension().getNumber())) {
                    if (!rowDomain.containsDimension(m.getDimension())) {
                        IDimension newOne = m.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(m.getDimension()).addMember((IDimMember)m);
                    if (rowCons != null) {
                        rowCons.accept((IDimMember)m);
                    }
                }
            }));
            if (this.template.getTemplateType() != null && this.template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType()) {
                for (Pair pair : areaEntry.getColDimEntriesExt().get(0).getDimMembers()) {
                    for (IDimMember m : members) {
                        if (!((Dimension)pair.p1).getNumber().equals(m.getDimension().getNumber())) continue;
                        if (!colDomain.containsDimension(m.getDimension())) {
                            IDimension newOne = m.getDimension().copy();
                            colDomain.addDimension(newOne);
                        }
                        colDomain.getDimension(m.getDimension()).addMember(m);
                        if (colCons == null) continue;
                        colCons.accept(m);
                    }
                }
            } else {
                areaEntry.getColDimEntries().forEach(col -> members.forEach(m -> {
                    if (col.getDimension().getNumber().equals(m.getDimension().getNumber())) {
                        if (!colDomain.containsDimension(m.getDimension())) {
                            IDimension newOne = m.getDimension().copy();
                            colDomain.addDimension(newOne);
                        }
                        colDomain.getDimension(m.getDimension()).addMember((IDimMember)m);
                        if (colCons != null) {
                            colCons.accept((IDimMember)m);
                        }
                    }
                }));
            }
        }
    }

    public void rebuildRowAndColDimMember() {
        boolean isDynamic = false;
        int dynaDirect = -1;
        for (PositionInfo p : this.spread.getAreaManager().getPostionInfoSet()) {
            IDimension newOne;
            ArrayList<IDimMember> markmembers;
            List<IDimMember> members;
            AreaRangeEntry area = this.getAreaByStratpoint(p.getStartPosition());
            int[] dataxy = ExcelUtils.pos2XY((String)p.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[1]);
            int startCol = dataxy[0];
            HashMap<Integer, ArrayList<IDimMember>> fixMemberPosition = new HashMap<Integer, ArrayList<IDimMember>>();
            isDynamic = !p.getBasePoints().isEmpty();
            dynaDirect = isDynamic ? p.getBasePoints().get(0).getDirect() : -1;
            int FixMemberPosition = -1;
            RowDimDomain rowDomain = new RowDimDomain();
            ArrayList<DimensionMemberInfo> rows = new ArrayList<DimensionMemberInfo>();
            for (int r = dataxy[1]; r <= endxy[1]; ++r) {
                members = this.getEffectiveSheet().getCell(r, startCol).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList<IDimMember>(members);
                markmembers = new ArrayList<IDimMember>();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("row", m.getDimension().getNumber(), area)) continue;
                    if (!rowDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    rows.add(new DimensionMemberInfo(r, startCol, markmembers));
                }
                if (!isDynamic || dynaDirect != 1) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            ColumnDimDomain colDomain = new ColumnDimDomain();
            ArrayList<DimensionMemberInfo> cols = new ArrayList<DimensionMemberInfo>();
            int startRow = dataxy[1];
            FixMemberPosition = -1;
            for (int c = dataxy[0]; c <= endxy[0]; ++c) {
                members = this.getEffectiveSheet().getCell(startRow, c).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList<IDimMember>(members);
                markmembers = new ArrayList();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("col", m.getDimension().getNumber(), area)) continue;
                    if (!colDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        colDomain.addDimension(newOne);
                    }
                    colDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    cols.add(new DimensionMemberInfo(startRow, c, markmembers));
                }
                if (!isDynamic || dynaDirect != 2) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            this.posMap.put(p, Tuple.newOne(rows, cols));
            this.spread.getAreaManager().addArea(p, rowDomain, colDomain);
            p.getBasePoints().forEach(bp -> bp.setFixMemberPosition(fixMemberPosition));
        }
    }

    private AreaRangeEntry getAreaByStratpoint(String sp) {
        for (AreaRangeEntry ar : this.template.getAreaRangeEntries()) {
            if (!ar.getStartPosition().equals(sp)) continue;
            return ar;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u533a\u57df", (String)"FreeStyleTemplateFinalBuilder_0", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    private boolean checkColAndRow(String type, String dim, AreaRangeEntry area) {
        if (this.template.getTemplateType() != null && this.template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType() && "col".equals(type)) {
            List<ColDimensionEntryExt> aa = area.getColDimEntriesExt();
            ColDimensionEntryExt firstEntry = aa.get(0);
            for (Pair pair : firstEntry.getDimMembers()) {
                if (!dim.equals(((Dimension)pair.p1).getNumber())) continue;
                return true;
            }
        } else {
            List<MembSettingBaseDetail> aa = "col".equals(type) ? area.getColDimEntries() : area.getRowDimEntries();
            for (int i = 0; i < aa.size(); ++i) {
                MembSettingBaseDetail mb = aa.get(i);
                if (!dim.equals(mb.getDimension().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    static class DimensionMemberInfo {
        private int r;
        private int c;
        private List<IDimMember> members;

        DimensionMemberInfo(int r, int c, List<IDimMember> members) {
            this.r = r;
            this.c = c;
            this.members = members;
        }
    }
}

