/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.utils.ToStringHelper;
import kd.epm.eb.ebSpread.domain.view.builder.CircularInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.event.IAdjustRange;
import kd.epm.eb.ebSpread.model.IDimension;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class PositionInfo
implements Serializable,
IAdjustRange {
    private static final long serialVersionUID = 1L;
    public static final transient PositionInfo EMPTY = new PositionInfo("NULL", "NULL");
    private String startPosition;
    private String areaRange;
    private String originalStartPosition;
    private String originalAreaRange;
    private boolean isSplit = false;
    private List<BasePointInfo> basePoints = new ArrayList<BasePointInfo>(3);
    private List<CircularInfo> circularInfos = new ArrayList<CircularInfo>();
    private IDimension varDimension;
    private FloatSummaryWay floatSummaryWay;
    private int orgMemColIndex;
    private FloatOrgRange floatOrgRange;
    private FloatMemDisplayPattern floatMemDisplayPattern;
    private List<Integer> offsetIndex;

    public PositionInfo(String startPosition, String areaRange) {
        this.startPosition = startPosition;
        this.areaRange = areaRange;
        this.originalAreaRange = areaRange;
        this.originalStartPosition = startPosition;
    }

    public FloatSummaryWay getFloatSummaryWay() {
        return this.floatSummaryWay;
    }

    public boolean isFloatPosition() {
        return !this.basePoints.isEmpty();
    }

    public void setFloatSummaryWay(FloatSummaryWay floatSummaryWay) {
        this.floatSummaryWay = floatSummaryWay;
    }

    public int getOrgMemColIndex() {
        return this.orgMemColIndex;
    }

    public void setOrgMemColIndex(int orgMemColIndex) {
        this.orgMemColIndex = orgMemColIndex;
    }

    public FloatOrgRange getFloatOrgRange() {
        return this.floatOrgRange;
    }

    public void setFloatOrgRange(FloatOrgRange floatOrgRange) {
        this.floatOrgRange = floatOrgRange;
    }

    public FloatMemDisplayPattern getFloatMemDisplayPattern() {
        return this.floatMemDisplayPattern;
    }

    public void setFloatMemDisplayPattern(FloatMemDisplayPattern floatMemDisplayPattern) {
        this.floatMemDisplayPattern = floatMemDisplayPattern;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public String getAreaRange() {
        return this.areaRange;
    }

    public void setAreaRange(String areaRange) {
        this.areaRange = areaRange;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public String getOriginalStartPosition() {
        if (this.originalStartPosition == null) {
            this.originalStartPosition = this.startPosition;
        }
        return this.originalStartPosition;
    }

    public String getOriginalAreaRange() {
        if (this.originalAreaRange == null) {
            this.originalAreaRange = this.areaRange;
        }
        return this.originalAreaRange;
    }

    public boolean isRightAtCurrPosition(PositionInfo oth) {
        int[] currStartPos = ExcelUtils.pos2XY((String)this.getAreaRange().split(":")[0]);
        int[] currEndPos = ExcelUtils.pos2XY((String)this.getAreaRange().split(":")[1]);
        int[] othStartPos = ExcelUtils.pos2XY((String)oth.getAreaRange().split(":")[0]);
        int[] othEndPos = ExcelUtils.pos2XY((String)oth.getAreaRange().split(":")[1]);
        return othStartPos[0] > currEndPos[0] && Math.max(currStartPos[1], othStartPos[1]) <= Math.min(currEndPos[1], othEndPos[1]);
    }

    public boolean isBottomAtCurrPosition(PositionInfo oth) {
        int[] currStartPos = ExcelUtils.pos2XY((String)this.getAreaRange().split(":")[0]);
        int[] currEndPos = ExcelUtils.pos2XY((String)this.getAreaRange().split(":")[1]);
        int[] othStartPos = ExcelUtils.pos2XY((String)oth.getAreaRange().split(":")[0]);
        int[] othEndPos = ExcelUtils.pos2XY((String)oth.getAreaRange().split(":")[1]);
        return othStartPos[1] > currEndPos[1] && Math.max(currStartPos[0], othStartPos[0]) <= Math.min(currEndPos[0], othEndPos[0]);
    }

    public boolean isBiggerTo(PositionInfo oth) {
        int[] othEndPos;
        int[] currStartPos = ExcelUtils.pos2XY((String)this.getAreaRange().split(":")[0]);
        return currStartPos[0] > (othEndPos = ExcelUtils.pos2XY((String)oth.getAreaRange().split(":")[1]))[0] || currStartPos[1] > othEndPos[1];
    }

    public boolean equalsByOriginal(PositionInfo other) {
        return new EqualsBuilder().append((Object)this.getOriginalAreaRange(), (Object)other.getOriginalAreaRange()).append((Object)this.getOriginalStartPosition(), (Object)other.getOriginalStartPosition()).isEquals();
    }

    public List<BasePointInfo> getBasePoints() {
        return this.basePoints;
    }

    public void setBasePoints(List<BasePointInfo> basePoints) {
        this.basePoints = basePoints;
    }

    public List<CircularInfo> getCircularInfos() {
        return this.circularInfos;
    }

    public void addCircularInfo(CircularInfo circularInfo) {
        this.circularInfos.add(circularInfo);
    }

    public IDimension getVarDimension() {
        return this.varDimension;
    }

    public void setVarDimension(IDimension varDimension) {
        this.varDimension = varDimension;
    }

    public List<Integer> getOffsetIndex() {
        return this.offsetIndex;
    }

    public void setOffsetIndex(List<Integer> offsetIndex) {
        this.offsetIndex = offsetIndex;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (obj instanceof PositionInfo) {
            PositionInfo o = (PositionInfo)obj;
            isEquals = new EqualsBuilder().append((Object)this.areaRange, (Object)o.getAreaRange()).append((Object)this.startPosition, (Object)o.getStartPosition()).isEquals();
        }
        return isEquals;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this);
    }

    @Override
    public void adjustRange(AdjustRangeEvent event) {
        String[] splitArr = this.areaRange.split(":");
        int startcol = ExcelUtils.pos2X((String)splitArr[0]);
        int startrow = ExcelUtils.pos2Y((String)splitArr[0]);
        int endcol = ExcelUtils.pos2X((String)splitArr[1]);
        int endrow = ExcelUtils.pos2Y((String)splitArr[1]);
        if (startrow > endrow || startcol > endcol) {
            return;
        }
        String startPos = this.doAdjustRange(event, splitArr[0], false);
        String endPos = this.doAdjustRange(event, splitArr[1], true);
        this.areaRange = startPos + ":" + endPos;
        this.startPosition = this.doAdjustRange(event, this.startPosition, false);
        this.basePoints.forEach(bp -> bp.adjustRange(event));
    }

    private Object readResolve() {
        if (this.basePoints == null) {
            this.basePoints = new ArrayList<BasePointInfo>(3);
        }
        return this;
    }

    public static enum FloatMemDisplayPattern {
        NAME(1),
        NAMEANDNUMBER(2),
        NUMBER(3);

        private int index;

        private FloatMemDisplayPattern(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum FloatOrgRange {
        LEAF(1),
        DIRECT(2);

        private int index;

        private FloatOrgRange(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum FloatSummaryWay {
        SUPPORT(1),
        NONSUPPORT(2);

        private int index;

        private FloatSummaryWay(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

