/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view.builder;

import java.util.Arrays;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.Sheet;

public class PrintLogger {
    private static Log log = LogFactory.getLog(PrintLogger.class);

    public static void outputLogFile(Sheet sheet) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sheet.iteratorCells(cell -> sb.append('[').append(cell.getRow()).append(',').append(cell.getCol()).append("] hascode:").append(cell.hashCode()).append(' ').append(Arrays.toString(cell.toSaveFormat())).append('=').append(cell.getValue()).append('\n'));
        log.debug(sb.toString());
    }

    public static void testRangeMoveCorrect(Sheet sheet) {
        int maxrow = sheet.getMaxRowCount();
        int maxcol = sheet.getMaxColumnCount();
        StringBuilder sb = new StringBuilder();
        StringBuilder lines = new StringBuilder();
        int mod = 0;
        for (int r = 0; r < maxrow; ++r) {
            lines.append("[r=").append(r + 1).append(" cols=").append(sheet.getCountOnRow(r)).append("],");
            for (int c = 0; c < maxcol; ++c) {
                ++mod;
                Cell cell = sheet.getCell(r, c);
                String pos = ExcelUtils.xy2Pos((int)c, (int)r);
                if (pos.length() == 2) {
                    pos = pos + " ";
                }
                sb.append('[').append(r).append(',').append(c).append(',').append(pos).append(']').append('=').append(cell == null || cell.getVariant() == null ? "NL" : cell.getValue()).append("\t\t");
                if (mod % maxcol != 0) continue;
                sb.append('\n');
            }
        }
    }
}

