/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.domain.view.builder.dynamic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.RangeModel;
import kd.epm.eb.common.ebcommon.common.util.SpreadAreaUtil;
import kd.epm.eb.common.utils.ToStringHelper;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.event.IAdjustRange;
import kd.epm.eb.ebSpread.model.IDimMember;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BasePointInfo
implements Serializable,
IAdjustRange {
    private static final long serialVersionUID = 1L;
    public static final int DIRECT_H = 1;
    public static final int DIRECT_V = 2;
    private String dynaRange;
    private String originaldynaRange;
    private int direct = 2;
    private List<BasePointInnerLineInfo> lines = new ArrayList<BasePointInnerLineInfo>(3);
    private Map<Integer, List<IDimMember>> fixMemberPosition = new HashMap<Integer, List<IDimMember>>();
    private Map<String, List<String>> usedSeq = new HashMap<String, List<String>>();

    public BasePointInfo(String dynaRange, int direct) {
        this.dynaRange = dynaRange;
        this.originaldynaRange = dynaRange;
        this.direct = direct;
    }

    public String getOriginalDynaRange() {
        return this.originaldynaRange;
    }

    public void setDynaRange(String dynaRange) {
        this.dynaRange = dynaRange;
    }

    public String getDynaRange() {
        return this.dynaRange;
    }

    public int getDirect() {
        return this.direct;
    }

    public void clearBasePointInnerLineInfo() {
        this.lines.clear();
    }

    public void clearFixMemberPosition() {
        this.fixMemberPosition.clear();
    }

    public void addBasePointInnerLineInfo(BasePointInnerLineInfo line) {
        this.lines.add(line);
    }

    public List<BasePointInnerLineInfo> getBasePointInnerLineInfo() {
        return this.lines;
    }

    public boolean isDirectHoriz() {
        return this.direct == 1;
    }

    public Map<Integer, List<IDimMember>> getFixMemberPosition() {
        return this.fixMemberPosition;
    }

    public void addFixMemberPosition(Integer position, List<IDimMember> members) {
        this.fixMemberPosition.put(position, members);
    }

    public void setFixMemberPosition(Map<Integer, List<IDimMember>> fixMemberPosition) {
        this.fixMemberPosition = fixMemberPosition;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.dynaRange).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasePointInfo)) {
            return false;
        }
        BasePointInfo oth = (BasePointInfo)obj;
        return this.dynaRange.equals(oth.dynaRange);
    }

    @Override
    public void adjustRange(AdjustRangeEvent event) {
        String[] splitArr = this.dynaRange.split(":");
        String startPos = this.doAdjustRange(event, splitArr[0], false);
        String endPos = this.doAdjustRange(event, splitArr[1], true);
        this.dynaRange = startPos + ":" + endPos;
    }

    private Object readResolve() {
        if (this.fixMemberPosition == null) {
            this.fixMemberPosition = new HashMap<Integer, List<IDimMember>>();
        }
        return this;
    }

    public Map<String, List<String>> getUsedSeq() {
        if (this.usedSeq == null) {
            this.usedSeq = new HashMap<String, List<String>>();
        }
        return this.usedSeq;
    }

    public void setUsedSeq(String key, String seq) {
        if (this.usedSeq == null) {
            this.usedSeq = new HashMap<String, List<String>>();
        }
        if (this.usedSeq.get(key) == null) {
            ArrayList<String> set = new ArrayList<String>();
            set.add(seq);
            this.usedSeq.put(key, set);
        } else {
            this.usedSeq.get(key).add(seq);
        }
    }

    public void reCollectUsedSeq(SpreadManager spread) {
        this.usedSeq = new HashMap<String, List<String>>();
        String sp = this.dynaRange.split(":")[0];
        String ep = this.dynaRange.split(":")[1];
        Sheet sheet = spread.getBook().getSheet(0);
        int startx = ExcelUtils.pos2X((String)sp);
        int starty = ExcelUtils.pos2Y((String)sp);
        int endx = ExcelUtils.pos2X((String)ep);
        int endy = ExcelUtils.pos2Y((String)ep);
        if (!this.isDirectHoriz()) {
            for (int y = starty; y <= endy; ++y) {
                Cell cell = sheet.getCell(y, startx);
                if (cell.getUserObject("seqobject") == null) continue;
                IDimMember newseqmem = (IDimMember)cell.getUserObject("seqobject");
                ArrayList<IDimMember> mems = new ArrayList<IDimMember>();
                for (int x = startx; x <= endx; ++x) {
                    Cell mcell = sheet.getCell(y, x);
                    if (mcell.getMemberFromUserObject() == null) continue;
                    mems.addAll(mcell.getMemberFromUserObject());
                }
                String key = BasePointInfo.getFloatKey(this, mems);
                List<String> seqs = new ArrayList<String>();
                if (this.usedSeq.get(key) != null) {
                    seqs = this.usedSeq.get(key);
                }
                seqs.add(newseqmem.getNumber());
                this.usedSeq.put(key, seqs);
            }
        }
    }

    public static String getFloatKey(BasePointInfo bs, List<IDimMember> mems) {
        ArrayList<String> dim = new ArrayList<String>();
        for (BasePointInnerLineInfo inner : bs.getBasePointInnerLineInfo()) {
            if (inner.isSeq() || !inner.isFloated()) continue;
            dim.add(inner.getDimension().getNumber());
        }
        Object[] memslist = new String[dim.size()];
        mems.forEach(arg_0 -> BasePointInfo.lambda$getFloatKey$0(dim, (String[])memslist, arg_0));
        return Arrays.toString(memslist);
    }

    public RangeModel getDataArea(PositionInfo p) {
        RangeModel bpRange = SpreadAreaUtil.getRangModel((String)this.getDynaRange());
        RangeModel pRange = SpreadAreaUtil.getRangModel((String)p.getAreaRange());
        if (this.isDirectHoriz()) {
            String startPoint = ExcelUtils.xy2Pos((int)bpRange.getX_start(), (int)pRange.getY_start());
            String endPoint = ExcelUtils.xy2Pos((int)bpRange.getX_end(), (int)pRange.getY_end());
            return SpreadAreaUtil.getRangModel((String)(startPoint + ":" + endPoint));
        }
        String startPoint = ExcelUtils.xy2Pos((int)pRange.getX_start(), (int)bpRange.getY_start());
        String endPoint = ExcelUtils.xy2Pos((int)pRange.getX_end(), (int)bpRange.getY_end());
        return SpreadAreaUtil.getRangModel((String)(startPoint + ":" + endPoint));
    }

    private static /* synthetic */ void lambda$getFloatKey$0(List dim, String[] memslist, IDimMember m) {
        String dimnum = m.getDimension().getNumber();
        if (dim.contains(dimnum)) {
            memslist[dim.indexOf((Object)dimnum)] = m.getNumber();
        }
    }
}

