/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.ebSpread.domain.view.DimensionDeserializer;
import kd.epm.eb.ebSpread.domain.view.DimensionSerializer;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@JsonSerialize(using=DimensionSerializer.class)
@JsonDeserialize(using=DimensionDeserializer.class)
public class Dimension
implements IDimension,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String number;
    private List<IDimMember> members = new ArrayList<IDimMember>(0);
    private String uqCode;

    @JsonCreator
    public Dimension(@JsonProperty(value="name") String name, @JsonProperty(value="number") String number, @JsonProperty(value="uqCode") String uqCode) {
        this.name = name;
        this.number = number;
        this.uqCode = uqCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public List<IDimMember> getMembers() {
        return this.members;
    }

    @Override
    public void addMember(IDimMember member) {
        this.members.add(member);
    }

    @Override
    public void clearAll() {
        this.members.clear();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.number).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IDimension)) {
            return false;
        }
        IDimension other = (IDimension)obj;
        return this.number.equals(other.getNumber());
    }

    @Override
    public String getUqCode() {
        return this.uqCode;
    }

    @Override
    public IDimension copy() {
        return new Dimension(this.name, this.number, this.uqCode);
    }

    public String toString() {
        return "name:" + this.name + " number:" + this.number;
    }
}

