/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.model.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.datalock.DataLockCache;
import kd.epm.eb.common.ebcommon.common.PairList;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.Point;
import kd.epm.eb.common.ebcommon.common.util.RangeModel;
import kd.epm.eb.common.ebcommon.common.util.SpreadAreaUtil;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.ebBusiness.olap.IRelaMembSupplier;
import kd.epm.eb.ebBusiness.olap.OrgRelaMembSupplier;
import kd.epm.eb.ebBusiness.olap.OrgRelaProcessMembPool;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.Domain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.Book;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.dao.Tuple;
import kd.epm.eb.ebSpread.util.FillDataUtils;

public final class MDDataHandleService {
    private static final Log log = LogFactory.getLog(MDDataHandleService.class);
    private static final String logStr = "ebReportCellSets:";

    private static int getCurrencyIndex(String[] dimKey) {
        for (int i = 0; i < dimKey.length; ++i) {
            if (!StringUtil.equals(SysDimensionEnum.Currency.getNumber(), dimKey[i])) continue;
            return i;
        }
        return 10000;
    }

    private static String replaceVirCurr(String virtualCurrNum, List<DimMember> virtualCurr) {
        if (StringUtil.equals(virtualCurrNum, "EC")) {
            return virtualCurr.get(0).getNumber();
        }
        if (StringUtil.equals(virtualCurrNum, "PC")) {
            return virtualCurr.get(1).getNumber();
        }
        return virtualCurrNum;
    }

    public static void save(SpreadManager sm, Long modelId, String cubecatalog, IRelaMembSupplier<String, String> s) {
        MDDataHandleService.save(sm, modelId, cubecatalog, s, true);
    }

    public static void save(SpreadManager sm, Long modelId, String cubecatalog, IRelaMembSupplier<String, String> s, boolean needClearDynaDelVals) {
        if (sm.getAreaManager().getPositionSize() <= 0) {
            return;
        }
        List<Tuple<String, String>> viewTuples = MDDataHandleService.genTuples(sm.getFilter().getViewPointDomain());
        List<Tuple<String, String>> pageTuples = MDDataHandleService.genTuples(sm.getFilter().getPageDomain());
        Tuple<String, String> entityTuple = MDDataHandleService.rejectEntityDim(viewTuples, pageTuples);
        boolean hasRelaProcessOnViewOrPageDim = MDDataHandleService.hasRelaProcessOnViewOrPageDim(viewTuples, pageTuples);
        HashMultimap<PositionInfo, Tuple<String[], Object>> kvMaps = MDDataHandleService.genCellSetParams(sm);
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        SaveCommandInfo info = new SaveCommandInfo();
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-ebBatchSave-open");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)info, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
        stats.addInfo("end-ebBatchSave-open");
        log.info(stats.toString());
        MDDataHandleService.addFiexdDimension(info, memberMap, viewTuples);
        MDDataHandleService.addFiexdDimension(info, memberMap, pageTuples);
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        for (Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> entry : sm.getAreaManager()) {
            Tuple<RowDimDomain, ColumnDimDomain> tuple = entry.getValue();
            List<Tuple<String, String>> rowTuples = MDDataHandleService.genTuples((Domain)tuple.k);
            List<Tuple<String, String>> colTuples = MDDataHandleService.genTuples((Domain)tuple.v);
            if (rowTuples.isEmpty() || colTuples.isEmpty()) continue;
            List<String> dimKeySet = MDDataHandleService.genDimKeySet(rowTuples, colTuples);
            ArrayList<String> originalDimKeySet = new ArrayList<String>(dimKeySet);
            if (entityTuple != null) {
                dimKeySet.add((String)entityTuple.k);
            }
            int process_index = MDDataHandleService.getDimIndexOnRowColDim(originalDimKeySet, DimTypesEnum.PROCESS);
            int entity_index = MDDataHandleService.getDimIndexOnRowColDim(originalDimKeySet, DimTypesEnum.ENTITY);
            String[] dimKey = dimKeySet.toArray(new String[0]);
            int currency_index = MDDataHandleService.getCurrencyIndex(dimKey);
            List<DimMember> virtualCurr = FillDataUtils.getVirtualCurr(((OrgRelaMembSupplier)s).get_mainOrgId());
            info.setDimensions(dimKey);
            Set<Tuple<String[], Object>> kvSets = kvMaps.removeAll((Object)entry.getKey());
            Set<Tuple<String[], Object>> dynaDelKvSets = sm.getAreaManager().getDelDynaValsByPos(entry.getKey());
            MDDataHandleService.checkMemberExit(entry, dimKeySet, dynaDelKvSets, cubecatalog);
            if ((kvSets == null || kvSets.isEmpty()) && (dynaDelKvSets == null || dynaDelKvSets.isEmpty())) continue;
            if (kvSets == null || kvSets.isEmpty()) {
                kvSets = dynaDelKvSets;
            } else if (dynaDelKvSets != null && !dynaDelKvSets.isEmpty() && kvSets != null && !kvSets.isEmpty()) {
                HashMap snapshot = new HashMap();
                HashMap dynaSnapshot = new HashMap();
                kvSets.forEach(t -> snapshot.put(Joiner.on((String)"|").join((Object[])t.k), t));
                dynaDelKvSets.forEach(t -> dynaSnapshot.put(Joiner.on((String)"|").join((Object[])t.k), t));
                dynaSnapshot.entrySet().forEach(e -> snapshot.putIfAbsent(e.getKey(), e.getValue()));
                kvSets = new HashSet(snapshot.values());
            }
            CellSet cellSets = new CellSet(dimKey, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            cellSets.setFromQuery(false);
            DataLockCache dataLockCache = DataLockCache.init((Long)modelId);
            for (Tuple<String[], Object> t2 : kvSets) {
                String[] dest;
                if (entityTuple != null) {
                    if (hasRelaProcessOnViewOrPageDim || process_index != -1 && OrgRelaProcessMembPool.isRelaProcess(((String[])t2.k)[process_index])) {
                        dest = MDDataHandleService.appendOrgMemb((String[])t2.k, s.access((String)entityTuple.v));
                        if (currency_index < dest.length) {
                            dest[currency_index] = MDDataHandleService.replaceVirCurr(dest[currency_index], virtualCurr);
                        }
                        MDDataHandleService.appendInMemberMap(dimKey, dest, memberMap);
                        if (!dataLockCache.checkLock(memberMap)) {
                            cellSets.set(dest, FacTabFieldDefEnum.FIELD_MONEY.getField(), t2.v);
                            continue;
                        }
                        log.info("datalock_" + memberMap);
                        throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u7684\u6570\u636e\u4e2d\u6709\u6570\u636e\u9501\u5b9a\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u65e0\u6548", (String)"", (String)"", (Object[])new Object[0]));
                    }
                    dest = MDDataHandleService.appendOrgMemb((String[])t2.k, (String)entityTuple.v);
                    if (currency_index < dest.length) {
                        dest[currency_index] = MDDataHandleService.replaceVirCurr(dest[currency_index], virtualCurr);
                    }
                    MDDataHandleService.appendInMemberMap(dimKey, dest, memberMap);
                    if (!dataLockCache.checkLock(memberMap)) {
                        cellSets.set(dest, FacTabFieldDefEnum.FIELD_MONEY.getField(), t2.v);
                        continue;
                    }
                    log.info("datalock_" + memberMap);
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u7684\u6570\u636e\u4e2d\u6709\u6570\u636e\u9501\u5b9a\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u65e0\u6548", (String)"", (String)"", (Object[])new Object[0]));
                }
                if (hasRelaProcessOnViewOrPageDim || process_index != -1 && OrgRelaProcessMembPool.isRelaProcess(((String[])t2.k)[process_index])) {
                    dest = (String[])t2.k;
                    dest[entity_index] = s.access(dest[entity_index]);
                    continue;
                }
                MDDataHandleService.appendInMemberMap(dimKey, (String[])t2.k, memberMap);
                if (!dataLockCache.checkLock(memberMap)) {
                    cellSets.set((String[])t2.k, FacTabFieldDefEnum.FIELD_MONEY.getField(), t2.v);
                    continue;
                }
                log.info("datalock_" + memberMap);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u7684\u6570\u636e\u4e2d\u6709\u6570\u636e\u9501\u5b9a\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u65e0\u6548", (String)"", (String)"", (Object[])new Object[0]));
            }
            OlapServiceHelper.saveData(info, cellSets, cubecatalog, true, false);
        }
        if (needClearDynaDelVals) {
            sm.getAreaManager().clearDynaDelVals();
        }
    }

    private static void appendInMemberMap(String[] dimKey, String[] dest, Map<String, String> memberMap) {
        for (int i = 0; i < dimKey.length; ++i) {
            String dimNumber = dimKey[i];
            memberMap.put(dimNumber, dest[i]);
        }
    }

    private static void checkMemberExit(Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> entry, List<String> dimKeySet, Set<Tuple<String[], Object>> dynaDelKvSets, String cubecatalog) {
        int index;
        if (dynaDelKvSets == null) {
            return;
        }
        HashMap<Integer, String> indexmap = new HashMap<Integer, String>();
        for (BasePointInfo basePointInfo : entry.getKey().getBasePoints()) {
            for (BasePointInnerLineInfo basePointInnerLineInfo : basePointInfo.getBasePointInnerLineInfo()) {
                if (!basePointInnerLineInfo.isFloated()) continue;
                index = dimKeySet.indexOf(basePointInnerLineInfo.getDimension().getNumber());
                indexmap.put(index, basePointInnerLineInfo.getDimension().getNumber());
            }
        }
        HashMultimap numberMap = HashMultimap.create();
        for (Tuple<String[], Object> tuple : dynaDelKvSets) {
            Iterator iterator = indexmap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                numberMap.put((Object)i, (Object)((String[])tuple.k)[i]);
            }
        }
        HashMap<Integer, List<String>> hashMap = new HashMap<Integer, List<String>>(indexmap.size());
        for (Map.Entry entry2 : indexmap.entrySet()) {
            index = (Integer)entry2.getKey();
            Object[] un = OlapServiceHelper.batCheckMemberIsExistOlap((String)entry2.getValue(), numberMap.get((Object)index).toArray(new String[0]), cubecatalog);
            String[] unString = Arrays.asList(un).toArray(new String[0]);
            hashMap.put(index, Arrays.asList(unString));
        }
        HashSet<Tuple<String[], Object>> hashSet = new HashSet<Tuple<String[], Object>>();
        block5: for (Tuple<String[], Object> tt : dynaDelKvSets) {
            Iterator iterator = indexmap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean bl = ((List)hashMap.get(i)).contains(((String[])tt.k)[i]);
                if (!bl) continue;
                hashSet.add(tt);
                continue block5;
            }
        }
        dynaDelKvSets.removeAll(hashSet);
    }

    private static String[] appendOrgMemb(String[] src, String orgMember) {
        String[] dest = new String[src.length + 1];
        System.arraycopy(src, 0, dest, 0, src.length);
        dest[dest.length - 1] = orgMember;
        return dest;
    }

    private static int getDimIndexOnRowColDim(List<String> crossKeys, DimTypesEnum dimType) {
        int size = crossKeys.size();
        for (int i = 0; i < size; ++i) {
            if (!crossKeys.get(i).equals(dimType.getNumber())) continue;
            return i;
        }
        return -1;
    }

    private static void addFiexdDimension(SaveCommandInfo info, Map<String, String> memberMap, List<Tuple<String, String>> tuples) {
        for (Tuple<String, String> t : tuples) {
            info.addfixedDimension(new String[]{(String)t.k, (String)t.v});
            memberMap.put((String)t.k, (String)t.v);
        }
    }

    private static Tuple<String, String> rejectEntityDim(List<Tuple<String, String>> viewTuples, List<Tuple<String, String>> pageTuples) {
        int i;
        Tuple<String, String> entityTuple = null;
        for (i = viewTuples.size() - 1; i >= 0; --i) {
            if (!((String)viewTuples.get((int)i).k).equals(DimTypesEnum.ENTITY.getNumber())) continue;
            entityTuple = viewTuples.remove(i);
            break;
        }
        if (entityTuple == null) {
            for (i = pageTuples.size() - 1; i >= 0; --i) {
                if (!((String)pageTuples.get((int)i).k).equals(DimTypesEnum.ENTITY.getNumber())) continue;
                entityTuple = pageTuples.remove(i);
                break;
            }
        }
        return entityTuple;
    }

    private static boolean hasRelaProcessOnViewOrPageDim(List<Tuple<String, String>> viewTuples, List<Tuple<String, String>> pageTuples) {
        boolean has = viewTuples.stream().anyMatch(p -> ((String)p.k).equals(DimTypesEnum.PROCESS.getNumber()) && OrgRelaProcessMembPool.isRelaProcess((String)p.v));
        return has || pageTuples.stream().anyMatch(p -> ((String)p.k).equals(DimTypesEnum.PROCESS.getNumber()) && OrgRelaProcessMembPool.isRelaProcess((String)p.v));
    }

    public static Map<String, Object> query(SpreadManager sm, String cube, IRelaMembSupplier<String, String> s, List<DimMember> virtualCurr) {
        return MDDataHandleService.query(sm, cube, s, null, virtualCurr);
    }

    public static Map<String, Object> query(SpreadManager sm, String cube, IRelaMembSupplier<String, String> orgSupplier, IRelaMembSupplier<String, String> periodSupplier, List<DimMember> virtualCurr) {
        if (sm.getAreaManager().getPositionSize() <= 0) {
            return new HashMap<String, Object>(0);
        }
        List<Tuple<String, String>> rowTuples = null;
        List<Tuple<String, String>> colTuples = null;
        String[] measureKeys = new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
        HashMap<String, Object> allSets = new HashMap<String, Object>();
        for (Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> e : sm.getAreaManager()) {
            rowTuples = MDDataHandleService.genTuples(sm.getAreaManager().getRowDimDoman(e.getKey()));
            colTuples = MDDataHandleService.genTuples(sm.getAreaManager().getColDimDomain(e.getKey()));
            if (rowTuples.size() == 0 || colTuples.size() == 0) continue;
            List<String> selectDimKey = MDDataHandleService.genDimKeySet(rowTuples, colTuples);
            SelectCommandInfo queryInfo = new SelectCommandInfo();
            queryInfo.addDims(selectDimKey.toArray(new String[0]));
            queryInfo.addMeasures(measureKeys);
            MDDataHandleService.buildQueryFilter(sm.getFilter().getViewPointDomain(), queryInfo);
            MDDataHandleService.buildQueryFilter(sm.getFilter().getPageDomain(), queryInfo);
            MDDataHandleService.buildQueryFilter((Domain)e.getValue().k, queryInfo);
            MDDataHandleService.buildQueryFilter((Domain)e.getValue().v, queryInfo);
            if (virtualCurr != null && virtualCurr.size() == 2 && selectDimKey.contains("Currency")) {
                queryInfo.getFilter().stream().filter(p -> "Currency".equals(p.getName())).forEach(p -> p.addAllValues(Arrays.asList(((DimMember)virtualCurr.get(0)).getNumber(), ((DimMember)virtualCurr.get(1)).getNumber())));
            }
            if (MDDataHandleService.existRelaProcess(queryInfo)) {
                MDDataHandleService.appendOrgRelaMemb(queryInfo, orgSupplier);
            }
            if (periodSupplier != null) {
                MDDataHandleService.appendPeriodRelaMemb(queryInfo, periodSupplier);
            }
            MDDataHandleService.doLog(StringUtils.join((Object[])new String[]{queryInfo.toString(), " RPTName: ", sm.getBook().iterator().next().getSheetName(), " : cube:", cube}));
            allSets.putAll(OlapServiceHelper.queryData(queryInfo, cube));
        }
        MDDataHandleService.doLog(StringUtils.join((Object[])new String[]{((Object)allSets).toString(), " RPTName: ", sm.getBook().iterator().next().getSheetName(), " : cube:", cube}));
        return allSets;
    }

    private static void doLog(String info) {
        log.info(StringUtils.join((Object[])new String[]{logStr, info, RequestContext.get().getUserName(), "_", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())}));
    }

    private static void appendOrgRelaMemb(SelectCommandInfo queryInfo, IRelaMembSupplier<String, String> s) {
        Optional<DimensionFilterItem> opt = queryInfo.getFilter().stream().filter(p -> DimTypesEnum.PROCESS.getNumber().equals(p.getName())).findFirst();
        Recorder isOnlyRelaEntity = new Recorder((Object)false);
        if (opt.isPresent()) {
            isOnlyRelaEntity.setRecord((Object)opt.get().getValues().stream().allMatch(v -> OrgRelaProcessMembPool.isRelaProcess(v)));
        }
        queryInfo.getFilter().forEach(f -> {
            if (DimTypesEnum.ENTITY.getNumber().equals(f.getName())) {
                HashSet orgs = new HashSet();
                f.getValues().forEach(v -> {
                    orgs.add(s.access((String)v));
                    if (!((Boolean)isOnlyRelaEntity.getRecord()).booleanValue()) {
                        orgs.add(v);
                    }
                });
                f.setValues(new ArrayList(orgs));
            }
        });
    }

    private static void appendPeriodRelaMemb(SelectCommandInfo queryInfo, IRelaMembSupplier<String, String> s) {
        boolean exist = queryInfo.getFilter().stream().anyMatch(f -> {
            if (DimTypesEnum.PERIOD.getNumber().equals(f.getName())) {
                return f.getValues().stream().anyMatch(v -> OrgRelaProcessMembPool.isRelaPeriod(v));
            }
            return false;
        });
        if (exist) {
            queryInfo.getFilter().forEach(f -> {
                if (DimTypesEnum.PERIOD.getNumber().equals(f.getName())) {
                    HashSet orgs = new HashSet();
                    f.getValues().forEach(v -> {
                        orgs.add(v);
                        orgs.add(s.access((String)v));
                    });
                    f.setValues(new ArrayList(orgs));
                }
            });
        }
    }

    private static boolean existRelaProcess(SelectCommandInfo queryInfo) {
        return queryInfo.getFilter().stream().anyMatch(f -> {
            if (DimTypesEnum.PROCESS.getNumber().equals(f.getName())) {
                return f.getValues().stream().anyMatch(v -> OrgRelaProcessMembPool.isRelaProcess(v));
            }
            return false;
        });
    }

    public static void updateCellValues(Book book, Map<String, Object> cellSets, List<DimMember> virtualCurr) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            book.getSheet(i).iteratorCells(cell -> {
                if (cell.isMdDataDomain() && (cell.getUserObject("notupdata") == null || !cell.getUserObject("notupdata").equals(Boolean.TRUE))) {
                    cell.setValue(cellSets.get(FillDataUtils.combineMemberKey(cell, virtualCurr)));
                }
            });
        }
    }

    public static void updateCellValues(SpreadManager sm, Map<String, Object> cellSets, boolean isOnlyUpdateFixedArea) {
        for (PositionInfo p : sm.getAreaManager().getPostionInfoSet()) {
            if (isOnlyUpdateFixedArea && p.isFloatPosition()) {
                MDDataHandleService.parserFixPositionOfDynaArea(p).forEach(e -> sm.getBook().getSheet(0).iteratorRangeCells(((Point)e.p1).y, ((Point)e.p2).y, ((Point)e.p1).x, ((Point)e.p2).x, cell -> {
                    if (cell.isMdDataDomain()) {
                        cell.setValue(cellSets.get(FillDataUtils.combineMemberKey(cell)));
                    }
                }));
                continue;
            }
            String[] range = p.getAreaRange().split(":");
            Point start = ExcelUtils.pos2Point((String)range[0]);
            Point end = ExcelUtils.pos2Point((String)range[1]);
            sm.getBook().getSheet(0).iteratorRangeCells(start.y, end.y, start.x, end.x, cell -> {
                if (cell.isMdDataDomain() && (cell.getUserObject("notupdata") == null || !cell.getUserObject("notupdata").equals(Boolean.TRUE))) {
                    cell.setValue(cellSets.get(FillDataUtils.combineMemberKey(cell)));
                }
            });
        }
    }

    public static PairList<Point, Point> parserFixPositionOfDynaArea(PositionInfo p) {
        PairList list = new PairList();
        if (p.isFloatPosition()) {
            BasePointInfo[] bps = p.getBasePoints().toArray(new BasePointInfo[0]);
            RangeModel area = SpreadAreaUtil.getRangModel((String)p.getAreaRange());
            boolean isDirectHoriz = bps[0].isDirectHoriz();
            RangeModel first = SpreadAreaUtil.getRangModel((String)bps[0].getDynaRange());
            RangeModel sec = null;
            for (int i = 0; i < bps.length - 1; ++i) {
                sec = SpreadAreaUtil.getRangModel((String)bps[i + 1].getDynaRange());
                MDDataHandleService.calcAreaPoistion(first.getEndPoint(), sec.getStartPoint(), isDirectHoriz, area, (PairList<Point, Point>)list, false);
            }
            if (sec == null) {
                sec = SpreadAreaUtil.getRangModel((String)bps[bps.length - 1].getDynaRange());
            }
            MDDataHandleService.calcAreaPoistion(sec.getEndPoint(), area.getEndPoint(), isDirectHoriz, area, (PairList<Point, Point>)list, true);
        }
        return list;
    }

    private static void calcAreaPoistion(Point first, Point sec, boolean isDirectHoriz, RangeModel area, PairList<Point, Point> list, boolean isLastArea) {
        int endCol;
        int fromRow;
        int fromCol = isDirectHoriz ? first.x + 1 : area.getX_start();
        int n = fromRow = isDirectHoriz ? area.getY_start() : first.y + 1;
        int n2 = isDirectHoriz ? (isLastArea ? sec.x : sec.x - 1) : (endCol = area.getX_end());
        int endRow = isDirectHoriz ? area.getY_end() : (isLastArea ? sec.y : sec.y - 1);
        list.addPair((Object)new Point(fromCol, fromRow), (Object)new Point(endCol, endRow));
    }

    private static void buildQueryFilter(Domain domain, SelectCommandInfo queryInfo) {
        HashSet<String> memberSets = new HashSet<String>();
        for (IDimension d : domain.getDimensions()) {
            memberSets.clear();
            for (IDimMember m : d.getMembers()) {
                if (m == null) continue;
                memberSets.add(m.getNumber());
            }
            queryInfo.addFilter(d.getNumber(), memberSets.toArray(new String[0]));
        }
    }

    private static HashMultimap<PositionInfo, Tuple<String[], Object>> genCellSetParams(SpreadManager sm) {
        HashMultimap setSets = HashMultimap.create();
        sm.getAreaManager().getPostionInfoSet().forEach(p -> {
            Set<Tuple<String[], Object>> dynaDelKvSets = sm.getAreaManager().getDelDynaValsByPos((PositionInfo)p);
            HashMultimap dynaSnapshot = HashMultimap.create();
            if (dynaDelKvSets != null) {
                dynaDelKvSets.forEach(t -> dynaSnapshot.put((Object)Joiner.on((String)"|").join((Object[])t.k), t));
            }
            String[] range = p.getAreaRange().split(":");
            Point start = ExcelUtils.pos2Point((String)range[0]);
            Point end = ExcelUtils.pos2Point((String)range[1]);
            sm.getBook().getSheet(0).iteratorRangeCells(start.y, end.y, start.x, end.x, cell -> {
                if (cell.isMdDataDomain()) {
                    Set val;
                    Object locked = cell.getUserObject("locked");
                    boolean lock = false;
                    if (locked != null) {
                        lock = (Boolean)locked;
                    }
                    if (cell.isChangeVal() && !lock) {
                        setSets.put(p, Tuple.newOne(cell.toSaveFormat(), cell.getValue()));
                    }
                    if (dynaDelKvSets != null && !dynaDelKvSets.isEmpty() && (val = dynaSnapshot.get((Object)Joiner.on((String)"|").join((Object[])cell.toSaveFormat()))) != null) {
                        dynaDelKvSets.removeAll(val);
                    }
                }
            });
        });
        return setSets;
    }

    public static List<String> genDimKeySet(List<Tuple<String, String>> ... lists) {
        ArrayList<String> keySets = new ArrayList<String>();
        for (List<Tuple<String, String>> l : lists) {
            for (Tuple<String, String> t : l) {
                if (keySets.contains(t.k)) continue;
                keySets.add((String)t.k);
            }
        }
        return keySets;
    }

    public static List<Tuple<String, String>> genTuples(Domain domain) {
        ArrayList<Tuple<String, String>> tuples = new ArrayList<Tuple<String, String>>();
        if (domain == null) {
            return tuples;
        }
        for (IDimMember m : domain.getAllMembers()) {
            if (m == null) continue;
            tuples.add(Tuple.newOne(m.getDimension().getNumber(), m.getNumber()));
        }
        return tuples;
    }
}

