/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.model.schema;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;

public enum DimTableDef {
    ENTITY("EN", 1, "FentityID"),
    YEAR("FY", 2, "FYID"),
    PERIOD("P", 3, "Fperiod"),
    SCN("SCN", 4, "FscnID"),
    ACCT("ACT", 5, "FacctID"),
    PROC("PROC", 6, "FprocID"),
    CURR("CURR", 7, "FcurrID"),
    CHGTYPE("CT", 8, "FchgTypeID"),
    INTCOMP("IC", 9, "FintCompID"),
    VERSION("VER", 10, "FverID"),
    CUSTOM1("CUST1", 11, "Fcust1"),
    CUSTOM2("CUST2", 12, "Fcust2"),
    CUSTOM3("CUST3", 13, "Fcust3"),
    CUSTOM4("CUST4", 14, "Fcust4"),
    CUSTOM5("CUST5", 15, "Fcust5"),
    CUSTOM6("CUST6", 16, "Fcust6"),
    CUSTOM7("CUST7", 17, "Fcust7"),
    CUSTOM8("CUST8", 18, "Fcust8"),
    CUSTOM9("CUST9", 19, "Fcust9"),
    CUSTOM10("CUST10", 20, "Fcut10"),
    FACT("FACT", 21, "Famount");

    private static final String PK = "FID";
    private static final Map<String, DimTableDef> defMap;
    private String uqCode;
    private int ordinal;
    private String tblColName;

    public static DimTableDef searchByCode(String uqCode) {
        return defMap.get(uqCode);
    }

    private DimTableDef(String uqCode, int ordinal, String tblColName) {
        this.uqCode = uqCode;
        this.ordinal = ordinal;
        this.tblColName = tblColName;
    }

    public String getUqCode() {
        return this.uqCode;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getTblColName() {
        return this.tblColName;
    }

    public String getPK() {
        return this.uqCode + "." + PK;
    }

    public String getFacFkName() {
        return DimTableDef.FACT.uqCode + "." + this.tblColName;
    }

    static {
        defMap = new ConcurrentHashMap<String, DimTableDef>();
        for (DimTableDef def : DimTableDef.values()) {
            defMap.put(def.uqCode, def);
        }
    }

    public static class SortByMember
    implements Comparator<IDimMember> {
        @Override
        public int compare(IDimMember o1, IDimMember o2) {
            return ((DimTableDef)((Object)defMap.get(o1.getDimension().getUqCode()))).getOrdinal() - ((DimTableDef)((Object)defMap.get(o2.getDimension().getUqCode()))).getOrdinal();
        }
    }

    public static class SortByDim
    implements Comparator<IDimension> {
        @Override
        public int compare(IDimension o1, IDimension o2) {
            return ((DimTableDef)((Object)defMap.get(o1.getUqCode()))).getOrdinal() - ((DimTableDef)((Object)defMap.get(o2.getUqCode()))).getOrdinal();
        }
    }
}

