/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.ebSpread.util.GZIPUtils;

public class DataAndJsonTranslator {
    public static final String DEFAULT_SHEET_NAME = "Sheet1";
    public static final String ROWOUTLINES = "rowOutlines";
    public static final String COLUMNOUTLINES = "columnOutlines";

    public static String dealBase64Str(String spreadJson) {
        if (spreadJson.startsWith("base64")) {
            return spreadJson.substring(6);
        }
        return spreadJson;
    }

    public static JSONObject getSheetObject(JSONObject object) {
        return DataAndJsonTranslator.getSheetObject(object, DEFAULT_SHEET_NAME);
    }

    public static JSONObject getSheetObject(JSONObject object, String sheetname) {
        if (object == null) {
            return null;
        }
        if (sheetname == null) {
            sheetname = DEFAULT_SHEET_NAME;
        }
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject sheet = (JSONObject)sheets.values().iterator().next();
        if (sheets.containsKey((Object)sheetname)) {
            sheet = (JSONObject)sheets.get((Object)sheetname);
        }
        return sheet;
    }

    public static JSONObject getDataTable(JSONObject object, String sheetname) {
        if (object == null) {
            return null;
        }
        if (sheetname == null) {
            sheetname = DEFAULT_SHEET_NAME;
        }
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject sheet = (JSONObject)sheets.values().iterator().next();
        if (sheets.containsKey((Object)sheetname)) {
            sheet = (JSONObject)sheets.get((Object)sheetname);
        }
        JSONObject data = (JSONObject)sheet.get((Object)"data");
        return (JSONObject)data.get((Object)"dataTable");
    }

    public static String uncompress(String spreadJson) {
        if (spreadJson != null) {
            try {
                return new String(GZIPUtils.uncompress(Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str(spreadJson))));
            }
            catch (Exception e) {
                return spreadJson;
            }
        }
        return spreadJson;
    }

    public static JSONObject fromSpreadJson(String spreadJson) {
        if (spreadJson != null) {
            return JSON.parseObject((String)DataAndJsonTranslator.uncompress(spreadJson), (Feature[])new Feature[]{Feature.OrderedField});
        }
        return null;
    }

    public static String toSpreadJson(JSONObject object) {
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress(object.toJSONString()));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public static List<Integer[]> getLockedCells(JSONObject spreadJson) {
        JSONObject dataTable = DataAndJsonTranslator.getDataTable(spreadJson, DEFAULT_SHEET_NAME);
        if (dataTable != null) {
            LinkedList<Integer[]> lockedRowCols = new LinkedList<Integer[]>();
            for (Map.Entry rowEntry : dataTable.entrySet()) {
                Integer r = Integer.valueOf(rowEntry.getKey() + "");
                JSONObject columns = (JSONObject)rowEntry.getValue();
                for (Map.Entry columnEntry : columns.entrySet()) {
                    Integer c = Integer.valueOf(columnEntry.getKey() + "");
                    JSONObject column = (JSONObject)columnEntry.getValue();
                    JSONObject style = column.getJSONObject("style");
                    if (style == null || style.get((Object)"locked") == null || !Boolean.TRUE.equals(style.get((Object)"locked"))) continue;
                    lockedRowCols.add(new Integer[]{r, c});
                }
            }
            return lockedRowCols;
        }
        return null;
    }

    public static String replaceOutlineElements(String sourceSerial, String targetSerial) {
        String result = targetSerial;
        if (sourceSerial != null && targetSerial != null) {
            HashSet<String> elements = new HashSet<String>(2);
            JSONObject sourceJsonObject = DataAndJsonTranslator.fromSpreadJson(sourceSerial);
            JSONObject sourceSheet = DataAndJsonTranslator.getSheetObject(sourceJsonObject);
            if (sourceSheet == null) {
                return result;
            }
            JSONObject outlines = null;
            for (String e : new String[]{ROWOUTLINES, COLUMNOUTLINES}) {
                JSONArray outlineItems;
                outlines = (JSONObject)sourceSheet.get((Object)e);
                if (outlines == null || (outlineItems = (JSONArray)outlines.get((Object)"items")) == null || outlineItems.size() <= 0) continue;
                elements.add(e);
            }
            if (!elements.isEmpty()) {
                JSONObject targetJsonObject = DataAndJsonTranslator.fromSpreadJson(targetSerial);
                JSONObject targetSheet = DataAndJsonTranslator.getSheetObject(targetJsonObject);
                if (targetSheet == null) {
                    return result;
                }
                boolean replaced = false;
                for (String element : elements) {
                    Object sourceElement = sourceSheet.get((Object)element);
                    Object targetElement = targetSheet.get((Object)element);
                    if (targetElement != null && sourceElement != null) {
                        targetSheet.replace((Object)element, sourceElement);
                        replaced = true;
                        continue;
                    }
                    if (targetElement == null && sourceElement != null) {
                        targetSheet.put(element, sourceElement);
                        replaced = true;
                        continue;
                    }
                    if (targetElement == null || sourceElement != null) continue;
                    targetSheet.remove((Object)element);
                    replaced = true;
                }
                if (replaced) {
                    return DataAndJsonTranslator.toSpreadJson(targetJsonObject);
                }
            }
        }
        return result;
    }

    public static boolean templateHasOutLineElements(String serial) {
        if (StringUtils.isEmpty((CharSequence)serial)) {
            return false;
        }
        HashSet<String> elements = new HashSet<String>(2);
        JSONObject sourceJsonObject = DataAndJsonTranslator.fromSpreadJson(serial);
        JSONObject sourceSheet = DataAndJsonTranslator.getSheetObject(sourceJsonObject);
        if (sourceSheet == null) {
            return false;
        }
        JSONObject outlines = null;
        for (String e : new String[]{ROWOUTLINES, COLUMNOUTLINES}) {
            JSONArray outlineItems;
            outlines = (JSONObject)sourceSheet.get((Object)e);
            if (outlines == null || (outlineItems = (JSONArray)outlines.get((Object)"items")) == null || outlineItems.size() <= 0) continue;
            elements.add(e);
        }
        return !elements.isEmpty();
    }

    public static Point getSpreadRowAndColCount(JSONObject spreadJson) {
        if (spreadJson == null) {
            return null;
        }
        JSONObject sheets = DataAndJsonTranslator.getSheetObject(spreadJson);
        if (sheets != null && sheets.containsKey((Object)"rowCount") && sheets.containsKey((Object)"columnCount")) {
            Point point = new Point(sheets.getInteger("columnCount").intValue(), sheets.getInteger("rowCount").intValue());
            return point;
        }
        return null;
    }
}

