/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.util;

import java.util.HashSet;
import java.util.Set;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.model.SpanInfo;

public class SpanMergeHandler {
    private Set<SpanInfo> spanArr = new HashSet<SpanInfo>();

    public void findAndMergeSpan(Cell cell, int row, int col) {
        SpanInfo span = cell.getSpanInfo();
        if (span == null) {
            return;
        }
        if (this.spanArr.contains(span)) {
            span.setCol(col);
            span.setRow(row);
        } else {
            this.spanArr.add(span);
            span.setCol(col);
            span.setRow(row);
        }
    }

    public String toJSon() {
        if (this.spanArr.isEmpty()) {
            return "";
        }
        StringBuilder json = new StringBuilder();
        json.append("\"spans\": [");
        for (SpanInfo info : this.spanArr) {
            json.append('{').append("\"row\":").append(info.getRow()).append(',');
            json.append("\"rowCount\":").append(info.getRowcount()).append(',');
            json.append("\"col\":").append(info.getCol()).append(',');
            json.append("\"colCount\":").append(info.getColcount()).append("},");
        }
        json.deleteCharAt(json.length() - 1);
        json.append(']');
        return json.toString();
    }

    public boolean isEmpty() {
        return this.spanArr.isEmpty();
    }
}

