/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.EncryptUtils;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.spread.utils.SpreadDisposeUtils;
import org.apache.commons.io.IOUtils;

public class SpreadUtils {
    public static final String ISO_8859_1 = "ISO-8859-1";
    private static String dev_license;
    private static String deploy_license;

    private static void initLicense() {
        try (InputStream inputStream = SpreadUtils.class.getClassLoader().getResourceAsStream("spread/common/license.json");){
            if (inputStream != null) {
                String str = IOUtils.toString((InputStream)inputStream);
                JSONObject jsonObject = JSONObject.parseObject((String)str);
                String dev = jsonObject.getString("dev");
                String deploy = jsonObject.getString("deploy");
                if (StringUtils.isNotEmpty((String)dev)) {
                    dev_license = EncryptUtils.aesDecrypt((String)dev);
                }
                if (StringUtils.isNotEmpty((String)deploy)) {
                    deploy_license = EncryptUtils.aesDecrypt((String)deploy);
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static void SetLicenseKey(boolean isDev) {
        if (isDev) {
            Workbook.SetLicenseKey((String)dev_license);
        } else {
            Workbook.SetLicenseKey((String)deploy_license);
        }
    }

    public static byte[] transZippedJson2Excel(String zippedJson) {
        try {
            byte[] bs = zippedJson.getBytes(ISO_8859_1);
            String ssjson = new String(GZIPUtils.uncompress(Base64.getDecoder().decode(bs)));
            return SpreadUtils.transJson2Excel(ssjson);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] transJson2Excel(String ssjson) {
        Map sps = (Map)JSON.parseObject((String)ssjson, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
        if (SpreadDisposeUtils.removeRowFilter(sps)) {
            JSONObject result = new JSONObject(true);
            result.putAll(sps);
            ssjson = result.toJSONString();
        }
        if (sps.containsKey("styles")) {
            ssjson = SpreadUtils.trans2CompletelyJson(sps, ssjson);
        }
        Workbook workbook = new Workbook();
        workbook.fromJson(ssjson);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.save((OutputStream)os);
        return os.toByteArray();
    }

    private static String trans2CompletelyJson(Map<String, Object> sps, String ssjson) {
        JSONObject stylesObj = (JSONObject)sps.get("styles");
        JSONObject spreadObj = (JSONObject)sps.get("spread");
        Pattern p = Pattern.compile("\\{(?:\"v\":(.*?),)??\"s\":(.*?)\\}");
        StringBuffer sf = new StringBuffer();
        Matcher m = p.matcher(ssjson.substring(10, ssjson.indexOf(",\"styles")));
        while (m.find()) {
            String styleString = "";
            String valueVal = m.group(1);
            String styleVal = m.group(2);
            if (styleVal != null) {
                styleString = stylesObj.getString(styleVal).replace("\\", "\\\\");
            }
            if (valueVal != null && !valueVal.trim().equals("")) {
                m.appendReplacement(sf, "{\"value\":$1,\"style\":" + styleString + "}");
                continue;
            }
            m.appendReplacement(sf, "{\"style\":" + styleString + "}");
        }
        m.appendTail(sf);
        return sf.toString();
    }

    public static String transZippedBase64StringExcel2Json(String zippedBase64String) {
        byte[] bs = new byte[]{};
        try {
            bs = zippedBase64String.getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] uncompressedData = GZIPUtils.uncompress(Base64.getDecoder().decode(bs));
        return SpreadUtils.transExcel2Json(uncompressedData);
    }

    public static String transExcel2Json(byte[] data) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        Workbook workbook = new Workbook();
        workbook.open((InputStream)is);
        try {
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return workbook.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fromJson(InputStream inStream) {
        Workbook workbook = new Workbook();
        workbook.fromJson(inStream);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            workbook.save((OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        SpreadUtils.SetLicenseKey(true);
    }

    static {
        SpreadUtils.initLicense();
        SpreadUtils.SetLicenseKey(true);
    }
}

