/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.adaptor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.event.SpreadActionListener;
import kd.epm.eb.spread.command.rangedefined.FormulaCell;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.fix.FloatPasteInfo;
import kd.epm.eb.spread.listener.ISpreadBaseSupport;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.spread.IReportModelSupport;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.AutoFloatHelper;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.adjustdecompose.AdjustDecomposeServiceHelper;

public class FixSpreadJsAction
extends SpreadJsAction {
    public FixSpreadJsAction(AbstractFormPlugin plugin, String spreadkey) {
        super(plugin, spreadkey);
    }

    @Override
    public void cellValueUpdate(SpreadEvent event) {
        List values;
        IEbSpreadManager ebSpreadManager = null;
        if (this.plugin instanceof IReportModelSupport) {
            ebSpreadManager = ((IReportModelSupport)IReportModelSupport.class.cast(this.plugin)).getSpreadManager();
        }
        if (ebSpreadManager == null) {
            return;
        }
        Spread spread = (Spread)event.getSource();
        SpreadPostDataInfo data = spread.getPostDataInfo();
        if (data == null) {
            data = event.getPostData();
        }
        ISpreadContainer spreadContainer = null;
        if (this.plugin instanceof ISpreadBaseSupport) {
            spreadContainer = ((ISpreadBaseSupport)ISpreadBaseSupport.class.cast(this.plugin)).getspreadContainer();
        }
        if (!this.canEdit(values = data.getValues(), ebSpreadManager, spreadContainer)) {
            return;
        }
        boolean valueUpdated = false;
        long updateTime = System.currentTimeMillis();
        if (values != null) {
            data.getValues().forEach(v -> {
                if (v.get("v") instanceof String) {
                    v.put("v", v.get("v").toString().trim());
                }
            });
            HashMap<MultiAreaManager, List<ECell>> floatPasteCells = new HashMap<MultiAreaManager, List<ECell>>();
            String areaIndex = null;
            for (LinkedHashMap e : data.getValues()) {
                String strVal;
                Object val = e.get("v");
                String string = strVal = val == null ? null : String.valueOf(val);
                if (!(val instanceof Number) && !(val instanceof String) && !(val instanceof Character) && val != null) continue;
                AreaInfo areaInfo = null;
                if (ebSpreadManager != null) {
                    areaInfo = ebSpreadManager.getAreaInfoByRowCol((Integer)e.get("r"), (Integer)e.get("c"));
                    if (StringUtils.isEmpty(areaIndex) && areaInfo != null) {
                        areaIndex = areaInfo.getMultiAreaManager().getAreaIndex();
                    }
                }
                if (areaInfo == null || areaInfo.getRelativerow() < 0 || areaInfo.getRelativecol() < 0) continue;
                valueUpdated = true;
                if (val instanceof String) {
                    String metricDataType;
                    val = val.toString().trim();
                    Date date = StringUtils.isDate((String)((String)val));
                    if (StringUtils.isEmpty((String)((String)val))) {
                        val = null;
                    } else if (date != null) {
                        Map<String, String> memberMapByCell = ReportHelper.getMemberMapByCellFix(ebSpreadManager, (Integer)e.get("r"), (Integer)e.get("c"), false);
                        String metricMember = memberMapByCell.get(SysDimensionEnum.Metric.getNumber());
                        if (StringUtils.isNotEmpty((String)metricMember) && ebSpreadManager != null) {
                            metricDataType = ebSpreadManager.getMetricDatatypeMap().get(metricMember) + "";
                            if (MetricDataTypeEnum.DATE.getIndex().equals(metricDataType)) {
                                val = ConvertUtils.convertToOADate((Date)date);
                            }
                        }
                    } else if (this.isNotSupportExcelFormat((String)val)) {
                        String metricNumber = null;
                        Map<String, String> memberMapByCell = ReportHelper.getMemberMapByCellFix(ebSpreadManager, (Integer)e.get("r"), (Integer)e.get("c"), false);
                        if (memberMapByCell != null && (metricNumber = memberMapByCell.get(SysDimensionEnum.Metric.getNumber())) != null) {
                            metricDataType = ebSpreadManager.getMetricDatatypeMap().get(metricNumber) + "";
                            if (MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(metricDataType)) {
                                String vdata = this.removeAmountSign((String)val);
                                boolean isNegative = vdata.startsWith("(");
                                String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
                                if (isNegative) {
                                    validateData = "-" + validateData;
                                }
                                try {
                                    val = new BigDecimal(validateData);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                ECell cell = areaInfo.getMultiAreaManager().getData().getDataSheet().getECell(areaInfo.getRelativerow(), areaInfo.getRelativecol());
                boolean needUpdateUi = false;
                boolean needUpdateFormula = false;
                if (cell.isFloatCell()) {
                    if (strVal != null && areaInfo.getMultiAreaManager().getAreaIndex().equals(areaIndex)) {
                        this.addToFloatCells(areaInfo, cell, floatPasteCells, strVal);
                        this.clearDimProperty(e, areaInfo.getMultiAreaManager());
                        continue;
                    }
                    if (strVal != null && !areaInfo.getMultiAreaManager().getAreaIndex().equals(areaIndex)) {
                        needUpdateUi = true;
                        val = null;
                    }
                }
                CellValueEvent cellValueEvent = new CellValueEvent(cell.getValue(), val, e.get("v"), cell, areaInfo);
                if (this.plugin instanceof ISpreadBaseSupport) {
                    ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellValueUpdate(cellValueEvent);
                    if (cellValueEvent.isCancel()) {
                        needUpdateUi = true;
                        if (!"true".equals(cell.getUserObject("fixMember"))) {
                            val = cell.getValue();
                        }
                    } else if (cellValueEvent.getResetValue() != null) {
                        needUpdateUi = true;
                        val = cellValueEvent.getResetValue();
                    } else if (cellValueEvent.isSetValueNull()) {
                        needUpdateUi = true;
                        needUpdateFormula = true;
                        val = null;
                    }
                }
                if (val == null && cell.getValue() != null && ebSpreadManager != null) {
                    areaInfo.getMultiAreaManager().getToDeleteData().add(cell.getRow() + ebSpreadManager.getDeleteSepar() + cell.getCol());
                    if (cell.isFloatCell()) {
                        cell.removeUserObject("number");
                        cell.removeUserObject("name");
                        cell.removeUserObject("longnumber");
                        cell.removeUserObject("longname");
                        cell.removeUserObject("simplename");
                        List<CellDimMember> cellDimMembers = areaInfo.getMultiAreaManager().getRowpartitionDimMems().get(areaInfo.getRelativerow());
                        if (cellDimMembers != null) {
                            cellDimMembers.set(areaInfo.getRelativecol(), null);
                        }
                    }
                }
                if (val != null && cell.getValue() == null && ebSpreadManager != null) {
                    areaInfo.getMultiAreaManager().getToDeleteData().remove(cell.getRow() + ebSpreadManager.getDeleteSepar() + cell.getCol());
                }
                cell.setValue(val);
                cell.setUserObject("ut", updateTime);
                if (!cellValueEvent.isCancel()) {
                    areaInfo.getMultiAreaManager().getData().getDataSheet().setIsdatachanged(true);
                }
                if (spreadContainer == null || !needUpdateUi) continue;
                ECell tempcell = new ECell();
                tempcell.setValue(cell.getValue());
                tempcell.setRow((Integer)e.get("r"));
                tempcell.setCol((Integer)e.get("c"));
                spreadContainer.updateCellValue2(Lists.newArrayList((Object[])new ECell[]{tempcell}));
                if (!needUpdateFormula) continue;
                spreadContainer.setFormula(Lists.newArrayList((Object[])new FormulaCell[]{new FormulaCell(tempcell, null)}));
            }
            if (floatPasteCells.size() > 0) {
                String sourceFrom;
                boolean excelClient;
                IFormView pluginView = this.plugin.getView();
                AbstractReportPlugin abstractReportPlugin = (AbstractReportPlugin)AbstractReportPlugin.class.cast(this.plugin);
                IEbSpreadManager spreadManager = abstractReportPlugin.getSpreadManager();
                AutoFloatHelper autoFloatHelper = new AutoFloatHelper(abstractReportPlugin.getParentPlugin(), pluginView, spreadManager, abstractReportPlugin.getspreadContainer(), abstractReportPlugin.getTemplateModel());
                Map<String, List<FloatPasteInfo>> floatPasteInfoMap = autoFloatHelper.autofloatByCtrlVs(floatPasteCells, excelClient = "excel".equals(sourceFrom = pluginView != null ? pluginView.getPageCache().get("sourceFrom") : ""));
                if (floatPasteInfoMap.size() > 0) {
                    if (pluginView != null && excelClient) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        try {
                            pluginView.getPageCache().put("floatPasteInfoMap", objectMapper.writeValueAsString(floatPasteInfoMap));
                        }
                        catch (JsonProcessingException e) {
                            throw new KDBizException("floatPasteInfos Serialization error");
                        }
                    } else {
                        autoFloatHelper.openFloatPasteForm();
                    }
                }
                int startRow = (Integer)((LinkedHashMap)data.getValues().get(0)).get("r");
                int endRow = (Integer)((LinkedHashMap)data.getValues().get(data.getValues().size() - 1)).get("r");
                abstractReportPlugin.cacheRefreshRows(startRow, endRow);
            }
        }
        if (valueUpdated) {
            ((IReportModelSupport)IReportModelSupport.class.cast(this.plugin)).cacheSpreadManager();
        }
        this.plugin.getView().getPageCache().remove("isAdjust");
        this.plugin.getPageCache().put("isValueUpdate", valueUpdated ? "1" : "0");
    }

    @Override
    public boolean canEdit(List<LinkedHashMap<String, Object>> values, IEbSpreadManager ebSpreadManager, ISpreadContainer spreadContainer) {
        boolean canAdjust = true;
        try {
            boolean approveAdjust;
            IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
            Long modelId = ebSpreadManager.getModelobj().getId();
            Long appBillId = ApproveBillHelper.getAppBillIdFromPage((IFormView)this.getView());
            String reportProcessId = ReportHelper.getReportProcessId4ApproveLock(this.plugin.getPageCache(), appBillId, this.getSpreadManager());
            boolean isVirtual = false;
            if (!ConvertUtils.toLong((Object)reportProcessId).equals(this.getSpreadManager().getReportProcessId())) {
                isVirtual = true;
            }
            if (approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, ebSpreadManager.getReportProcessId(), this.plugin.getView(), appBillId, Boolean.valueOf(isVirtual))) {
                AdjustParam adjustParam = CommonUtils.getAdjustParam((Long)modelId);
                Long bizModelId = ebSpreadManager.getBusModelid();
                Long datasetId = ebSpreadManager.getDatasetid();
                for (LinkedHashMap<String, Object> value : values) {
                    Integer row = (Integer)value.get("r");
                    Integer col = (Integer)value.get("c");
                    AreaInfo areaInfo = ebSpreadManager.getAreaInfoByRowCol(row, col);
                    Map<String, String> memberMap = this.getMemberMapByCell(row, col, ebSpreadManager);
                    if (areaInfo == null || memberMap == null || memberMap.size() <= 0) continue;
                    try {
                        Map<String, Long> dimensionViews = ebSpreadManager.getDimemsionViews();
                        Map<String, String> dimViewMap = AdjustDecomposeServiceHelper.getDimViewMapFix(dimensionViews, memberMap, modelCacheHelper, areaInfo.getMultiAreaManager().getAreaIndex());
                        AdjustServiceHelper.canAdjust((IModelCacheHelper)modelCacheHelper, (Long)bizModelId, (Long)datasetId, dimViewMap, memberMap, (AdjustParam)adjustParam, (Long)ebSpreadManager.getReportProcessId());
                    }
                    catch (KDBizException e) {
                        canAdjust = false;
                        this.plugin.getView().showTipNotification(e.getMessage());
                        break;
                    }
                }
                if (!canAdjust && spreadContainer != null) {
                    ArrayList<ECell> cells = new ArrayList<ECell>(values.size());
                    for (LinkedHashMap<String, Object> e : values) {
                        AreaInfo areaInfo = ebSpreadManager.getAreaInfoByRowCol((Integer)e.get("r"), (Integer)e.get("c"));
                        if (areaInfo == null) continue;
                        ECell cell = areaInfo.getMultiAreaManager().getData().getDataSheet().getECell(areaInfo.getRelativerow(), areaInfo.getRelativecol());
                        ECell tempcell = new ECell();
                        tempcell.setValue(cell.getValue());
                        tempcell.setRow((Integer)e.get("r"));
                        tempcell.setCol((Integer)e.get("c"));
                        cells.add(tempcell);
                    }
                    spreadContainer.updateCellValue2(cells);
                }
                this.plugin.getView().getPageCache().put("isAdjust", "1");
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return canAdjust;
    }

    @Override
    public Map<String, String> getMemberMapByCell(int row, int col, IEbSpreadManager spreadManager) {
        return ReportHelper.getMemberMapByCellFix(spreadManager, row, col);
    }

    private void addToFloatCells(AreaInfo areaInfo, ECell cell, Map<MultiAreaManager, List<ECell>> floatPasteCells, Object val) {
        List cells = floatPasteCells.computeIfAbsent(areaInfo.getMultiAreaManager(), k -> new ArrayList());
        cell.setUserObject("needPasteValue", val);
        cells.add(cell);
    }

    protected ISpreadContainer getspreadContainer() {
        return ((ISpreadBaseSupport)ISpreadBaseSupport.class.cast(this.plugin)).getspreadContainer();
    }

    @Override
    protected IEbSpreadManager getSpreadManager() {
        return ((AbstractReportPlugin)AbstractReportPlugin.class.cast(this.plugin)).getSpreadManager();
    }

    protected SpreadSelector getSpreadSelector() {
        return ((AbstractReportPlugin)AbstractReportPlugin.class.cast(this.plugin)).getSpreadSelector();
    }

    protected IFormView getView() {
        return this.plugin.getView();
    }

    private void clearDimProperty(LinkedHashMap<String, Object> e, MultiAreaManager multiAreaManager) {
        if (e.get("v") != null) {
            return;
        }
        int r = (Integer)e.get("r");
        int c = (Integer)e.get("c");
        boolean isRowPartition = multiAreaManager.getFloatonWhere() == 0;
        String dimNum = DimPropertyHelper.getDimNumByPos(multiAreaManager, r, c, isRowPartition);
        ISheet eSheet = multiAreaManager.getData().getDataSheet();
        Map<String, List<PropertyObj>> propertyMap = multiAreaManager.getDimPropertys();
        List<ECell> propertyCellList = DimPropertyHelper.setCellProperty(r, c, dimNum, null, multiAreaManager, null, !isRowPartition, 1);
        if (propertyCellList != null && propertyCellList.size() > 0) {
            this.getspreadContainer().updateCellValue2(propertyCellList);
        }
    }
}

