/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.analyze;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;

public class DiffAnalyzeScheme
implements Serializable {
    public static final String VALUE_FROM_SECOND_PAGE = "_SECOND_PAGE";
    public static final String PERIOD_OFFSET = "_PERIOD_OFFSET";
    public static final String DIMVIEW = "_DIMVIEW_";
    public static final String BASEVALUE = "basevalue";
    public static final String COMPAREVALUE = "comparevalue";
    public static final String EXPRESSION = "_EXPRESSION";
    public static final String EXPRESSION_DISP = "_EXPRESSION_DISP";
    public static final String DISP_FORMAT = "_DISP_FORMAT";
    public static final String COL_PREFIX = "A";
    public static final String TOP_ITEMS = "TOP_ITEMS";
    public static final String PROP_ID = "id";
    public static final String PROP_NUMBER = "number";
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPE = "type";
    public static final String PROP_CREATOR = "creator";
    public static final String PROP_CREATETIME = "createtime";
    public static final String PROP_MODIFIER = "modifier";
    public static final String PROP_MODIFYTIME = "modifytime";
    public static final String PROP_MODEL = "model";
    public static final String PROP_DATASET = "dataset";
    public static final String PROP_STATUS = "status";
    public static final String PROP_DESC = "desc";
    public static final String PROP_CONFIGJSON = "configjson";
    public static final String PROP_ENTRYENTITY = "entryentity";
    public static final String ENTRY_PROP_ID = "id";
    public static final String ENTRY_PROP_SEQ = "seq";
    public static final String ENTRY_PROP_COLTYPE = "coltype";
    public static final String ENTRY_PROP_COLNAME = "colname";
    public static final String ENTRY_PROP_COLCONFIGJSON = "colconfigjson";
    public static final String ROW_DIMENSION = "row_dimension";
    public static final String DEF_COL_DIMENSION = "def_col_dimension";
    public static final String DEFMEMBERDISPLAY = "defmemberdisplay";
    public static final String DEFEMPTYROWDISPLAY = "defemptyrowdisplay";
    public static final String DEFUNITDISPLAY = "defunitdisplay";
    public static final String METRICDISPLAY = "metricdisplay";
    public static final String METRICDISPLAY_NO_SEP = "metricdisplay_no_sep";
    public static final String HIDE_DIMENSIONDS = "hide_dimensions";
    public static final String PAGE_F7_DIMPREFIX = "ebf7_page_";
    public static final String DEFMEMBER = "defmember";
    private List<DiffAnalyzeColumn> analyzeColumns;
    private String configJson = null;
    private Map<String, Object> configMap = null;
    private DiffAnalyzeConfig config;

    public DiffAnalyzeScheme() {
    }

    public DiffAnalyzeScheme(List<DiffAnalyzeColumn> analyzeColumns) {
        this.analyzeColumns = analyzeColumns;
    }

    public List<DiffAnalyzeColumn> getAnalyzeColumns() {
        return this.analyzeColumns;
    }

    public void setAnalyzeColumns(List<DiffAnalyzeColumn> analyzeColumns) {
        this.analyzeColumns = analyzeColumns;
    }

    public String getConfigJson() {
        return this.configJson;
    }

    public void setConfigJson(String configJson) {
        this.configJson = configJson;
    }

    public Map<String, Object> getConfigMap() {
        if (this.configMap == null) {
            this.configMap = StringUtils.isNotEmpty((CharSequence)this.configJson) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)this.configJson, Map.class) : new HashMap<String, Object>(16);
        }
        return this.configMap;
    }

    public String getRowDimension() {
        String rowDim = (String)this.getConfigMap().get(ROW_DIMENSION);
        if (rowDim == null) {
            rowDim = SysDimensionEnum.Account.getNumber();
        }
        return rowDim;
    }

    public String getDefColDimension() {
        String colDim = (String)this.getConfigMap().get(DEF_COL_DIMENSION);
        if (colDim == null) {
            colDim = SysDimensionEnum.BudgetPeriod.getNumber();
        }
        return colDim;
    }

    public String getDefMemberDisplay() {
        return (String)this.getConfigMap().get(DEFMEMBERDISPLAY);
    }

    public String getDefEmptyrowDisplay() {
        return (String)this.getConfigMap().get(DEFEMPTYROWDISPLAY);
    }

    public String getDefUnitDisplay() {
        return (String)this.getConfigMap().get(DEFUNITDISPLAY);
    }

    public Set<String> getHideDimensions() {
        Object obj = this.getConfigMap().get(HIDE_DIMENSIONDS);
        if (obj instanceof String) {
            return (Set)SerializationUtils.fromJsonString((String)((String)obj), Set.class);
        }
        return new HashSet<String>(16);
    }

    public Long getViewId(String dimNumber) {
        return IDUtils.toLong((Object)this.getConfigMap().get(dimNumber + "viewId"));
    }

    public Map<String, List<Map<String, String>>> getMulF7MemberQuotes() {
        HashMap<String, List<Map<String, String>>> quotes = new HashMap<String, List<Map<String, String>>>(16);
        for (Map.Entry<String, Object> entry : this.getConfigMap().entrySet()) {
            if (!entry.getKey().startsWith(PAGE_F7_DIMPREFIX)) continue;
            String dimNumberLowerCase = entry.getKey().replaceAll(PAGE_F7_DIMPREFIX, "");
            if (!(entry.getValue() instanceof String) || !StringUtils.isNotEmpty((CharSequence)((String)entry.getValue()))) continue;
            List members = (List)SerializationUtils.fromJsonString((String)((String)entry.getValue()), List.class);
            quotes.put(dimNumberLowerCase, members);
        }
        return quotes;
    }

    public DiffAnalyzeConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffAnalyzeConfig config) {
        this.config = config;
    }

    public static class DiffAnalyzeConfig
    implements Serializable {
        private List<String> topItems;
        private String rowDimension = SysDimensionEnum.Account.getNumber();

        public List<String> getTopItems() {
            return this.topItems;
        }

        public void setTopItems(List<String> topItems) {
            this.topItems = topItems;
        }

        public String getRowDimension() {
            return this.rowDimension;
        }

        public void setRowDimension(String rowDimension) {
            this.rowDimension = rowDimension;
        }
    }

    public static class DiffAnalyzeColumn
    implements Serializable {
        private String displayName;
        private String displayFormat;
        private boolean isHidden;
        private IDataRow dataRow;

        public DiffAnalyzeColumn(String displayName, boolean isHidden, IDataRow dataRow) {
            this.displayName = displayName;
            this.isHidden = isHidden;
            this.dataRow = dataRow;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public void setHidden(boolean hidden) {
            this.isHidden = hidden;
        }

        public IDataRow getDataRow() {
            return this.dataRow;
        }

        public void setDataRow(IDataRow dataRow) {
            this.dataRow = dataRow;
        }

        public String getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
        }
    }
}

