/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.analyze;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.QuickAnalyzeActionEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.baseplugin.AbstractSpreadPlugin;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;

public interface IQuickAnalyzeSupport {
    public static final List<String> SINGLE_COL_ACTIONS = Lists.newArrayList((Object[])new String[]{"yearOnYear", "monthOnMonth", "accumulated", "yearAccumulated", "ratioCurRowDMem", "ratioCurColDMem", "ratioCurSheetDMem", "ratioRow", "ratioCol", "ratioSheet", "rankCurRowDMem", "rankCurColDMem", "rankCurSheetDMem", "rankRow", "rankCol", "rankSheet"});
    public static final List<String> DOUBLE_COL_ACTIONS = Lists.newArrayList((Object[])new String[]{"curColCalDiff", "curColCalRatio"});
    public static final List<String> MULTIPLE_COL_ACTIONS = Lists.newArrayList((Object[])new String[]{"curColCalSum", "curColCalMul", "curColCalDiff", "curColCalRatio"});

    default public void yearOnYear(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void monthOnMonth(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void accumulated(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void yearAccumulated(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void ratioCurRowDMem(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void ratioCurColDMem(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void ratioCurSheetDMem(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void ratioRow(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void ratioCol(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void ratioSheet(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void rankCurRowDMem(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void rankCurColDMem(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void rankCurSheetDMem(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void rankRow(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void rankCol(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void rankSheet(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void curColCalSum(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void curColCalMul(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void curColCalDiff(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void curColCalRatio(Object param) {
        this.invokeAction((String)((Map)param).get("invokemethod"));
    }

    default public void curRowCalSum(Object param) {
    }

    default public void curRowCalMul(Object param) {
    }

    default public void curRowCalDiff(Object param) {
    }

    default public void curRowCalRatio(Object param) {
    }

    default public void versionCompare(Object param) {
        Map<String, Long> defaultDimMember;
        Set<String> versionMembers;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_versioncompare");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)(this.getSpreadManager().getModelobj().getId() + ""));
        formShowParameter.setCustomParam("DATASETID", (Object)(this.getTemplateModel().getTemplateBaseInfo().getDatasetID() + ""));
        Map<String, List<String>> compareDimMembers = this.getSelectedColDimMems(this.getSpreadManager(), this.getSpreadSelector());
        if (!compareDimMembers.containsKey(SysDimensionEnum.Version.getNumber()) && (versionMembers = this.getSpreadManager().getAlldimensionWithMembers().get(SysDimensionEnum.Version.getNumber())) != null && versionMembers.size() > 0) {
            compareDimMembers.put(SysDimensionEnum.Version.getNumber(), Collections.singletonList(versionMembers.iterator().next()));
        }
        formShowParameter.setCustomParam("compareDimMembers", (Object)SerializationUtils.toJsonString(compareDimMembers));
        IEbSpreadManager spreadManager = this.getSpreadManager();
        IModelCacheHelper modelCacheHelper = spreadManager.getModelCacheHelper();
        if (modelCacheHelper == null && spreadManager != null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)spreadManager.getModelobj().getId());
        }
        if ((defaultDimMember = this.getDefaultDimMember(spreadManager, modelCacheHelper)) != null) {
            formShowParameter.setCustomParam("defaultDimMember", (Object)SerializationUtils.toJsonString(defaultDimMember));
        }
        if (spreadManager != null && spreadManager.getDimemsionViews() != null) {
            formShowParameter.setCustomParam("dimemsionViews", (Object)SerializationUtils.toJsonString(spreadManager.getDimemsionViews()));
        }
        formShowParameter.setCustomParam("name", (Object)(this.getTemplateModel().getTemplateBaseInfo().getName() + "-" + QuickAnalyzeActionEnum.VERSION_COMPARE.getName()));
        this.getView().showForm(formShowParameter);
    }

    default public void invokeAction(String actionNumber) {
        IEbSpreadManager spreadManager = this.getSpreadManager();
        SpreadSelector selector = this.getSpreadSelector();
        ITemplateModel templateModel = this.getTemplateModel();
        String actionName = QuickAnalyzeActionEnum.getNameByNumber((String)actionNumber);
        if (StringUtils.isEmpty((String)actionName)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fbf\u643a\u5206\u6790\u7c7b\u578b\uff1a%1\u3002", (String)"IQuickAnalyzeSupport_1", (String)"epm-eb-spread", (Object[])new Object[]{actionNumber}));
            return;
        }
        DynamicObject dynamicObject = this.generateSchemeHeader(spreadManager, selector, templateModel);
        int selectColCnt = selector.getEndCol() - selector.getStartCol() + 1;
        if (dynamicObject != null && selectColCnt > 0) {
            dynamicObject.set("name", (Object)(templateModel.getTemplateBaseInfo().getName() + "-" + actionName));
            Long modelId = spreadManager.getModelobj().getId();
            Long dataSetId = templateModel.getTemplateBaseInfo().getDatasetID();
            IModelCacheHelper modelCacheHelper = spreadManager.getModelCacheHelper();
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            }
            if (spreadManager instanceof EbSpreadManager) {
                this.generateSchemeCols_dy((EbSpreadManager)spreadManager, selector, dynamicObject, actionNumber);
            } else if (spreadManager instanceof FixSpreadManager) {
                this.generateSchemeCols_fix((FixSpreadManager)spreadManager, selector, dynamicObject, actionNumber);
            }
            if (dynamicObject.getDynamicObjectCollection("entryentity").isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u5206\u6790\u7684\u6570\u636e\u533a\u57df\u3002", (String)"IQuickAnalyzeSupport_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            IFormView formView = this.getView();
            if (formView != null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_diffanalysis");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(modelId));
                formShowParameter.setCustomParam("eb_dataset", (Object)String.valueOf(dataSetId));
                formShowParameter.setCustomParam("eb_diffanalyzescheme", (Object)dynamicObject.getString("id"));
                Map<String, Long> defaultDimMember = this.getDefaultDimMember(spreadManager, modelCacheHelper);
                if (defaultDimMember != null) {
                    formShowParameter.setCustomParam("defaultDimMember", (Object)SerializationUtils.toJsonString(defaultDimMember));
                }
                if (spreadManager.getDimemsionViews() != null) {
                    formShowParameter.setCustomParam("dimemsionViews", (Object)SerializationUtils.toJsonString(spreadManager.getDimemsionViews()));
                }
                formView.showForm(formShowParameter);
            }
        }
    }

    default public Map<String, List<String>> getSelectedColDimMems(IEbSpreadManager spreadManager, SpreadSelector selector) {
        LinkedHashMap<String, List<String>> selectedColDimMems;
        block10: {
            block9: {
                selectedColDimMems = new LinkedHashMap<String, List<String>>();
                if (!(spreadManager instanceof EbSpreadManager)) break block9;
                EbSpreadManager ebSpreadManager = (EbSpreadManager)spreadManager;
                List<String> colpartitionDims = ebSpreadManager.getColpartitionDims();
                List<List<CellDimMember>> colpartitionDimMems = ebSpreadManager.getColpartitionDimMems();
                for (int i = selector.getStartCol(); i <= selector.getEndCol(); ++i) {
                    List<CellDimMember> cellDimMembers = colpartitionDimMems.get(i);
                    if (cellDimMembers == null) continue;
                    for (int j = 0; j < cellDimMembers.size(); ++j) {
                        if (cellDimMembers.get(j) == null) continue;
                        LinkedList<String> dimMems = (LinkedList<String>)selectedColDimMems.get(colpartitionDims.get(j));
                        if (dimMems == null) {
                            dimMems = new LinkedList<String>();
                            selectedColDimMems.put(colpartitionDims.get(j), dimMems);
                        }
                        dimMems.add(cellDimMembers.get(j).getDimMemberNumber());
                    }
                }
                break block10;
            }
            if (!(spreadManager instanceof FixSpreadManager)) break block10;
            FixSpreadManager fixSpreadManager = (FixSpreadManager)spreadManager;
            LinkedList<MultiAreaManager> qualifiedAreas = new LinkedList<MultiAreaManager>();
            for (MultiAreaManager multiAreaManager : fixSpreadManager.getMultiAreaManager()) {
                boolean onlyAccountInRow;
                boolean bl = multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Account.getNumber()) && multiAreaManager.getRowpartitionDims().size() == (multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber()) ? 2 : 1) ? true : (onlyAccountInRow = false);
                if (!onlyAccountInRow) continue;
                MultiAreaManager.ValueArea valueStart = multiAreaManager.getValueAreaStart();
                int valueColStart = valueStart.getData_col_start();
                int valueColEnd = multiAreaManager.getAreaRange().getX_end();
                if (selector.getStartCol() < valueColStart || selector.getEndCol() > valueColEnd) continue;
                qualifiedAreas.add(multiAreaManager);
            }
            if (qualifiedAreas.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u5206\u6790\u7684\u6570\u636e\u533a\u57df\u3002", (String)"IQuickAnalyzeSupport_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                return null;
            }
            for (int i = selector.getStartCol(); i <= selector.getEndCol(); ++i) {
                for (MultiAreaManager multiAreaManager : qualifiedAreas) {
                    int dataColStart;
                    Map<String, CellDimMember> cellDimMembers = multiAreaManager.getColpartitionDimMemsByCol(i - (dataColStart = multiAreaManager.getValueAreaStart().getData_col_start()));
                    if (cellDimMembers == null) continue;
                    for (Map.Entry<String, CellDimMember> entry : cellDimMembers.entrySet()) {
                        String dimNumber = entry.getKey();
                        if (dimNumber == null || entry.getValue() == null) continue;
                        LinkedList<String> dimMems = (LinkedList<String>)selectedColDimMems.get(dimNumber);
                        if (dimMems == null) {
                            dimMems = new LinkedList<String>();
                            selectedColDimMems.put(dimNumber, dimMems);
                        }
                        dimMems.add(entry.getValue().getDimMemberNumber());
                    }
                }
            }
        }
        return selectedColDimMems;
    }

    default public void generateSchemeCols_fix(FixSpreadManager fixSpreadManager, SpreadSelector selector, DynamicObject dynamicObject, String actionNumber) {
        Object pvMetrics;
        LinkedList<MultiAreaManager> qualifiedAreas = new LinkedList<MultiAreaManager>();
        IModelCacheHelper modelCacheHelper = fixSpreadManager.getModelCacheHelper();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)fixSpreadManager.getModelobj().getId());
        }
        HashSet numberMetrics = new HashSet(16);
        modelCacheHelper.getMembers(null, SysDimensionEnum.Metric.getNumber()).forEach(member -> {
            if (MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype()) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(member.getDatatype())) {
                numberMetrics.add(member.getNumber());
            }
        });
        boolean metricInPageView = fixSpreadManager.getPageViewDims().containsKey(SysDimensionEnum.Metric.getNumber());
        if (metricInPageView && (pvMetrics = fixSpreadManager.getAlldimensionWithMembers().get(SysDimensionEnum.Metric.getNumber())) != null && pvMetrics.size() > 0 && !numberMetrics.contains(pvMetrics.iterator().next())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u5206\u6790\u7684\u6570\u636e\u533a\u57df\u3002", (String)"IQuickAnalyzeSupport_2", (String)"epm-eb-spread", (Object[])new Object[0]));
            return;
        }
        block0: for (MultiAreaManager multiAreaManager : fixSpreadManager.getMultiAreaManager()) {
            boolean onlyAccountInRow;
            boolean bl = multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Account.getNumber()) && multiAreaManager.getRowpartitionDims().size() == (multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber()) ? 2 : 1) ? true : (onlyAccountInRow = false);
            if (!onlyAccountInRow) continue;
            MultiAreaManager.ValueArea valueStart = multiAreaManager.getValueAreaStart();
            int valueColStart = valueStart.getData_col_start();
            int valueColEnd = multiAreaManager.getAreaRange().getX_end();
            int valueRowStart = valueStart.getData_row_start();
            int valueRowEnd = multiAreaManager.getAreaRange().getY_end();
            if (selector.getStartCol() < valueColStart || selector.getEndCol() > valueColEnd) continue;
            if (!metricInPageView && multiAreaManager.getColpartitionDims().contains(SysDimensionEnum.Metric.getNumber())) {
                for (int i = selector.getStartCol(); i <= selector.getEndCol(); ++i) {
                    CellDimMember metricDimMem;
                    int dataColStart = multiAreaManager.getValueAreaStart().getData_col_start();
                    Map<String, CellDimMember> cellDimMembers = multiAreaManager.getColpartitionDimMemsByCol(i - dataColStart);
                    if (cellDimMembers == null || (metricDimMem = cellDimMembers.get(SysDimensionEnum.Metric.getNumber())) == null || !numberMetrics.contains(metricDimMem.getDimMemberNumber())) continue;
                    qualifiedAreas.add(multiAreaManager);
                    continue block0;
                }
                continue;
            }
            qualifiedAreas.add(multiAreaManager);
        }
        if (qualifiedAreas.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u5206\u6790\u7684\u6570\u636e\u533a\u57df\u3002", (String)"IQuickAnalyzeSupport_2", (String)"epm-eb-spread", (Object[])new Object[0]));
            return;
        }
        int colIndex = 0;
        int selectColCnt = selector.getEndCol() - selector.getStartCol() + 1;
        long[] entryIds = DBServiceHelper.genLongIds((String)"t_eb_analyzeschemecols", (int)(selectColCnt * 2 * qualifiedAreas.size()));
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<String> colNames = new HashSet<String>(16);
        for (int i = selector.getStartCol(); i <= selector.getEndCol(); ++i) {
            for (MultiAreaManager multiAreaManager : qualifiedAreas) {
                CellDimMember metricDimMem;
                int dataColStart = multiAreaManager.getValueAreaStart().getData_col_start();
                List<String> colpartitionDims = multiAreaManager.getColpartitionDims();
                Map<String, PageViewDimMember> pvDimMembers = multiAreaManager.getAreaPageViewDims();
                Map<String, CellDimMember> cellDimMembers = multiAreaManager.getColpartitionDimMemsByCol(i - dataColStart);
                if (cellDimMembers == null || (metricDimMem = cellDimMembers.get(SysDimensionEnum.Metric.getNumber())) != null && !numberMetrics.contains(metricDimMem.getDimMemberNumber())) continue;
                String colName = null;
                StringBuilder sb = new StringBuilder();
                HashMap<String, String> dataColConfigMap = new HashMap<String, String>(16);
                if (pvDimMembers != null) {
                    for (Map.Entry<String, PageViewDimMember> pvdm : pvDimMembers.entrySet()) {
                        if (pvdm.getKey() == null || pvdm.getValue() == null) continue;
                        dataColConfigMap.put(pvdm.getKey(), pvdm.getValue().getNumber());
                    }
                }
                for (int j = 0; j < cellDimMembers.size(); ++j) {
                    Long viewId = DimensionViewServiceHelper.getViewId(fixSpreadManager.getDimemsionViews(), (String)colpartitionDims.get(j), (String)multiAreaManager.getAreaIndex());
                    Member cacheMem = modelCacheHelper.getMember(colpartitionDims.get(j), viewId, cellDimMembers.get(colpartitionDims.get(j)).getDimMemberNumber());
                    if (cacheMem == null) continue;
                    sb.append(cacheMem.getName()).append("-");
                    dataColConfigMap.put(colpartitionDims.get(j), cacheMem.getNumber());
                }
                if (sb.length() <= 0 || colNames.contains(colName = sb.substring(0, sb.length() - 1))) continue;
                colNames.add(colName);
                DynamicObject dataCol = entryentity.addNew();
                dataCol.set("id", (Object)entryIds[colIndex]);
                dataCol.set("seq", (Object)colIndex);
                dataCol.set("coltype", (Object)DataRowEnum.DATA.getIndex());
                dataCol.set("colname", (Object)colName);
                dataCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(dataColConfigMap));
                ++colIndex;
                if (!SINGLE_COL_ACTIONS.contains(actionNumber)) continue;
                this.singleColAction(actionNumber, entryentity, entryIds[colIndex], colIndex, dataCol);
                ++colIndex;
            }
        }
        if (DOUBLE_COL_ACTIONS.contains(actionNumber) && entryentity.size() == 2) {
            this.doubleColAction(actionNumber, entryentity, entryIds[colIndex], colIndex);
            ++colIndex;
        } else if (MULTIPLE_COL_ACTIONS.contains(actionNumber) && entryentity.size() >= 2) {
            this.multipleColAction(actionNumber, entryentity, entryIds[colIndex], colIndex);
            ++colIndex;
        }
    }

    default public void generateSchemeCols_dy(EbSpreadManager ebSpreadManager, SpreadSelector selector, DynamicObject dynamicObject, String actionNumber) {
        Set<String> metrics;
        if (ebSpreadManager == null || selector == null || dynamicObject == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)ebSpreadManager.getModelobj().getId());
        }
        HashSet numberMetrics = new HashSet(16);
        modelCacheHelper.getMembers(null, SysDimensionEnum.Metric.getNumber()).forEach(member -> {
            if (MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype()) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(member.getDatatype())) {
                numberMetrics.add(member.getNumber());
            }
        });
        boolean isMetricInRow = ebSpreadManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber());
        if (isMetricInRow && (metrics = ebSpreadManager.getAlldimensionWithMembers().get(SysDimensionEnum.Metric.getNumber())) != null && !metrics.stream().anyMatch(e -> numberMetrics.contains(e))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u5206\u6790\u7684\u6570\u636e\u533a\u57df\u3002", (String)"IQuickAnalyzeSupport_2", (String)"epm-eb-spread", (Object[])new Object[0]));
            return;
        }
        List<String> colpartitionDims = ebSpreadManager.getColpartitionDims();
        List<List<CellDimMember>> colpartitionDimMems = ebSpreadManager.getColpartitionDimMems();
        int colIndex = 0;
        int selectColCnt = selector.getEndCol() - selector.getStartCol() + 1;
        long[] entryIds = DBServiceHelper.genLongIds((String)"t_eb_analyzeschemecols", (int)(selectColCnt * 2));
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<String> colNames = new HashSet<String>(16);
        for (int i = selector.getStartCol(); i <= selector.getEndCol(); ++i) {
            List<CellDimMember> cellDimMembers = colpartitionDimMems.get(i);
            if (cellDimMembers == null) continue;
            String colName = null;
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> dataColConfigMap = new HashMap<String, String>(cellDimMembers.size());
            for (int j = 0; j < cellDimMembers.size(); ++j) {
                Member cacheMem = modelCacheHelper.getMemberByAnyView(ebSpreadManager.getBusModelid(), colpartitionDims.get(j), cellDimMembers.get(j).getDimMemberNumber());
                if (cacheMem == null) continue;
                if (SysDimensionEnum.Metric.getNumber().equals(cacheMem.getDimension().getNumber()) && !numberMetrics.contains(cacheMem.getNumber())) {
                    sb = null;
                    break;
                }
                sb.append(cacheMem.getName()).append("-");
                dataColConfigMap.put(colpartitionDims.get(j), cacheMem.getNumber());
            }
            if (sb == null || sb.length() <= 0 || colNames.contains(colName = sb.substring(0, sb.length() - 1))) continue;
            colNames.add(colName);
            DynamicObject dataCol = entryentity.addNew();
            dataCol.set("id", (Object)entryIds[colIndex]);
            dataCol.set("seq", (Object)colIndex);
            dataCol.set("coltype", (Object)DataRowEnum.DATA.getIndex());
            dataCol.set("colname", (Object)colName);
            dataCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(dataColConfigMap));
            ++colIndex;
            if (!SINGLE_COL_ACTIONS.contains(actionNumber)) continue;
            this.singleColAction(actionNumber, entryentity, entryIds[colIndex], colIndex, dataCol);
            ++colIndex;
        }
        if (DOUBLE_COL_ACTIONS.contains(actionNumber) && entryentity.size() == 2) {
            this.doubleColAction(actionNumber, entryentity, entryIds[colIndex], colIndex);
            ++colIndex;
        } else if (MULTIPLE_COL_ACTIONS.contains(actionNumber) && entryentity.size() >= 2) {
            this.multipleColAction(actionNumber, entryentity, entryIds[colIndex], colIndex);
            ++colIndex;
        }
    }

    default public void singleColAction(String actionNumber, DynamicObjectCollection entryentity, Long entryId, int colIndex, DynamicObject dataCol) {
        DynamicObject calCol = entryentity.addNew();
        calCol.set("id", (Object)entryId);
        calCol.set("seq", (Object)colIndex);
        calCol.set("coltype", (Object)DataRowEnum.CUSTOM.getIndex());
        calCol.set("colname", (Object)String.format(QuickAnalyzeActionEnum.getNameByNumber((String)actionNumber) + "(%s)", dataCol.getString("colname")));
        HashMap<String, String> calColConfigMap = new HashMap<String, String>(2);
        calColConfigMap.put("_EXPRESSION", String.format(actionNumber + "(%s)", "A" + dataCol.get("id")));
        calColConfigMap.put("_EXPRESSION_DISP", (String)calCol.get("colname"));
        if (QuickAnalyzeActionEnum.YEAR_ON_YEAR.getNumber().equals(actionNumber) || QuickAnalyzeActionEnum.MONTH_ON_MONTH.getNumber().equals(actionNumber)) {
            calColConfigMap.put("_DISP_FORMAT", "#,##0.00%");
        }
        calCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(calColConfigMap));
    }

    default public void doubleColAction(String actionNumber, DynamicObjectCollection entryentity, Long entryId, int colIndex) {
        if (entryentity == null || entryentity.size() != 2) {
            return;
        }
        DynamicObject col1 = (DynamicObject)entryentity.get(0);
        DynamicObject col2 = (DynamicObject)entryentity.get(1);
        DynamicObject calCol = entryentity.addNew();
        calCol.set("id", (Object)entryId);
        calCol.set("seq", (Object)colIndex);
        calCol.set("coltype", (Object)DataRowEnum.CUSTOM.getIndex());
        if (QuickAnalyzeActionEnum.CURCOL_CAL_DIFF.getNumber().equals(actionNumber)) {
            calCol.set("colname", (Object)String.format("%s-%s", col1.getString("colname"), col2.getString("colname")));
            HashMap<String, String> calColConfigMap = new HashMap<String, String>(2);
            calColConfigMap.put("_EXPRESSION", String.format("%s-%s", "A" + col1.get("id"), "A" + col2.get("id")));
            calColConfigMap.put("_EXPRESSION_DISP", calCol.getString("colname"));
            calCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(calColConfigMap));
        } else if (QuickAnalyzeActionEnum.CURCOL_CAL_RATIO.getNumber().equals(actionNumber)) {
            calCol.set("colname", (Object)String.format("(%s-%s)/ %s", col1.getString("colname"), col2.getString("colname"), col2.getString("colname")));
            HashMap<String, String> calColConfigMap = new HashMap<String, String>(3);
            calColConfigMap.put("_EXPRESSION", String.format("(%s-%s)/ %s", "A" + col1.get("id"), "A" + col2.get("id"), "A" + col2.get("id")));
            calColConfigMap.put("_EXPRESSION_DISP", calCol.getString("colname"));
            calColConfigMap.put("_DISP_FORMAT", "0.00%");
            calCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(calColConfigMap));
        } else {
            throw new KDBizException("Not supported double col action: " + actionNumber);
        }
    }

    default public void multipleColAction(String actionNumber, DynamicObjectCollection entryentity, long entryId, int colIndex) {
        if (entryentity == null || entryentity.size() < 2) {
            return;
        }
        boolean sum = QuickAnalyzeActionEnum.CURCOL_CAL_SUM.getNumber().equals(actionNumber);
        boolean mul = QuickAnalyzeActionEnum.CURCOL_CAL_MUL.getNumber().equals(actionNumber);
        if (sum || mul) {
            StringBuilder sb_name = new StringBuilder();
            StringBuilder sb_expr = new StringBuilder();
            for (DynamicObject col : entryentity) {
                sb_name.append(col.getString("colname")).append(sum ? "+" : "*");
                sb_expr.append("A").append(col.get("id")).append(sum ? "+" : "*");
            }
            if (sb_name.length() > 0 && sb_expr.length() > 0) {
                DynamicObject calCol = entryentity.addNew();
                calCol.set("id", (Object)entryId);
                calCol.set("seq", (Object)colIndex);
                calCol.set("coltype", (Object)DataRowEnum.CUSTOM.getIndex());
                calCol.set("colname", (Object)sb_name.substring(0, sb_name.length() - 1));
                HashMap<String, String> calColConfigMap = new HashMap<String, String>(2);
                calColConfigMap.put("_EXPRESSION", sb_expr.substring(0, sb_expr.length() - 1));
                calColConfigMap.put("_EXPRESSION_DISP", (String)calCol.get("colname"));
                calCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(calColConfigMap));
            }
        } else {
            throw new KDBizException("Not supported multiple col action: " + actionNumber);
        }
    }

    default public IEbSpreadManager getSpreadManager() {
        if (this instanceof AbstractSpreadPlugin) {
            return ((AbstractSpreadPlugin)((Object)this)).getSpreadManager();
        }
        return null;
    }

    default public SpreadSelector getSpreadSelector() {
        if (this instanceof AbstractSpreadPlugin) {
            return ((AbstractSpreadPlugin)((Object)this)).getSpreadSelector();
        }
        return null;
    }

    default public ISpreadContainer getSpreadContainer() {
        if (this instanceof AbstractSpreadPlugin) {
            return ((AbstractSpreadPlugin)((Object)this)).getspreadContainer();
        }
        return null;
    }

    default public ITemplateModel getTemplateModel() {
        if (this instanceof AbstractReportPlugin) {
            return ((AbstractReportPlugin)this).getTemplateModel();
        }
        return null;
    }

    default public IFormView getView() {
        if (this instanceof AbstractFormPlugin) {
            return ((AbstractFormPlugin)this).getView();
        }
        return null;
    }

    default public DynamicObject generateSchemeHeader(IEbSpreadManager spreadManager, SpreadSelector selector, ITemplateModel templateModel) {
        if (spreadManager != null && selector != null && templateModel != null) {
            String userId = RequestContext.get().getUserId();
            Date now = TimeServiceHelper.now();
            long id = DBServiceHelper.genGlobalLongId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("number", (Object)("Q-" + id));
            dynamicObject.set("type", (Object)1);
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)now);
            dynamicObject.set("model", (Object)spreadManager.getModelobj().getId());
            dynamicObject.set("dataset", (Object)templateModel.getTemplateBaseInfo().getDatasetID());
            Map<String, Collection<String>> quoteMembers = templateModel.retrieveQuoteMembers();
            Collection<String> topItems = null;
            if (quoteMembers != null && (topItems = quoteMembers.get(SysDimensionEnum.Account.getNumber())) != null) {
                ArrayList<String> sorted = new ArrayList<String>(topItems);
                Collections.sort(sorted);
                StringBuilder sb = new StringBuilder();
                for (String topItem : sorted) {
                    sb.append(topItem).append(",");
                }
                if (sb.length() > 0) {
                    HashMap configMap = Maps.newHashMapWithExpectedSize((int)1);
                    configMap.put("TOP_ITEMS", sb.substring(0, sb.length() - 1));
                    dynamicObject.set("configjson", (Object)SerializationUtils.toJsonString((Object)configMap));
                }
            }
            return dynamicObject;
        }
        return null;
    }

    default public Map<String, Long> getDefaultDimMember(IEbSpreadManager spreadManager, IModelCacheHelper modelCacheHelper) {
        if (spreadManager != null && spreadManager.getAlldimensionWithMembers() != null) {
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)spreadManager.getModelobj().getId());
            }
            HashMap<String, Long> defaultDimMember = new HashMap<String, Long>(spreadManager.getAlldimensionWithMembers().size());
            Map<String, Long> dimViews = spreadManager.getDimemsionViews();
            for (Map.Entry<String, Set<String>> entry : spreadManager.getAlldimensionWithMembers().entrySet()) {
                if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
                String dimNumber = entry.getKey();
                String memNumber = entry.getValue().iterator().next();
                Member cacheMember = modelCacheHelper.getMember(dimNumber, dimViews.get(dimNumber), memNumber);
                if (cacheMember == null) continue;
                defaultDimMember.put(dimNumber, cacheMember.getId());
            }
            return defaultDimMember;
        }
        return null;
    }
}

