/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.analyze;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.enums.QuickAnalyzeActionEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.model.MenuItem;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class QuickAnalyzeMenuList {
    private static final String LV1MENU_PERIOD = "LV1MENU_PERIOD";
    private static final String LV1MENU_RATIO = "LV1MENU_RATIO";
    private static final String LV1MENU_RANK = "LV1MENU_RANK";
    private static final String LV1MENU_CALCOL = "LV1MENU_CALCOL";
    private static final String LV1MENU_CALROW = "LV1MENU_CALROW";
    private static final String LV1MENU_VERSION_COMPARE = QuickAnalyzeActionEnum.VERSION_COMPARE.getNumber();
    private static final String[] LV1MENUS = new String[]{"LV1MENU_PERIOD", "LV1MENU_RATIO", "LV1MENU_RANK", "LV1MENU_CALCOL", "LV1MENU_CALROW", LV1MENU_VERSION_COMPARE};
    private IEbSpreadManager spreadManager;
    private SpreadSelector selector;
    private ISpreadContainer spreadContainer;

    public QuickAnalyzeMenuList(IEbSpreadManager spreadManager, SpreadSelector selector, ISpreadContainer spreadContainer) {
        this.spreadManager = spreadManager;
        this.selector = selector;
        this.spreadContainer = spreadContainer;
    }

    public void displayMenuItems() {
        this.spreadContainer.deleteContextMenuItems(LV1MENUS);
        ContextMenuWorkArea contextMenuWorkArea = new ContextMenuWorkArea();
        contextMenuWorkArea.setViewport(true);
        contextMenuWorkArea.setColHeader(true);
        contextMenuWorkArea.setRowHeader(true);
        this.spreadContainer.addContextMenuItems(this.build(), contextMenuWorkArea);
    }

    public List<MenuItem> build() {
        if (this.spreadManager != null && this.selector != null) {
            if (this.spreadManager instanceof EbSpreadManager) {
                return this.dyBuild((EbSpreadManager)this.spreadManager, this.selector);
            }
            if (this.spreadManager instanceof FixSpreadManager) {
                return this.fixBuild((FixSpreadManager)this.spreadManager, this.selector);
            }
        }
        return null;
    }

    private List<MenuItem> fixBuild(FixSpreadManager fixSpreadManager, SpreadSelector selector) {
        LinkedList<MenuItem> menuItems = null;
        if (fixSpreadManager != null && selector != null && fixSpreadManager.getMultiAreaManager() != null) {
            int selectColCnt = selector.getEndCol() - selector.getStartCol() + 1;
            int selectRowCnt = selector.getEndRow() - selector.getStartRow() + 1;
            boolean colSelected = selectRowCnt >= selectColCnt;
            boolean rowSelected = !colSelected;
            LinkedList<MultiAreaManager> qualifiedAreas = new LinkedList<MultiAreaManager>();
            for (MultiAreaManager multiAreaManager : fixSpreadManager.getMultiAreaManager()) {
                boolean onlyAccountInRow;
                boolean bl = multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Account.getNumber()) && multiAreaManager.getRowpartitionDims().size() == (multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber()) ? 2 : 1) ? true : (onlyAccountInRow = false);
                if (!onlyAccountInRow) continue;
                MultiAreaManager.ValueArea valueStart = multiAreaManager.getValueAreaStart();
                int valueColStart = valueStart.getData_col_start();
                int valueColEnd = multiAreaManager.getAreaRange().getX_end();
                int valueRowStart = valueStart.getData_row_start();
                int valueRowEnd = multiAreaManager.getAreaRange().getY_end();
                if (colSelected && (selector.getStartCol() < valueColStart || selector.getEndCol() > valueColEnd) || rowSelected && (selector.getStartRow() < valueRowStart || selector.getEndRow() > valueRowEnd)) continue;
                qualifiedAreas.add(multiAreaManager);
            }
            if (qualifiedAreas.isEmpty()) {
                return null;
            }
            menuItems = new LinkedList<MenuItem>();
            if (colSelected) {
                menuItems.add(this.getPeriodMenuItem());
            }
        }
        return menuItems;
    }

    private List<MenuItem> dyBuild(EbSpreadManager ebSpreadManager, SpreadSelector selector) {
        LinkedList<MenuItem> menuItems = null;
        if (ebSpreadManager != null && selector != null) {
            boolean rowSelected;
            boolean onlyAccountInRow;
            boolean bl = ebSpreadManager.getRowpartitionDims().contains(SysDimensionEnum.Account.getNumber()) && ebSpreadManager.getRowpartitionDims().size() == (ebSpreadManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber()) ? 2 : 1) ? true : (onlyAccountInRow = false);
            if (!onlyAccountInRow) {
                return null;
            }
            ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
            int maxRows = sheet.getRealMaxRows();
            int maxCols = sheet.getRealMaxCols();
            boolean colSelected = maxRows == selector.getEndRow() - selector.getStartRow() + 1;
            boolean bl2 = rowSelected = maxCols == selector.getEndCol() - selector.getStartCol() + 1;
            if (!colSelected && !rowSelected) {
                return null;
            }
            if (colSelected && selector.getStartCol() < sheet.getValueAreaColStart() || rowSelected && selector.getStartRow() < sheet.getValueAreaRowStart()) {
                return null;
            }
            menuItems = new LinkedList<MenuItem>();
            if (colSelected) {
                menuItems.add(this.getPeriodMenuItem());
            }
        }
        return menuItems;
    }

    private MenuItem getPeriodMenuItem() {
        MenuItem periodMenu = new MenuItem(LV1MENU_PERIOD, ResManager.loadKDString((String)"\u671f\u95f4\u6bd4\u8f83", (String)"DiffMenuList_1", (String)"epm-eb-spread", (Object[])new Object[0]));
        periodMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.YEAR_ON_YEAR.getNumber(), QuickAnalyzeActionEnum.YEAR_ON_YEAR.getName()));
        periodMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.MONTH_ON_MONTH.getNumber(), QuickAnalyzeActionEnum.MONTH_ON_MONTH.getName()));
        return periodMenu;
    }

    private MenuItem getRatioMenuItem() {
        MenuItem ratioMenu = new MenuItem(LV1MENU_RATIO, ResManager.loadKDString((String)"\u5360\u6bd4", (String)"DiffMenuList_2", (String)"epm-eb-spread", (Object[])new Object[0]));
        ratioMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RATIO_CURROW_DMEM.getNumber(), QuickAnalyzeActionEnum.RATIO_CURROW_DMEM.getName()));
        ratioMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RATIO_CURCOL_DMEM.getNumber(), QuickAnalyzeActionEnum.RATIO_CURCOL_DMEM.getName()));
        ratioMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RATIO_CURSHEET_DMEM.getNumber(), QuickAnalyzeActionEnum.RATIO_CURSHEET_DMEM.getName()));
        ratioMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RATIO_ROW.getNumber(), QuickAnalyzeActionEnum.RATIO_ROW.getName()));
        ratioMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RATIO_COL.getNumber(), QuickAnalyzeActionEnum.RATIO_COL.getName()));
        ratioMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RATIO_SHEET.getNumber(), QuickAnalyzeActionEnum.RATIO_SHEET.getName()));
        return ratioMenu;
    }

    private MenuItem getColCalMenuItem(int cnt) {
        MenuItem calColMenu = new MenuItem(LV1MENU_CALCOL, ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8fd0\u7b97", (String)"DiffMenuList_3", (String)"epm-eb-spread", (Object[])new Object[0]));
        calColMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURCOL_CAL_SUM.getNumber(), QuickAnalyzeActionEnum.CURCOL_CAL_SUM.getName()));
        calColMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURCOL_CAL_MUL.getNumber(), QuickAnalyzeActionEnum.CURCOL_CAL_MUL.getName()));
        if (cnt == 2) {
            calColMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURCOL_CAL_DIFF.getNumber(), QuickAnalyzeActionEnum.CURCOL_CAL_DIFF.getName()));
            calColMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURCOL_CAL_RATIO.getNumber(), QuickAnalyzeActionEnum.CURCOL_CAL_RATIO.getName()));
        }
        return calColMenu;
    }

    private MenuItem getRowCalMenuItem(int cnt) {
        MenuItem calRowMenu = new MenuItem(LV1MENU_CALROW, ResManager.loadKDString((String)"\u5f53\u524d\u884c\u8fd0\u7b97", (String)"DiffMenuList_4", (String)"epm-eb-spread", (Object[])new Object[0]));
        calRowMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURROW_CAL_SUM.getNumber(), QuickAnalyzeActionEnum.CURROW_CAL_SUM.getName()));
        calRowMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURROW_CAL_MUL.getNumber(), QuickAnalyzeActionEnum.CURROW_CAL_MUL.getName()));
        if (cnt == 2) {
            calRowMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURROW_CAL_DIFF.getNumber(), QuickAnalyzeActionEnum.CURROW_CAL_DIFF.getName()));
            calRowMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.CURROW_CAL_RATIO.getNumber(), QuickAnalyzeActionEnum.CURROW_CAL_RATIO.getName()));
        }
        return calRowMenu;
    }

    private MenuItem getRankMenuItem() {
        MenuItem rankMenu = new MenuItem(LV1MENU_RANK, ResManager.loadKDString((String)"\u6392\u540d", (String)"DiffMenuList_5", (String)"epm-eb-spread", (Object[])new Object[0]));
        rankMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RANK_CURCOL_DMEM.getNumber(), QuickAnalyzeActionEnum.RANK_CURCOL_DMEM.getName()));
        rankMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RANK_CURROW_DMEM.getNumber(), QuickAnalyzeActionEnum.RANK_CURROW_DMEM.getName()));
        rankMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RANK_CURSHEET_DMEM.getNumber(), QuickAnalyzeActionEnum.RANK_CURSHEET_DMEM.getName()));
        rankMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RANK_COL.getNumber(), QuickAnalyzeActionEnum.RANK_COL.getName()));
        rankMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RANK_ROW.getNumber(), QuickAnalyzeActionEnum.RANK_ROW.getName()));
        rankMenu.addSubMenuItem(new MenuItem(QuickAnalyzeActionEnum.RANK_SHEET.getNumber(), QuickAnalyzeActionEnum.RANK_SHEET.getName()));
        return rankMenu;
    }

    private MenuItem getVersionCompareMenuItem() {
        return new MenuItem(QuickAnalyzeActionEnum.VERSION_COMPARE.getNumber(), QuickAnalyzeActionEnum.VERSION_COMPARE.getName());
    }
}

