/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.baseplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.event.SpreadActionListener;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.listener.ISpreadBaseSupport;
import kd.epm.eb.spread.template.cache.TemplateCache;
import kd.epm.eb.spread.template.spread.IReportModelSupport;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractSpreadPlugin
extends AbstractFormPlugin
implements IReportModelSupport,
SpreadActionListener,
ISpreadBaseSupport,
CommonMethod {
    protected IEbSpreadManager ebSpreadManager = null;
    protected ISpreadContainer spreadContainer = null;
    private SpreadSelector spreadSelector = null;
    private static final String SPREAD_SELECTOR_CACHE_KEY = "spread_selector_cache_key";
    public static final String SPREAD_MANANGER_CACHE_KEY = "spread_mananger_cache_key";
    private static final Log logger = LogFactory.getLog(AbstractSpreadPlugin.class);
    protected boolean isCacheSpreadManager = false;
    protected Set<Integer> refreshRows;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.setBgMarkOnSetView(formView);
    }

    public void initialize() {
        super.initialize();
        this.initService();
    }

    public void initService() {
        this.getView().addService(ISpreadAction.class, this.getSpreadDataModelService());
    }

    protected Object getSpreadDataModelService() {
        return new SpreadJsAction(this, this.getSpreadKey());
    }

    @Override
    public IEbSpreadManager getSpreadManager() {
        if (this.ebSpreadManager != null) {
            return this.ebSpreadManager;
        }
        String serial = this.getPageCache().getBigObject(SPREAD_MANANGER_CACHE_KEY);
        if (StringUtils.isNotEmpty((String)serial)) {
            this.ebSpreadManager = EbSpreadManagerSerializerUtil.read(serial);
        }
        return this.ebSpreadManager;
    }

    @Override
    public void setEbSpreadManager(IEbSpreadManager ebSpreadManager) {
        this.ebSpreadManager = ebSpreadManager;
    }

    public void cacheSpreadManager(boolean isDefer) {
        block4: {
            if (isDefer) {
                this.isCacheSpreadManager = true;
            } else {
                try {
                    this.getPageCache().putBigObject(SPREAD_MANANGER_CACHE_KEY, this.ebSpreadManager == null ? null : EbSpreadManagerSerializerUtil.toJson(this.ebSpreadManager));
                }
                catch (KDException e) {
                    if (e.getErrorCode() == null || !"bos.redisCacheOverMaxSize".equals(e.getErrorCode().getCode())) break block4;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u7f29\u5c0f\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u589e\u52a0\u7cfb\u7edf\u7f13\u5b58\u6700\u5927\u503c\u9650\u5236\u3002", (String)"EbSpreadManager_2", (String)"epm-eb-spread", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public void cacheSpreadManager() {
        this.cacheSpreadManager(false);
    }

    public String getSpreadManagerSerial() {
        if (this.ebSpreadManager == null) {
            return this.getPageCache().getBigObject(SPREAD_MANANGER_CACHE_KEY);
        }
        return EbSpreadManagerSerializerUtil.toJson(this.ebSpreadManager);
    }

    @Override
    public ISpreadContainer getspreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
        }
        return this.spreadContainer;
    }

    @Override
    public SpreadSelector getSpreadSelector() {
        String serial;
        if (this.spreadSelector == null && StringUtils.isNotEmpty((String)(serial = this.getPageCache().get(SPREAD_SELECTOR_CACHE_KEY)))) {
            this.spreadSelector = (SpreadSelector)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return this.spreadSelector;
    }

    @Override
    public void setSpreadSelector(SpreadSelector spreadSelector) {
        this.spreadSelector = spreadSelector;
        this.cacheSpreadSelector();
    }

    @Override
    public void cacheSpreadSelector() {
        if (this.spreadSelector == null) {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, null);
        } else {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, ObjectSerialUtil.toByteSerialized((Object)this.spreadSelector));
        }
    }

    @Override
    public void cellClick(SpreadSelector selector) {
    }

    @Override
    public void cellValueUpdate(CellValueEvent cellValueEvent) {
    }

    protected void cacheRefreshRows(OlapQuerySync.ViewArea viewArea) {
        this.getRefreshedRows();
        for (int i = viewArea.getStartrow(); i <= viewArea.getEndrow(); ++i) {
            this.refreshRows.add(i);
        }
        this.getPageCache().put("refreshDataRows", SerializationUtils.toJsonString(this.refreshRows));
    }

    public void cacheRefreshRows(int startRow, int endRow) {
        this.cacheRefreshRows(new OlapQuerySync.ViewArea(startRow, endRow, 0, 100));
    }

    public void cacheRefreshRows(Set<Integer> rows) {
        this.refreshRows = rows;
        if (rows != null) {
            this.getPageCache().put("refreshDataRows", SerializationUtils.toJsonString(rows));
        } else {
            this.removeRefreshRows();
        }
    }

    protected Set<Integer> getRefreshedRows() {
        if (this.refreshRows != null) {
            return this.refreshRows;
        }
        String serial = this.getPageCache().get("refreshDataRows");
        this.refreshRows = StringUtils.isNotEmpty((String)serial) ? (Set<Object>)SerializationUtils.fromJsonString((String)serial, Set.class) : new HashSet<Integer>();
        return this.refreshRows;
    }

    protected void removeRefreshRows() {
        this.getPageCache().remove("refreshDataRows");
        this.refreshRows = new HashSet<Integer>();
    }

    protected boolean isViewDataRefreshed(OlapQuerySync.ViewArea viewArea) {
        Set<Integer> rows = this.getRefreshedRows();
        if (rows == null || rows.isEmpty()) {
            return false;
        }
        if (viewArea == null) {
            return false;
        }
        Integer minRow = (Integer)rows.stream().min(Integer::compareTo).get();
        Integer maxRow = (Integer)rows.stream().max(Integer::compareTo).get();
        boolean noJumpRows = maxRow - minRow == rows.size() - 1;
        return noJumpRows && minRow <= viewArea.getStartrow() && maxRow >= viewArea.getEndrow();
    }

    protected OlapQuerySync.ViewArea viewAreaToRefresh(OlapQuerySync.ViewArea viewArea, boolean isUpScore) {
        if (viewArea != null) {
            int i;
            Integer count = null;
            try {
                count = (Integer)ParamQueryServiceHelper.getChildValue((long)this.getModelId(), (ParamEnum)ParamEnum.BG065, (String)"defaultloadrow");
                int diff = viewArea.getEndrow() - viewArea.getStartrow();
                if (count < diff) {
                    count = diff;
                }
            }
            catch (Exception e) {
                logger.error("load params error:", (Throwable)e);
                count = 1000;
            }
            logger.info("viewAreaToRefresh:begin: " + viewArea + "isUpScore:" + isUpScore);
            int startRow = viewArea.getStartrow();
            int endRow = viewArea.getEndrow();
            this.refreshRows = this.getRefreshedRows();
            int notRefreshedRowStart = startRow;
            boolean isAllRowsRefreshed = true;
            if (!isUpScore) {
                for (i = startRow; i <= endRow; ++i) {
                    if (this.refreshRows.contains(i)) continue;
                    notRefreshedRowStart = i;
                    isAllRowsRefreshed = false;
                    break;
                }
            } else {
                for (i = endRow; i >= startRow; --i) {
                    if (this.refreshRows.contains(i)) continue;
                    notRefreshedRowStart = i;
                    isAllRowsRefreshed = false;
                    break;
                }
            }
            if (isAllRowsRefreshed) {
                logger.info("viewAreaToRefresh:all rows refreshed: " + viewArea);
                return null;
            }
            OlapQuerySync.ViewArea viewAreaToRefresh = isUpScore ? new OlapQuerySync.ViewArea(notRefreshedRowStart - count < 0 ? 0 : notRefreshedRowStart - count, notRefreshedRowStart, viewArea.getStartcol(), viewArea.getEndcol()) : new OlapQuerySync.ViewArea(notRefreshedRowStart, notRefreshedRowStart + count, viewArea.getStartcol(), viewArea.getEndcol());
            logger.info("viewAreaToRefresh:resetting " + viewArea + " to " + viewAreaToRefresh + ", count=" + count + ", refreshRows=" + this.refreshRows);
            return viewAreaToRefresh;
        }
        return viewArea;
    }

    protected void cacheLastViewArea(OlapQuerySync.ViewArea viewArea) {
        if (viewArea == null) {
            this.getPageCache().remove("lastViewArea");
            this.getPageCache().remove("prevTopRow");
        } else {
            this.getPageCache().put("lastViewArea", ObjectSerialUtil.toByteSerialized((Object)viewArea));
        }
    }

    protected OlapQuerySync.ViewArea getLastViewArea() {
        String serial = this.getPageCache().get("lastViewArea");
        if (StringUtils.isNotEmpty((String)serial)) {
            return (OlapQuerySync.ViewArea)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return null;
    }

    protected void cacheSyncData(ISheet sync_sheet, String dataunit, String pageid) {
        PageCache pageCache = new PageCache(pageid);
        EbSpreadManager ebSpreadManager = new EbSpreadManager();
        ebSpreadManager.setEbook(new EBook(new String[0]));
        ebSpreadManager.getEbook().addSheet(sync_sheet);
        pageCache.put("syncSheetValue", EbSpreadManagerSerializerUtil.toJson(ebSpreadManager));
        pageCache.put("syncSheetUnit", dataunit);
    }

    protected void clearSyncData() {
        this.getPageCache().remove("syncSheetValue");
        this.getPageCache().remove("syncSheetUnit");
        this.getPageCache().remove("syncAllDataFinished");
    }

    protected ISheet getSyncSheetValue() {
        String serial = this.getPageCache().get("syncSheetValue");
        if (StringUtils.isEmpty((String)serial)) {
            return null;
        }
        IEbSpreadManager ebSpreadManager_temp = EbSpreadManagerSerializerUtil.read(serial);
        if (ebSpreadManager_temp != null) {
            return ebSpreadManager_temp.getEbook().getSheet(0);
        }
        return null;
    }

    protected String getSyncSheetUnit() {
        return this.getPageCache().get("syncSheetUnit");
    }

    protected boolean canQuickAnalyze() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = formShowParameter.getFormId();
        return "eb_reportqueryprocess".equals(formId) || "eb_executetask".equals(formId) && ("supervisor".equals(formShowParameter.getCustomParam("role")) || StringUtils.isNotEmpty((String)((String)formShowParameter.getCustomParam("approveBill"))));
    }

    public void destory() {
        super.destory();
        ModelCacheContext.remove();
        MemberPropCacheService.remove();
        TemplateCache.remove();
        if (this.isCacheSpreadManager) {
            this.getPageCache().putBigObject(SPREAD_MANANGER_CACHE_KEY, this.ebSpreadManager == null ? null : EbSpreadManagerSerializerUtil.toJson(this.ebSpreadManager));
        }
        this.isCacheSpreadManager = false;
    }

    protected void setCellValueByDisplayType(int dimMemShowType, ECell cell, String memName, List<String> longDisplayDimNums) {
        if (StringUtils.isEmpty((String)memName)) {
            return;
        }
        Object simpleName = cell.getUserObject("simplename");
        Object memNum = cell.getUserObject().containsKey("shnum") ? cell.getUserObject("shnum") : cell.getUserObject("number");
        Object longName = cell.getUserObject("longname");
        Object longNumber = cell.getUserObject("longnumber");
        if (simpleName == null || StringUtils.isEmpty((String)simpleName.toString())) {
            simpleName = memName;
        }
        if (longName == null || StringUtils.isEmpty((String)longName.toString())) {
            longName = memName;
        }
        if (DimPropertyHelper.checkPropertyCell(cell)) {
            memNum = cell.getUserObject("typenum") + "#" + cell.getUserObject("properytnum");
        }
        if (longNumber == null || StringUtils.isEmpty((String)longNumber.toString())) {
            longNumber = memNum;
        }
        if (MemberDisplayTypeEnum.NAME.getIndex() == dimMemShowType || MemberDisplayTypeEnum.LONGNAME.getIndex() == dimMemShowType) {
            cell.setValue(memName);
        } else if (MemberDisplayTypeEnum.SIMPLENAME.getIndex() == dimMemShowType) {
            cell.setValue(simpleName);
        } else if (MemberDisplayTypeEnum.NUMBER.getIndex() == dimMemShowType || MemberDisplayTypeEnum.LONGNUMBER.getIndex() == dimMemShowType) {
            cell.setValue(memNum);
        } else if (MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == dimMemShowType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == dimMemShowType) {
            cell.setValue(memName + ":" + memNum);
        } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == dimMemShowType) {
            cell.setValue(simpleName + ":" + memNum);
        }
        this.setCellValueByLongDisplayType(dimMemShowType, cell, longDisplayDimNums, longName, longNumber);
    }

    protected void setCellValueByLongDisplayType(int dimMemShowType, ECell cell, List<String> longDisplayDimNums, Object longName, Object longNumber) {
        if (cell == null || CollectionUtils.isEmpty(longDisplayDimNums)) {
            return;
        }
        Object dimnum = cell.getUserObject("dimnumber");
        if (dimnum instanceof String && longDisplayDimNums.contains(dimnum.toString())) {
            if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == dimMemShowType) {
                cell.setValue(longNumber);
            } else if (MemberDisplayTypeEnum.LONGNAME.getIndex() == dimMemShowType) {
                cell.setValue(longName);
            } else if (MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == dimMemShowType) {
                cell.setValue(longName + ":" + longNumber);
            }
        }
    }

    public void writeLog(String keyWord, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String[] opDescArgs) {
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)keyWord, (String)opKey, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])opDescArgs);
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }
}

