/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class FixSpreadLockContext {
    private boolean stopcommand = false;
    private IEbSpreadManager ebSpreadManager;
    private ITemplateModel templateModel;
    private List<AreasStyle> areasStyles = new ArrayList<AreasStyle>();
    private Map<String, Object> params = new HashMap<String, Object>(16);
    private Long processId;
    private String processType;
    private IFormView formView;
    private boolean isImportData = false;

    public boolean isImportData() {
        return this.isImportData;
    }

    public void setImportData(boolean importData) {
        this.isImportData = importData;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public FixSpreadLockContext(IEbSpreadManager ebSpreadManager, ITemplateModel templateModel) {
        this.ebSpreadManager = ebSpreadManager;
        this.templateModel = templateModel;
    }

    public boolean isStopcommand() {
        return this.stopcommand;
    }

    public void setStopcommand(boolean stopcommand) {
        this.stopcommand = stopcommand;
    }

    public IEbSpreadManager getEbSpreadManager() {
        return this.ebSpreadManager;
    }

    public void setEbSpreadManager(IEbSpreadManager ebSpreadManager) {
        this.ebSpreadManager = ebSpreadManager;
    }

    public ITemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(ITemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    public List<AreasStyle> getAreasStyles() {
        return this.areasStyles;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public void lockAllData(String foreColor, String backColor) {
        AreasStyle areasStyle = null;
        for (MultiAreaManager multiAreaManager : this.ebSpreadManager.getMultiAreaManager()) {
            MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
            int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
            int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
            CellArea cellArea = new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start(), rows, cols);
            if (areasStyle == null) {
                areasStyle = multiAreaManager.isUserStyle() ? this.getAreaStyle() : this.getAreaStyle(foreColor, backColor);
            }
            areasStyle.getRange().add(cellArea);
        }
        if (areasStyle != null) {
            this.areasStyles.add(areasStyle);
        }
    }

    public void lockAllData() {
        AreasStyle areasStyle = null;
        for (MultiAreaManager multiAreaManager : this.ebSpreadManager.getMultiAreaManager()) {
            MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
            int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
            int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
            CellArea cellArea = new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start(), rows, cols);
            if (areasStyle == null) {
                areasStyle = multiAreaManager.isUserStyle() ? this.getAreaStyle() : this.getAreaStyle(null, "#E6E8EE");
            }
            areasStyle.getRange().add(cellArea);
        }
        if (areasStyle != null) {
            this.areasStyles.add(areasStyle);
        }
    }

    public void lockRowCol(String foreColor, String backColor, int rowcol, MultiAreaManager multiAreaManager, boolean isrow) {
        AreasStyle areasStyle = multiAreaManager.isUserStyle() ? this.getAreaStyle() : this.getAreaStyle(foreColor, backColor);
        MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
        int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
        int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
        CellArea cellArea = isrow ? new CellArea(valueAreaPoint.getData_row_start() + rowcol, valueAreaPoint.getData_col_start(), 1, cols) : new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start() + rowcol, rows, 1);
        areasStyle.getRange().add(cellArea);
    }

    public void lockRowCol(String foreColor, String backColor, MultiAreaManager multiAreaManager, boolean isrow, Set<Integer> locks, Map<Integer, Set<Integer>> lockRowCols) {
        int size;
        AreasStyle areasStyle = multiAreaManager.isUserStyle() ? this.getAreaStyle() : this.getAreaStyle(foreColor, backColor);
        MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
        int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
        int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
        int n = size = isrow ? cols : rows;
        if (locks != null) {
            for (Integer n2 : locks) {
                for (int i = 0; i < size; ++i) {
                    areasStyle.getRange().add(new CellArea(valueAreaPoint.getData_row_start() + (isrow ? n2 : i), valueAreaPoint.getData_col_start() + (isrow ? i : n2), 1, 1));
                }
            }
        }
        if (lockRowCols != null) {
            for (Map.Entry entry : lockRowCols.entrySet()) {
                Integer lock = (Integer)entry.getKey();
                Set set = (Set)entry.getValue();
                for (Integer i : set) {
                    areasStyle.getRange().add(new CellArea(valueAreaPoint.getData_row_start() + (isrow ? lock : i), valueAreaPoint.getData_col_start() + (isrow ? i : lock), 1, 1));
                }
            }
        }
    }

    public void lockRowCol(String foreColor, String backColor, int row, int col, MultiAreaManager multiAreaManager) {
        AreasStyle areasStyle = multiAreaManager.isUserStyle() ? this.getAreaStyle() : this.getAreaStyle(foreColor, backColor);
        MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
        areasStyle.getRange().add(new CellArea(valueAreaPoint.getData_row_start() + row, valueAreaPoint.getData_col_start() + col, 1, 1));
    }

    public AreasStyle getAreaStyle(String foreColor, String backColor) {
        if (backColor == null) {
            backColor = "#FFF8E1";
        }
        AreasStyle areasStyle = new AreasStyle();
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setBkc(backColor);
        if (foreColor != null) {
            cellStyleInfo.setFrc(foreColor);
        }
        cellStyleInfo.setL(true);
        areasStyle.setStyle(cellStyleInfo);
        areasStyle.setRange(new ArrayList<CellArea>());
        this.areasStyles.add(areasStyle);
        return areasStyle;
    }

    public AreasStyle getAreaStyle() {
        AreasStyle areasStyle = new AreasStyle();
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setL(true);
        areasStyle.setStyle(cellStyleInfo);
        areasStyle.setRange(new ArrayList<CellArea>());
        this.areasStyles.add(areasStyle);
        return areasStyle;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

